///////////////////////////////////////////////////////
//  Copyright (c) 2009 Xilinx Inc.
//  All Right Reserved.
///////////////////////////////////////////////////////
//
//   ____   ___
//  /   /\/   / 
// /___/  \  /     Vendor      : Xilinx 
// \  \    \/      Version : 10.1
//  \  \           Description : Xilinx Functional Simulation Library Component
//  /  /                      
// /__/   /\       Filename    : PCIE_2_0.v
// \  \  /  \ 
//  \__\/\__ \                    
//                                 
//  Revision:		1.0
//  05/30/08 - CR - Initial version
//  06/18/08 - CR - removed PIPETXSWING, added PLSELLNKWIDTH.
//  07/23/08 - CR1014 - CFGLINKCONTROLRCB typo updated in yml
//  08/29/08 - CR1014 - Added assign statements, instantiation
//  09/16/08 - CR1014 - Added specify block
//  09/23/08 - CR490337 - assign buffer updates _delay to delay_
//                      - specify block updates to bit & buses
//  10/13/08 - CR492333  - PCIE_2_0 yml parameter updates
//  10/13/08 - CR492334 - update PCIE_2_0_INST to B_PCIE_2_0_INST
//  11/04/08 - CR493971 - SIM_VERSION real to string
//  11/05/08 - CR495046 - replace case with if for parameter type integer - writer enhancement
//  01/27/09 - CR505569 - Writer update
//  02/18/09 - CR509025 - New pins & timing paths added
//  03/11/09 - CR511750 - Update attribute value to upper case
//  04/13/09 - CR518461 - Connect 4 new pins LNKCLKEN, CFGPMCSR* to RTL
//  05/05/09 - CR520519 - Update specify block from 100ps to 0ps
///////////////////////////////////////////////////////

`timescale 1 ps / 1 ps 

module PCIE_2_0 (
  CFGAERECRCCHECKEN,
  CFGAERECRCGENEN,
  CFGCOMMANDBUSMASTERENABLE,
  CFGCOMMANDINTERRUPTDISABLE,
  CFGCOMMANDIOENABLE,
  CFGCOMMANDMEMENABLE,
  CFGCOMMANDSERREN,
  CFGDEVCONTROL2CPLTIMEOUTDIS,
  CFGDEVCONTROL2CPLTIMEOUTVAL,
  CFGDEVCONTROLAUXPOWEREN,
  CFGDEVCONTROLCORRERRREPORTINGEN,
  CFGDEVCONTROLENABLERO,
  CFGDEVCONTROLEXTTAGEN,
  CFGDEVCONTROLFATALERRREPORTINGEN,
  CFGDEVCONTROLMAXPAYLOAD,
  CFGDEVCONTROLMAXREADREQ,
  CFGDEVCONTROLNONFATALREPORTINGEN,
  CFGDEVCONTROLNOSNOOPEN,
  CFGDEVCONTROLPHANTOMEN,
  CFGDEVCONTROLURERRREPORTINGEN,
  CFGDEVSTATUSCORRERRDETECTED,
  CFGDEVSTATUSFATALERRDETECTED,
  CFGDEVSTATUSNONFATALERRDETECTED,
  CFGDEVSTATUSURDETECTED,
  CFGDO,
  CFGERRAERHEADERLOGSETN,
  CFGERRCPLRDYN,
  CFGINTERRUPTDO,
  CFGINTERRUPTMMENABLE,
  CFGINTERRUPTMSIENABLE,
  CFGINTERRUPTMSIXENABLE,
  CFGINTERRUPTMSIXFM,
  CFGINTERRUPTRDYN,
  CFGLINKCONTROLASPMCONTROL,
  CFGLINKCONTROLAUTOBANDWIDTHINTEN,
  CFGLINKCONTROLBANDWIDTHINTEN,
  CFGLINKCONTROLCLOCKPMEN,
  CFGLINKCONTROLCOMMONCLOCK,
  CFGLINKCONTROLEXTENDEDSYNC,
  CFGLINKCONTROLHWAUTOWIDTHDIS,
  CFGLINKCONTROLLINKDISABLE,
  CFGLINKCONTROLRCB,
  CFGLINKCONTROLRETRAINLINK,
  CFGLINKSTATUSAUTOBANDWIDTHSTATUS,
  CFGLINKSTATUSBANDWITHSTATUS,
  CFGLINKSTATUSCURRENTSPEED,
  CFGLINKSTATUSDLLACTIVE,
  CFGLINKSTATUSLINKTRAINING,
  CFGLINKSTATUSNEGOTIATEDWIDTH,
  CFGMSGDATA,
  CFGMSGRECEIVED,
  CFGMSGRECEIVEDASSERTINTA,
  CFGMSGRECEIVEDASSERTINTB,
  CFGMSGRECEIVEDASSERTINTC,
  CFGMSGRECEIVEDASSERTINTD,
  CFGMSGRECEIVEDDEASSERTINTA,
  CFGMSGRECEIVEDDEASSERTINTB,
  CFGMSGRECEIVEDDEASSERTINTC,
  CFGMSGRECEIVEDDEASSERTINTD,
  CFGMSGRECEIVEDERRCOR,
  CFGMSGRECEIVEDERRFATAL,
  CFGMSGRECEIVEDERRNONFATAL,
  CFGMSGRECEIVEDPMASNAK,
  CFGMSGRECEIVEDPMETO,
  CFGMSGRECEIVEDPMETOACK,
  CFGMSGRECEIVEDPMPME,
  CFGMSGRECEIVEDSETSLOTPOWERLIMIT,
  CFGMSGRECEIVEDUNLOCK,
  CFGPCIELINKSTATE,
  CFGPMCSRPMEEN,
  CFGPMCSRPMESTATUS,
  CFGPMCSRPOWERSTATE,	 
  CFGPMRCVASREQL1N,
  CFGPMRCVENTERL1N,
  CFGPMRCVENTERL23N,
  CFGPMRCVREQACKN,
  CFGRDWRDONEN,
  CFGSLOTCONTROLELECTROMECHILCTLPULSE,
  CFGTRANSACTION,
  CFGTRANSACTIONADDR,
  CFGTRANSACTIONTYPE,
  CFGVCTCVCMAP,
  DBGSCLRA,
  DBGSCLRB,
  DBGSCLRC,
  DBGSCLRD,
  DBGSCLRE,
  DBGSCLRF,
  DBGSCLRG,
  DBGSCLRH,
  DBGSCLRI,
  DBGSCLRJ,
  DBGSCLRK,
  DBGVECA,
  DBGVECB,
  DBGVECC,
  DRPDO,
  DRPDRDY,
  LL2BADDLLPERRN,
  LL2BADTLPERRN,
  LL2PROTOCOLERRN,
  LL2REPLAYROERRN,
  LL2REPLAYTOERRN,
  LL2SUSPENDOKN,
  LL2TFCINIT1SEQN,
  LL2TFCINIT2SEQN,
  LNKCLKEN,		 
  MIMRXRADDR,
  MIMRXRCE,
  MIMRXREN,
  MIMRXWADDR,
  MIMRXWDATA,
  MIMRXWEN,
  MIMTXRADDR,
  MIMTXRCE,
  MIMTXREN,
  MIMTXWADDR,
  MIMTXWDATA,
  MIMTXWEN,
  PIPERX0POLARITY,
  PIPERX1POLARITY,
  PIPERX2POLARITY,
  PIPERX3POLARITY,
  PIPERX4POLARITY,
  PIPERX5POLARITY,
  PIPERX6POLARITY,
  PIPERX7POLARITY,
  PIPETX0CHARISK,
  PIPETX0COMPLIANCE,
  PIPETX0DATA,
  PIPETX0ELECIDLE,
  PIPETX0POWERDOWN,
  PIPETX1CHARISK,
  PIPETX1COMPLIANCE,
  PIPETX1DATA,
  PIPETX1ELECIDLE,
  PIPETX1POWERDOWN,
  PIPETX2CHARISK,
  PIPETX2COMPLIANCE,
  PIPETX2DATA,
  PIPETX2ELECIDLE,
  PIPETX2POWERDOWN,
  PIPETX3CHARISK,
  PIPETX3COMPLIANCE,
  PIPETX3DATA,
  PIPETX3ELECIDLE,
  PIPETX3POWERDOWN,
  PIPETX4CHARISK,
  PIPETX4COMPLIANCE,
  PIPETX4DATA,
  PIPETX4ELECIDLE,
  PIPETX4POWERDOWN,
  PIPETX5CHARISK,
  PIPETX5COMPLIANCE,
  PIPETX5DATA,
  PIPETX5ELECIDLE,
  PIPETX5POWERDOWN,
  PIPETX6CHARISK,
  PIPETX6COMPLIANCE,
  PIPETX6DATA,
  PIPETX6ELECIDLE,
  PIPETX6POWERDOWN,
  PIPETX7CHARISK,
  PIPETX7COMPLIANCE,
  PIPETX7DATA,
  PIPETX7ELECIDLE,
  PIPETX7POWERDOWN,
  PIPETXDEEMPH,
  PIPETXMARGIN,
  PIPETXRATE,
  PIPETXRCVRDET,
  PIPETXRESET,
  PL2LINKUPN,
  PL2RECEIVERERRN,
  PL2RECOVERYN,
  PL2RXELECIDLE,
  PL2SUSPENDOK,
  PLDBGVEC,
  PLINITIALLINKWIDTH,
  PLLANEREVERSALMODE,
  PLLINKGEN2CAP,
  PLLINKPARTNERGEN2SUPPORTED,
  PLLINKUPCFGCAP,
  PLLTSSMSTATE,
  PLPHYLNKUPN,
  PLRECEIVEDHOTRST,
  PLRXPMSTATE,
  PLSELLNKRATE,
  PLSELLNKWIDTH,
  PLTXPMSTATE,
  RECEIVEDFUNCLVLRSTN,
  TL2ASPMSUSPENDCREDITCHECKOKN,
  TL2ASPMSUSPENDREQN,
  TL2PPMSUSPENDOKN,
  TRNFCCPLD,
  TRNFCCPLH,
  TRNFCNPD,
  TRNFCNPH,
  TRNFCPD,
  TRNFCPH,
  TRNLNKUPN,
  TRNRBARHITN,
  TRNRD,
  TRNRDLLPDATA,
  TRNRDLLPSRCRDYN,
  TRNRECRCERRN,
  TRNREOFN,
  TRNRERRFWDN,
  TRNRREMN,
  TRNRSOFN,
  TRNRSRCDSCN,
  TRNRSRCRDYN,
  TRNTBUFAV,
  TRNTCFGREQN,
  TRNTDLLPDSTRDYN,
  TRNTDSTRDYN,
  TRNTERRDROPN,
  USERRSTN,
  CFGBYTEENN,
  CFGDI,
  CFGDSBUSNUMBER,
  CFGDSDEVICENUMBER,
  CFGDSFUNCTIONNUMBER,
  CFGDSN,
  CFGDWADDR,
  CFGERRACSN,
  CFGERRAERHEADERLOG,
  CFGERRCORN,
  CFGERRCPLABORTN,
  CFGERRCPLTIMEOUTN,
  CFGERRCPLUNEXPECTN,
  CFGERRECRCN,
  CFGERRLOCKEDN,
  CFGERRPOSTEDN,
  CFGERRTLPCPLHEADER,
  CFGERRURN,
  CFGINTERRUPTASSERTN,
  CFGINTERRUPTDI,
  CFGINTERRUPTN,
  CFGPMDIRECTASPML1N,
  CFGPMSENDPMACKN,
  CFGPMSENDPMETON,
  CFGPMSENDPMNAKN,
  CFGPMTURNOFFOKN,
  CFGPMWAKEN,
  CFGPORTNUMBER,
  CFGRDENN,
  CFGTRNPENDINGN,
  CFGWRENN,
  CFGWRREADONLYN,
  CFGWRRW1CASRWN,
  CMRSTN,
  CMSTICKYRSTN,
  DBGMODE,
  DBGSUBMODE,
  DLRSTN,
  DRPCLK,
  DRPDADDR,
  DRPDEN,
  DRPDI,
  DRPDWE,
  FUNCLVLRSTN,
  LL2SENDASREQL1N,
  LL2SENDENTERL1N,
  LL2SENDENTERL23N,
  LL2SUSPENDNOWN,
  LL2TLPRCVN,
  MIMRXRDATA,
  MIMTXRDATA,
  PIPECLK,
  PIPERX0CHANISALIGNED,
  PIPERX0CHARISK,
  PIPERX0DATA,
  PIPERX0ELECIDLE,
  PIPERX0PHYSTATUS,
  PIPERX0STATUS,
  PIPERX0VALID,
  PIPERX1CHANISALIGNED,
  PIPERX1CHARISK,
  PIPERX1DATA,
  PIPERX1ELECIDLE,
  PIPERX1PHYSTATUS,
  PIPERX1STATUS,
  PIPERX1VALID,
  PIPERX2CHANISALIGNED,
  PIPERX2CHARISK,
  PIPERX2DATA,
  PIPERX2ELECIDLE,
  PIPERX2PHYSTATUS,
  PIPERX2STATUS,
  PIPERX2VALID,
  PIPERX3CHANISALIGNED,
  PIPERX3CHARISK,
  PIPERX3DATA,
  PIPERX3ELECIDLE,
  PIPERX3PHYSTATUS,
  PIPERX3STATUS,
  PIPERX3VALID,
  PIPERX4CHANISALIGNED,
  PIPERX4CHARISK,
  PIPERX4DATA,
  PIPERX4ELECIDLE,
  PIPERX4PHYSTATUS,
  PIPERX4STATUS,
  PIPERX4VALID,
  PIPERX5CHANISALIGNED,
  PIPERX5CHARISK,
  PIPERX5DATA,
  PIPERX5ELECIDLE,
  PIPERX5PHYSTATUS,
  PIPERX5STATUS,
  PIPERX5VALID,
  PIPERX6CHANISALIGNED,
  PIPERX6CHARISK,
  PIPERX6DATA,
  PIPERX6ELECIDLE,
  PIPERX6PHYSTATUS,
  PIPERX6STATUS,
  PIPERX6VALID,
  PIPERX7CHANISALIGNED,
  PIPERX7CHARISK,
  PIPERX7DATA,
  PIPERX7ELECIDLE,
  PIPERX7PHYSTATUS,
  PIPERX7STATUS,
  PIPERX7VALID,
  PL2DIRECTEDLSTATE,
  PLDBGMODE,
  PLDIRECTEDLINKAUTON,
  PLDIRECTEDLINKCHANGE,
  PLDIRECTEDLINKSPEED,
  PLDIRECTEDLINKWIDTH,
  PLDOWNSTREAMDEEMPHSOURCE,
  PLRSTN,
  PLTRANSMITHOTRST,
  PLUPSTREAMPREFERDEEMPH,
  SYSRSTN,
  TL2ASPMSUSPENDCREDITCHECKN,
  TL2PPMSUSPENDREQN,
  TLRSTN,
  TRNFCSEL,
  TRNRDSTRDYN,
  TRNRNPOKN,
  TRNTCFGGNTN,
  TRNTD,
  TRNTDLLPDATA,
  TRNTDLLPSRCRDYN,
  TRNTECRCGENN,
  TRNTEOFN,
  TRNTERRFWDN,
  TRNTREMN,
  TRNTSOFN,
  TRNTSRCDSCN,
  TRNTSRCRDYN,
  TRNTSTRN,
  USERCLK
);
  parameter [11:0] AER_BASE_PTR = 12'h128;
  parameter AER_CAP_ECRC_CHECK_CAPABLE = "FALSE";
  parameter AER_CAP_ECRC_GEN_CAPABLE = "FALSE";
  parameter [15:0] AER_CAP_ID = 16'h0001;
  parameter [4:0] AER_CAP_INT_MSG_NUM_MSI = 5'h0A;
  parameter [4:0] AER_CAP_INT_MSG_NUM_MSIX = 5'h15;
  parameter [11:0] AER_CAP_NEXTPTR = 12'h160;
  parameter AER_CAP_ON = "FALSE";
  parameter AER_CAP_PERMIT_ROOTERR_UPDATE = "TRUE";
  parameter [3:0] AER_CAP_VERSION = 4'h1;
  parameter ALLOW_X8_GEN2 = "FALSE";
  parameter [31:0] BAR0 = 32'hFFFFFF00;
  parameter [31:0] BAR1 = 32'hFFFF0000;
  parameter [31:0] BAR2 = 32'hFFFF000C;
  parameter [31:0] BAR3 = 32'hFFFFFFFF;
  parameter [31:0] BAR4 = 32'h00000000;
  parameter [31:0] BAR5 = 32'h00000000;
  parameter [7:0] CAPABILITIES_PTR = 8'h40;
  parameter [31:0] CARDBUS_CIS_POINTER = 32'h00000000;
  parameter [23:0] CLASS_CODE = 24'h000000;
  parameter CMD_INTX_IMPLEMENTED = "TRUE";
  parameter CPL_TIMEOUT_DISABLE_SUPPORTED = "FALSE";
  parameter [3:0] CPL_TIMEOUT_RANGES_SUPPORTED = 4'h0;
  parameter [6:0] CRM_MODULE_RSTS = 7'h00;
  parameter [15:0] DEVICE_ID = 16'h0007;
  parameter DEV_CAP_ENABLE_SLOT_PWR_LIMIT_SCALE = "TRUE";
  parameter DEV_CAP_ENABLE_SLOT_PWR_LIMIT_VALUE = "TRUE";
  parameter integer DEV_CAP_ENDPOINT_L0S_LATENCY = 0;
  parameter integer DEV_CAP_ENDPOINT_L1_LATENCY = 0;
  parameter DEV_CAP_EXT_TAG_SUPPORTED = "TRUE";
  parameter DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE = "FALSE";
  parameter integer DEV_CAP_MAX_PAYLOAD_SUPPORTED = 2;
  parameter integer DEV_CAP_PHANTOM_FUNCTIONS_SUPPORT = 0;
  parameter DEV_CAP_ROLE_BASED_ERROR = "TRUE";
  parameter integer DEV_CAP_RSVD_14_12 = 0;
  parameter integer DEV_CAP_RSVD_17_16 = 0;
  parameter integer DEV_CAP_RSVD_31_29 = 0;
  parameter DEV_CONTROL_AUX_POWER_SUPPORTED = "FALSE";
  parameter DISABLE_ASPM_L1_TIMER = "FALSE";
  parameter DISABLE_BAR_FILTERING = "FALSE";
  parameter DISABLE_ID_CHECK = "FALSE";
  parameter DISABLE_LANE_REVERSAL = "FALSE";
  parameter DISABLE_RX_TC_FILTER = "FALSE";
  parameter DISABLE_SCRAMBLING = "FALSE";
  parameter [7:0] DNSTREAM_LINK_NUM = 8'h00;
  parameter [11:0] DSN_BASE_PTR = 12'h100;
  parameter [15:0] DSN_CAP_ID = 16'h0003;
  parameter [11:0] DSN_CAP_NEXTPTR = 12'h000;
  parameter DSN_CAP_ON = "TRUE";
  parameter [3:0] DSN_CAP_VERSION = 4'h1;
  parameter [10:0] ENABLE_MSG_ROUTE = 11'h000;
  parameter ENABLE_RX_TD_ECRC_TRIM = "FALSE";
  parameter ENTER_RVRY_EI_L0 = "TRUE";
  parameter EXIT_LOOPBACK_ON_EI = "TRUE";
  parameter [31:0] EXPANSION_ROM = 32'hFFFFF001;
  parameter [5:0] EXT_CFG_CAP_PTR = 6'h3F;
  parameter [9:0] EXT_CFG_XP_CAP_PTR = 10'h3FF;
  parameter [7:0] HEADER_TYPE = 8'h00;
  parameter [4:0] INFER_EI = 5'h00;
  parameter [7:0] INTERRUPT_PIN = 8'h01;
  parameter IS_SWITCH = "FALSE";
  parameter [9:0] LAST_CONFIG_DWORD = 10'h042;
  parameter integer LINK_CAP_ASPM_SUPPORT = 1;
  parameter LINK_CAP_CLOCK_POWER_MANAGEMENT = "FALSE";
  parameter LINK_CAP_DLL_LINK_ACTIVE_REPORTING_CAP = "FALSE";
  parameter integer LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1 = 7;
  parameter integer LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2 = 7;
  parameter integer LINK_CAP_L0S_EXIT_LATENCY_GEN1 = 7;
  parameter integer LINK_CAP_L0S_EXIT_LATENCY_GEN2 = 7;
  parameter integer LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1 = 7;
  parameter integer LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2 = 7;
  parameter integer LINK_CAP_L1_EXIT_LATENCY_GEN1 = 7;
  parameter integer LINK_CAP_L1_EXIT_LATENCY_GEN2 = 7;
  parameter LINK_CAP_LINK_BANDWIDTH_NOTIFICATION_CAP = "FALSE";
  parameter [3:0] LINK_CAP_MAX_LINK_SPEED = 4'h1;
  parameter [5:0] LINK_CAP_MAX_LINK_WIDTH = 6'h08;
  parameter integer LINK_CAP_RSVD_23_22 = 0;
  parameter LINK_CAP_SURPRISE_DOWN_ERROR_CAPABLE = "FALSE";
  parameter integer LINK_CONTROL_RCB = 0;
  parameter LINK_CTRL2_DEEMPHASIS = "FALSE";
  parameter LINK_CTRL2_HW_AUTONOMOUS_SPEED_DISABLE = "FALSE";
  parameter [3:0] LINK_CTRL2_TARGET_LINK_SPEED = 4'h2;
  parameter LINK_STATUS_SLOT_CLOCK_CONFIG = "TRUE";
  parameter [14:0] LL_ACK_TIMEOUT = 15'h0000;
  parameter LL_ACK_TIMEOUT_EN = "FALSE";
  parameter integer LL_ACK_TIMEOUT_FUNC = 0;
  parameter [14:0] LL_REPLAY_TIMEOUT = 15'h0000;
  parameter LL_REPLAY_TIMEOUT_EN = "FALSE";
  parameter integer LL_REPLAY_TIMEOUT_FUNC = 0;
  parameter [5:0] LTSSM_MAX_LINK_WIDTH = 6'h01;
  parameter [7:0] MSIX_BASE_PTR = 8'h9C;
  parameter [7:0] MSIX_CAP_ID = 8'h11;
  parameter [7:0] MSIX_CAP_NEXTPTR = 8'h00;
  parameter MSIX_CAP_ON = "FALSE";
  parameter integer MSIX_CAP_PBA_BIR = 0;
  parameter [28:0] MSIX_CAP_PBA_OFFSET = 29'h00000050;
  parameter integer MSIX_CAP_TABLE_BIR = 0;
  parameter [28:0] MSIX_CAP_TABLE_OFFSET = 29'h00000040;
  parameter [10:0] MSIX_CAP_TABLE_SIZE = 11'h000;
  parameter [7:0] MSI_BASE_PTR = 8'h48;
  parameter MSI_CAP_64_BIT_ADDR_CAPABLE = "TRUE";
  parameter [7:0] MSI_CAP_ID = 8'h05;
  parameter integer MSI_CAP_MULTIMSGCAP = 0;
  parameter integer MSI_CAP_MULTIMSG_EXTENSION = 0;
  parameter [7:0] MSI_CAP_NEXTPTR = 8'h60;
  parameter MSI_CAP_ON = "FALSE";
  parameter MSI_CAP_PER_VECTOR_MASKING_CAPABLE = "TRUE";
  parameter integer N_FTS_COMCLK_GEN1 = 255;
  parameter integer N_FTS_COMCLK_GEN2 = 255;
  parameter integer N_FTS_GEN1 = 255;
  parameter integer N_FTS_GEN2 = 255;
  parameter [7:0] PCIE_BASE_PTR = 8'h60;
  parameter [7:0] PCIE_CAP_CAPABILITY_ID = 8'h10;
  parameter [3:0] PCIE_CAP_CAPABILITY_VERSION = 4'h2;
  parameter [3:0] PCIE_CAP_DEVICE_PORT_TYPE = 4'h0;
  parameter [4:0] PCIE_CAP_INT_MSG_NUM = 5'h00;
  parameter [7:0] PCIE_CAP_NEXTPTR = 8'h00;
  parameter PCIE_CAP_ON = "TRUE";
  parameter integer PCIE_CAP_RSVD_15_14 = 0;
  parameter PCIE_CAP_SLOT_IMPLEMENTED = "FALSE";
  parameter integer PCIE_REVISION = 2;
  parameter integer PGL0_LANE = 0;
  parameter integer PGL1_LANE = 1;
  parameter integer PGL2_LANE = 2;
  parameter integer PGL3_LANE = 3;
  parameter integer PGL4_LANE = 4;
  parameter integer PGL5_LANE = 5;
  parameter integer PGL6_LANE = 6;
  parameter integer PGL7_LANE = 7;
  parameter integer PL_AUTO_CONFIG = 0;
  parameter PL_FAST_TRAIN = "FALSE";
  parameter [7:0] PM_BASE_PTR = 8'h40;
  parameter integer PM_CAP_AUXCURRENT = 0;
  parameter PM_CAP_D1SUPPORT = "TRUE";
  parameter PM_CAP_D2SUPPORT = "TRUE";
  parameter PM_CAP_DSI = "FALSE";
  parameter [7:0] PM_CAP_ID = 8'h01;
  parameter [7:0] PM_CAP_NEXTPTR = 8'h48;
  parameter PM_CAP_ON = "TRUE";
  parameter [4:0] PM_CAP_PMESUPPORT = 5'h0F;
  parameter PM_CAP_PME_CLOCK = "FALSE";
  parameter integer PM_CAP_RSVD_04 = 0;
  parameter integer PM_CAP_VERSION = 3;
  parameter PM_CSR_B2B3 = "FALSE";
  parameter PM_CSR_BPCCEN = "FALSE";
  parameter PM_CSR_NOSOFTRST = "TRUE";
  parameter [7:0] PM_DATA0 = 8'h01;
  parameter [7:0] PM_DATA1 = 8'h01;
  parameter [7:0] PM_DATA2 = 8'h01;
  parameter [7:0] PM_DATA3 = 8'h01;
  parameter [7:0] PM_DATA4 = 8'h01;
  parameter [7:0] PM_DATA5 = 8'h01;
  parameter [7:0] PM_DATA6 = 8'h01;
  parameter [7:0] PM_DATA7 = 8'h01;
  parameter [1:0] PM_DATA_SCALE0 = 2'h1;
  parameter [1:0] PM_DATA_SCALE1 = 2'h1;
  parameter [1:0] PM_DATA_SCALE2 = 2'h1;
  parameter [1:0] PM_DATA_SCALE3 = 2'h1;
  parameter [1:0] PM_DATA_SCALE4 = 2'h1;
  parameter [1:0] PM_DATA_SCALE5 = 2'h1;
  parameter [1:0] PM_DATA_SCALE6 = 2'h1;
  parameter [1:0] PM_DATA_SCALE7 = 2'h1;
  parameter integer RECRC_CHK = 0;
  parameter RECRC_CHK_TRIM = "FALSE";
  parameter [7:0] REVISION_ID = 8'h00;
  parameter ROOT_CAP_CRS_SW_VISIBILITY = "FALSE";
  parameter SELECT_DLL_IF = "FALSE";
  parameter SIM_VERSION = "1.0";
  parameter SLOT_CAP_ATT_BUTTON_PRESENT = "FALSE";
  parameter SLOT_CAP_ATT_INDICATOR_PRESENT = "FALSE";
  parameter SLOT_CAP_ELEC_INTERLOCK_PRESENT = "FALSE";
  parameter SLOT_CAP_HOTPLUG_CAPABLE = "FALSE";
  parameter SLOT_CAP_HOTPLUG_SURPRISE = "FALSE";
  parameter SLOT_CAP_MRL_SENSOR_PRESENT = "FALSE";
  parameter SLOT_CAP_NO_CMD_COMPLETED_SUPPORT = "FALSE";
  parameter [12:0] SLOT_CAP_PHYSICAL_SLOT_NUM = 13'h0000;
  parameter SLOT_CAP_POWER_CONTROLLER_PRESENT = "FALSE";
  parameter SLOT_CAP_POWER_INDICATOR_PRESENT = "FALSE";
  parameter integer SLOT_CAP_SLOT_POWER_LIMIT_SCALE = 0;
  parameter [7:0] SLOT_CAP_SLOT_POWER_LIMIT_VALUE = 8'h00;
  parameter integer SPARE_BIT0 = 0;
  parameter integer SPARE_BIT1 = 0;
  parameter integer SPARE_BIT2 = 0;
  parameter integer SPARE_BIT3 = 0;
  parameter integer SPARE_BIT4 = 0;
  parameter integer SPARE_BIT5 = 0;
  parameter integer SPARE_BIT6 = 0;
  parameter integer SPARE_BIT7 = 0;
  parameter integer SPARE_BIT8 = 0;
  parameter [7:0] SPARE_BYTE0 = 8'h00;
  parameter [7:0] SPARE_BYTE1 = 8'h00;
  parameter [7:0] SPARE_BYTE2 = 8'h00;
  parameter [7:0] SPARE_BYTE3 = 8'h00;
  parameter [31:0] SPARE_WORD0 = 32'h00000000;
  parameter [31:0] SPARE_WORD1 = 32'h00000000;
  parameter [31:0] SPARE_WORD2 = 32'h00000000;
  parameter [31:0] SPARE_WORD3 = 32'h00000000;
  parameter [15:0] SUBSYSTEM_ID = 16'h0007;
  parameter [15:0] SUBSYSTEM_VENDOR_ID = 16'h10EE;
  parameter TL_RBYPASS = "FALSE";
  parameter integer TL_RX_RAM_RADDR_LATENCY = 0;
  parameter integer TL_RX_RAM_RDATA_LATENCY = 2;
  parameter integer TL_RX_RAM_WRITE_LATENCY = 0;
  parameter TL_TFC_DISABLE = "FALSE";
  parameter TL_TX_CHECKS_DISABLE = "FALSE";
  parameter integer TL_TX_RAM_RADDR_LATENCY = 0;
  parameter integer TL_TX_RAM_RDATA_LATENCY = 2;
  parameter integer TL_TX_RAM_WRITE_LATENCY = 0;
  parameter UPCONFIG_CAPABLE = "TRUE";
  parameter UPSTREAM_FACING = "TRUE";
  parameter UR_INV_REQ = "TRUE";
  parameter integer USER_CLK_FREQ = 3;
  parameter VC0_CPL_INFINITE = "TRUE";
  parameter [12:0] VC0_RX_RAM_LIMIT = 13'h03FF;
  parameter integer VC0_TOTAL_CREDITS_CD = 127;
  parameter integer VC0_TOTAL_CREDITS_CH = 31;
  parameter integer VC0_TOTAL_CREDITS_NPH = 12;
  parameter integer VC0_TOTAL_CREDITS_PD = 288;
  parameter integer VC0_TOTAL_CREDITS_PH = 32;
  parameter integer VC0_TX_LASTPACKET = 31;
  parameter [11:0] VC_BASE_PTR = 12'h10C;
  parameter [15:0] VC_CAP_ID = 16'h0002;
  parameter [11:0] VC_CAP_NEXTPTR = 12'h000;
  parameter VC_CAP_ON = "FALSE";
  parameter VC_CAP_REJECT_SNOOP_TRANSACTIONS = "FALSE";
  parameter [3:0] VC_CAP_VERSION = 4'h1;
  parameter [15:0] VENDOR_ID = 16'h10EE;
  parameter [11:0] VSEC_BASE_PTR = 12'h160;
  parameter [15:0] VSEC_CAP_HDR_ID = 16'h1234;
  parameter [11:0] VSEC_CAP_HDR_LENGTH = 12'h018;
  parameter [3:0] VSEC_CAP_HDR_REVISION = 4'h1;
  parameter [15:0] VSEC_CAP_ID = 16'h000B;
  parameter VSEC_CAP_IS_LINK_VISIBLE = "TRUE";
  parameter [11:0] VSEC_CAP_NEXTPTR = 12'h000;
  parameter VSEC_CAP_ON = "FALSE";
  parameter [3:0] VSEC_CAP_VERSION = 4'h1;
  
  localparam in_delay = 0;
  localparam out_delay = 0;
  localparam INCLK_DELAY = 0;
  localparam OUTCLK_DELAY = 0;
  
  output CFGAERECRCCHECKEN;
  output CFGAERECRCGENEN;
  output CFGCOMMANDBUSMASTERENABLE;
  output CFGCOMMANDINTERRUPTDISABLE;
  output CFGCOMMANDIOENABLE;
  output CFGCOMMANDMEMENABLE;
  output CFGCOMMANDSERREN;
  output CFGDEVCONTROL2CPLTIMEOUTDIS;
  output CFGDEVCONTROLAUXPOWEREN;
  output CFGDEVCONTROLCORRERRREPORTINGEN;
  output CFGDEVCONTROLENABLERO;
  output CFGDEVCONTROLEXTTAGEN;
  output CFGDEVCONTROLFATALERRREPORTINGEN;
  output CFGDEVCONTROLNONFATALREPORTINGEN;
  output CFGDEVCONTROLNOSNOOPEN;
  output CFGDEVCONTROLPHANTOMEN;
  output CFGDEVCONTROLURERRREPORTINGEN;
  output CFGDEVSTATUSCORRERRDETECTED;
  output CFGDEVSTATUSFATALERRDETECTED;
  output CFGDEVSTATUSNONFATALERRDETECTED;
  output CFGDEVSTATUSURDETECTED;
  output CFGERRAERHEADERLOGSETN;
  output CFGERRCPLRDYN;
  output CFGINTERRUPTMSIENABLE;
  output CFGINTERRUPTMSIXENABLE;
  output CFGINTERRUPTMSIXFM;
  output CFGINTERRUPTRDYN;
  output CFGLINKCONTROLAUTOBANDWIDTHINTEN;
  output CFGLINKCONTROLBANDWIDTHINTEN;
  output CFGLINKCONTROLCLOCKPMEN;
  output CFGLINKCONTROLCOMMONCLOCK;
  output CFGLINKCONTROLEXTENDEDSYNC;
  output CFGLINKCONTROLHWAUTOWIDTHDIS;
  output CFGLINKCONTROLLINKDISABLE;
  output CFGLINKCONTROLRCB;
  output CFGLINKCONTROLRETRAINLINK;
  output CFGLINKSTATUSAUTOBANDWIDTHSTATUS;
  output CFGLINKSTATUSBANDWITHSTATUS;
  output CFGLINKSTATUSDLLACTIVE;
  output CFGLINKSTATUSLINKTRAINING;
  output CFGMSGRECEIVED;
  output CFGMSGRECEIVEDASSERTINTA;
  output CFGMSGRECEIVEDASSERTINTB;
  output CFGMSGRECEIVEDASSERTINTC;
  output CFGMSGRECEIVEDASSERTINTD;
  output CFGMSGRECEIVEDDEASSERTINTA;
  output CFGMSGRECEIVEDDEASSERTINTB;
  output CFGMSGRECEIVEDDEASSERTINTC;
  output CFGMSGRECEIVEDDEASSERTINTD;
  output CFGMSGRECEIVEDERRCOR;
  output CFGMSGRECEIVEDERRFATAL;
  output CFGMSGRECEIVEDERRNONFATAL;
  output CFGMSGRECEIVEDPMASNAK;
  output CFGMSGRECEIVEDPMETO;
  output CFGMSGRECEIVEDPMETOACK;
  output CFGMSGRECEIVEDPMPME;
  output CFGMSGRECEIVEDSETSLOTPOWERLIMIT;
  output CFGMSGRECEIVEDUNLOCK;
  output CFGPMCSRPMEEN;
  output CFGPMCSRPMESTATUS;
  output CFGPMRCVASREQL1N;
  output CFGPMRCVENTERL1N;
  output CFGPMRCVENTERL23N;
  output CFGPMRCVREQACKN;
  output CFGRDWRDONEN;
  output CFGSLOTCONTROLELECTROMECHILCTLPULSE;
  output CFGTRANSACTION;
  output CFGTRANSACTIONTYPE;
  output DBGSCLRA;
  output DBGSCLRB;
  output DBGSCLRC;
  output DBGSCLRD;
  output DBGSCLRE;
  output DBGSCLRF;
  output DBGSCLRG;
  output DBGSCLRH;
  output DBGSCLRI;
  output DBGSCLRJ;
  output DBGSCLRK;
  output DRPDRDY;
  output LL2BADDLLPERRN;
  output LL2BADTLPERRN;
  output LL2PROTOCOLERRN;
  output LL2REPLAYROERRN;
  output LL2REPLAYTOERRN;
  output LL2SUSPENDOKN;
  output LL2TFCINIT1SEQN;
  output LL2TFCINIT2SEQN;
  output LNKCLKEN;
  output MIMRXRCE;
  output MIMRXREN;
  output MIMRXWEN;
  output MIMTXRCE;
  output MIMTXREN;
  output MIMTXWEN;
  output PIPERX0POLARITY;
  output PIPERX1POLARITY;
  output PIPERX2POLARITY;
  output PIPERX3POLARITY;
  output PIPERX4POLARITY;
  output PIPERX5POLARITY;
  output PIPERX6POLARITY;
  output PIPERX7POLARITY;
  output PIPETX0COMPLIANCE;
  output PIPETX0ELECIDLE;
  output PIPETX1COMPLIANCE;
  output PIPETX1ELECIDLE;
  output PIPETX2COMPLIANCE;
  output PIPETX2ELECIDLE;
  output PIPETX3COMPLIANCE;
  output PIPETX3ELECIDLE;
  output PIPETX4COMPLIANCE;
  output PIPETX4ELECIDLE;
  output PIPETX5COMPLIANCE;
  output PIPETX5ELECIDLE;
  output PIPETX6COMPLIANCE;
  output PIPETX6ELECIDLE;
  output PIPETX7COMPLIANCE;
  output PIPETX7ELECIDLE;
  output PIPETXDEEMPH;
  output PIPETXRATE;
  output PIPETXRCVRDET;
  output PIPETXRESET;
  output PL2LINKUPN;
  output PL2RECEIVERERRN;
  output PL2RECOVERYN;
  output PL2RXELECIDLE;
  output PL2SUSPENDOK;
  output PLLINKGEN2CAP;
  output PLLINKPARTNERGEN2SUPPORTED;
  output PLLINKUPCFGCAP;
  output PLPHYLNKUPN;
  output PLRECEIVEDHOTRST;
  output PLSELLNKRATE;
  output RECEIVEDFUNCLVLRSTN;
  output TL2ASPMSUSPENDCREDITCHECKOKN;
  output TL2ASPMSUSPENDREQN;
  output TL2PPMSUSPENDOKN;
  output TRNLNKUPN;
  output TRNRDLLPSRCRDYN;
  output TRNRECRCERRN;
  output TRNREOFN;
  output TRNRERRFWDN;
  output TRNRREMN;
  output TRNRSOFN;
  output TRNRSRCDSCN;
  output TRNRSRCRDYN;
  output TRNTCFGREQN;
  output TRNTDLLPDSTRDYN;
  output TRNTDSTRDYN;
  output TRNTERRDROPN;
  output USERRSTN;
  output [11:0] DBGVECC;
  output [11:0] PLDBGVEC;
  output [11:0] TRNFCCPLD;
  output [11:0] TRNFCNPD;
  output [11:0] TRNFCPD;
  output [12:0] MIMRXRADDR;
  output [12:0] MIMRXWADDR;
  output [12:0] MIMTXRADDR;
  output [12:0] MIMTXWADDR;
  output [15:0] CFGMSGDATA;
  output [15:0] DRPDO;
  output [15:0] PIPETX0DATA;
  output [15:0] PIPETX1DATA;
  output [15:0] PIPETX2DATA;
  output [15:0] PIPETX3DATA;
  output [15:0] PIPETX4DATA;
  output [15:0] PIPETX5DATA;
  output [15:0] PIPETX6DATA;
  output [15:0] PIPETX7DATA;
  output [1:0] CFGLINKCONTROLASPMCONTROL;
  output [1:0] CFGLINKSTATUSCURRENTSPEED;
  output [1:0] CFGPMCSRPOWERSTATE;
  output [1:0] PIPETX0CHARISK;
  output [1:0] PIPETX0POWERDOWN;
  output [1:0] PIPETX1CHARISK;
  output [1:0] PIPETX1POWERDOWN;
  output [1:0] PIPETX2CHARISK;
  output [1:0] PIPETX2POWERDOWN;
  output [1:0] PIPETX3CHARISK;
  output [1:0] PIPETX3POWERDOWN;
  output [1:0] PIPETX4CHARISK;
  output [1:0] PIPETX4POWERDOWN;
  output [1:0] PIPETX5CHARISK;
  output [1:0] PIPETX5POWERDOWN;
  output [1:0] PIPETX6CHARISK;
  output [1:0] PIPETX6POWERDOWN;
  output [1:0] PIPETX7CHARISK;
  output [1:0] PIPETX7POWERDOWN;
  output [1:0] PLLANEREVERSALMODE;
  output [1:0] PLRXPMSTATE;
  output [1:0] PLSELLNKWIDTH;
  output [2:0] CFGDEVCONTROLMAXPAYLOAD;
  output [2:0] CFGDEVCONTROLMAXREADREQ;
  output [2:0] CFGINTERRUPTMMENABLE;
  output [2:0] CFGPCIELINKSTATE;
  output [2:0] PIPETXMARGIN;
  output [2:0] PLINITIALLINKWIDTH;
  output [2:0] PLTXPMSTATE;
  output [31:0] CFGDO;
  output [31:0] TRNRDLLPDATA;
  output [3:0] CFGDEVCONTROL2CPLTIMEOUTVAL;
  output [3:0] CFGLINKSTATUSNEGOTIATEDWIDTH;
  output [5:0] PLLTSSMSTATE;
  output [5:0] TRNTBUFAV;
  output [63:0] DBGVECA;
  output [63:0] DBGVECB;
  output [63:0] TRNRD;
  output [67:0] MIMRXWDATA;
  output [68:0] MIMTXWDATA;
  output [6:0] CFGTRANSACTIONADDR;
  output [6:0] CFGVCTCVCMAP;
  output [6:0] TRNRBARHITN;
  output [7:0] CFGINTERRUPTDO;
  output [7:0] TRNFCCPLH;
  output [7:0] TRNFCNPH;
  output [7:0] TRNFCPH;

  input CFGERRACSN;
  input CFGERRCORN;
  input CFGERRCPLABORTN;
  input CFGERRCPLTIMEOUTN;
  input CFGERRCPLUNEXPECTN;
  input CFGERRECRCN;
  input CFGERRLOCKEDN;
  input CFGERRPOSTEDN;
  input CFGERRURN;
  input CFGINTERRUPTASSERTN;
  input CFGINTERRUPTN;
  input CFGPMDIRECTASPML1N;
  input CFGPMSENDPMACKN;
  input CFGPMSENDPMETON;
  input CFGPMSENDPMNAKN;
  input CFGPMTURNOFFOKN;
  input CFGPMWAKEN;
  input CFGRDENN;
  input CFGTRNPENDINGN;
  input CFGWRENN;
  input CFGWRREADONLYN;
  input CFGWRRW1CASRWN;
  input CMRSTN;
  input CMSTICKYRSTN;
  input DBGSUBMODE;
  input DLRSTN;
  input DRPCLK;
  input DRPDEN;
  input DRPDWE;
  input FUNCLVLRSTN;
  input LL2SENDASREQL1N;
  input LL2SENDENTERL1N;
  input LL2SENDENTERL23N;
  input LL2SUSPENDNOWN;
  input LL2TLPRCVN;
  input PIPECLK;
  input PIPERX0CHANISALIGNED;
  input PIPERX0ELECIDLE;
  input PIPERX0PHYSTATUS;
  input PIPERX0VALID;
  input PIPERX1CHANISALIGNED;
  input PIPERX1ELECIDLE;
  input PIPERX1PHYSTATUS;
  input PIPERX1VALID;
  input PIPERX2CHANISALIGNED;
  input PIPERX2ELECIDLE;
  input PIPERX2PHYSTATUS;
  input PIPERX2VALID;
  input PIPERX3CHANISALIGNED;
  input PIPERX3ELECIDLE;
  input PIPERX3PHYSTATUS;
  input PIPERX3VALID;
  input PIPERX4CHANISALIGNED;
  input PIPERX4ELECIDLE;
  input PIPERX4PHYSTATUS;
  input PIPERX4VALID;
  input PIPERX5CHANISALIGNED;
  input PIPERX5ELECIDLE;
  input PIPERX5PHYSTATUS;
  input PIPERX5VALID;
  input PIPERX6CHANISALIGNED;
  input PIPERX6ELECIDLE;
  input PIPERX6PHYSTATUS;
  input PIPERX6VALID;
  input PIPERX7CHANISALIGNED;
  input PIPERX7ELECIDLE;
  input PIPERX7PHYSTATUS;
  input PIPERX7VALID;
  input PLDIRECTEDLINKAUTON;
  input PLDIRECTEDLINKSPEED;
  input PLDOWNSTREAMDEEMPHSOURCE;
  input PLRSTN;
  input PLTRANSMITHOTRST;
  input PLUPSTREAMPREFERDEEMPH;
  input SYSRSTN;
  input TL2ASPMSUSPENDCREDITCHECKN;
  input TL2PPMSUSPENDREQN;
  input TLRSTN;
  input TRNRDSTRDYN;
  input TRNRNPOKN;
  input TRNTCFGGNTN;
  input TRNTDLLPSRCRDYN;
  input TRNTECRCGENN;
  input TRNTEOFN;
  input TRNTERRFWDN;
  input TRNTREMN;
  input TRNTSOFN;
  input TRNTSRCDSCN;
  input TRNTSRCRDYN;
  input TRNTSTRN;
  input USERCLK;
  input [127:0] CFGERRAERHEADERLOG;
  input [15:0] DRPDI;
  input [15:0] PIPERX0DATA;
  input [15:0] PIPERX1DATA;
  input [15:0] PIPERX2DATA;
  input [15:0] PIPERX3DATA;
  input [15:0] PIPERX4DATA;
  input [15:0] PIPERX5DATA;
  input [15:0] PIPERX6DATA;
  input [15:0] PIPERX7DATA;
  input [1:0] DBGMODE;
  input [1:0] PIPERX0CHARISK;
  input [1:0] PIPERX1CHARISK;
  input [1:0] PIPERX2CHARISK;
  input [1:0] PIPERX3CHARISK;
  input [1:0] PIPERX4CHARISK;
  input [1:0] PIPERX5CHARISK;
  input [1:0] PIPERX6CHARISK;
  input [1:0] PIPERX7CHARISK;
  input [1:0] PLDIRECTEDLINKCHANGE;
  input [1:0] PLDIRECTEDLINKWIDTH;
  input [2:0] CFGDSFUNCTIONNUMBER;
  input [2:0] PIPERX0STATUS;
  input [2:0] PIPERX1STATUS;
  input [2:0] PIPERX2STATUS;
  input [2:0] PIPERX3STATUS;
  input [2:0] PIPERX4STATUS;
  input [2:0] PIPERX5STATUS;
  input [2:0] PIPERX6STATUS;
  input [2:0] PIPERX7STATUS;
  input [2:0] PLDBGMODE;
  input [2:0] TRNFCSEL;
  input [31:0] CFGDI;
  input [31:0] TRNTDLLPDATA;
  input [3:0] CFGBYTEENN;
  input [47:0] CFGERRTLPCPLHEADER;
  input [4:0] CFGDSDEVICENUMBER;
  input [4:0] PL2DIRECTEDLSTATE;
  input [63:0] CFGDSN;
  input [63:0] TRNTD;
  input [67:0] MIMRXRDATA;
  input [68:0] MIMTXRDATA;
  input [7:0] CFGDSBUSNUMBER;
  input [7:0] CFGINTERRUPTDI;
  input [7:0] CFGPORTNUMBER;
  input [8:0] DRPDADDR;
  input [9:0] CFGDWADDR;

  reg AER_CAP_ECRC_CHECK_CAPABLE_BINARY;
  reg AER_CAP_ECRC_GEN_CAPABLE_BINARY;
  reg AER_CAP_ON_BINARY;
  reg AER_CAP_PERMIT_ROOTERR_UPDATE_BINARY;
  reg ALLOW_X8_GEN2_BINARY;
  reg CMD_INTX_IMPLEMENTED_BINARY;
  reg CPL_TIMEOUT_DISABLE_SUPPORTED_BINARY;
  reg DEV_CAP_ENABLE_SLOT_PWR_LIMIT_SCALE_BINARY;
  reg DEV_CAP_ENABLE_SLOT_PWR_LIMIT_VALUE_BINARY;
  reg DEV_CAP_EXT_TAG_SUPPORTED_BINARY;
  reg DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE_BINARY;
  reg DEV_CAP_ROLE_BASED_ERROR_BINARY;
  reg DEV_CONTROL_AUX_POWER_SUPPORTED_BINARY;
  reg DISABLE_ASPM_L1_TIMER_BINARY;
  reg DISABLE_BAR_FILTERING_BINARY;
  reg DISABLE_ID_CHECK_BINARY;
  reg DISABLE_LANE_REVERSAL_BINARY;
  reg DISABLE_RX_TC_FILTER_BINARY;
  reg DISABLE_SCRAMBLING_BINARY;
  reg DSN_CAP_ON_BINARY;
  reg ENABLE_RX_TD_ECRC_TRIM_BINARY;
  reg ENTER_RVRY_EI_L0_BINARY;
  reg EXIT_LOOPBACK_ON_EI_BINARY;
  reg IS_SWITCH_BINARY;
  reg LINK_CAP_CLOCK_POWER_MANAGEMENT_BINARY;
  reg LINK_CAP_DLL_LINK_ACTIVE_REPORTING_CAP_BINARY;
  reg LINK_CAP_LINK_BANDWIDTH_NOTIFICATION_CAP_BINARY;
  reg LINK_CAP_SURPRISE_DOWN_ERROR_CAPABLE_BINARY;
  reg LINK_CONTROL_RCB_BINARY;
  reg LINK_CTRL2_DEEMPHASIS_BINARY;
  reg LINK_CTRL2_HW_AUTONOMOUS_SPEED_DISABLE_BINARY;
  reg LINK_STATUS_SLOT_CLOCK_CONFIG_BINARY;
  reg LL_ACK_TIMEOUT_EN_BINARY;
  reg LL_REPLAY_TIMEOUT_EN_BINARY;
  reg MSIX_CAP_ON_BINARY;
  reg MSI_CAP_64_BIT_ADDR_CAPABLE_BINARY;
  reg MSI_CAP_MULTIMSG_EXTENSION_BINARY;
  reg MSI_CAP_ON_BINARY;
  reg MSI_CAP_PER_VECTOR_MASKING_CAPABLE_BINARY;
  reg PCIE_CAP_ON_BINARY;
  reg PCIE_CAP_SLOT_IMPLEMENTED_BINARY;
  reg PL_FAST_TRAIN_BINARY;
  reg PM_CAP_D1SUPPORT_BINARY;
  reg PM_CAP_D2SUPPORT_BINARY;
  reg PM_CAP_DSI_BINARY;
  reg PM_CAP_ON_BINARY;
  reg PM_CAP_PME_CLOCK_BINARY;
  reg PM_CAP_RSVD_04_BINARY;
  reg PM_CSR_B2B3_BINARY;
  reg PM_CSR_BPCCEN_BINARY;
  reg PM_CSR_NOSOFTRST_BINARY;
  reg RECRC_CHK_TRIM_BINARY;
  reg ROOT_CAP_CRS_SW_VISIBILITY_BINARY;
  reg SELECT_DLL_IF_BINARY;
  reg SIM_VERSION_BINARY;
  reg SLOT_CAP_ATT_BUTTON_PRESENT_BINARY;
  reg SLOT_CAP_ATT_INDICATOR_PRESENT_BINARY;
  reg SLOT_CAP_ELEC_INTERLOCK_PRESENT_BINARY;
  reg SLOT_CAP_HOTPLUG_CAPABLE_BINARY;
  reg SLOT_CAP_HOTPLUG_SURPRISE_BINARY;
  reg SLOT_CAP_MRL_SENSOR_PRESENT_BINARY;
  reg SLOT_CAP_NO_CMD_COMPLETED_SUPPORT_BINARY;
  reg SLOT_CAP_POWER_CONTROLLER_PRESENT_BINARY;
  reg SLOT_CAP_POWER_INDICATOR_PRESENT_BINARY;
  reg SPARE_BIT0_BINARY;
  reg SPARE_BIT1_BINARY;
  reg SPARE_BIT2_BINARY;
  reg SPARE_BIT3_BINARY;
  reg SPARE_BIT4_BINARY;
  reg SPARE_BIT5_BINARY;
  reg SPARE_BIT6_BINARY;
  reg SPARE_BIT7_BINARY;
  reg SPARE_BIT8_BINARY;
  reg TL_RBYPASS_BINARY;
  reg TL_RX_RAM_RADDR_LATENCY_BINARY;
  reg TL_RX_RAM_WRITE_LATENCY_BINARY;
  reg TL_TFC_DISABLE_BINARY;
  reg TL_TX_CHECKS_DISABLE_BINARY;
  reg TL_TX_RAM_RADDR_LATENCY_BINARY;
  reg TL_TX_RAM_WRITE_LATENCY_BINARY;
  reg UPCONFIG_CAPABLE_BINARY;
  reg UPSTREAM_FACING_BINARY;
  reg UR_INV_REQ_BINARY;
  reg VC0_CPL_INFINITE_BINARY;
  reg VC_CAP_ON_BINARY;
  reg VC_CAP_REJECT_SNOOP_TRANSACTIONS_BINARY;
  reg VSEC_CAP_IS_LINK_VISIBLE_BINARY;
  reg VSEC_CAP_ON_BINARY;
  reg [10:0] VC0_TOTAL_CREDITS_CD_BINARY;
  reg [10:0] VC0_TOTAL_CREDITS_PD_BINARY;
  reg [1:0] DEV_CAP_PHANTOM_FUNCTIONS_SUPPORT_BINARY;
  reg [1:0] DEV_CAP_RSVD_17_16_BINARY;
  reg [1:0] LINK_CAP_ASPM_SUPPORT_BINARY;
  reg [1:0] LINK_CAP_RSVD_23_22_BINARY;
  reg [1:0] LL_ACK_TIMEOUT_FUNC_BINARY;
  reg [1:0] LL_REPLAY_TIMEOUT_FUNC_BINARY;
  reg [1:0] PCIE_CAP_RSVD_15_14_BINARY;
  reg [1:0] RECRC_CHK_BINARY;
  reg [1:0] SLOT_CAP_SLOT_POWER_LIMIT_SCALE_BINARY;
  reg [1:0] TL_RX_RAM_RDATA_LATENCY_BINARY;
  reg [1:0] TL_TX_RAM_RDATA_LATENCY_BINARY;
  reg [2:0] DEV_CAP_ENDPOINT_L0S_LATENCY_BINARY;
  reg [2:0] DEV_CAP_ENDPOINT_L1_LATENCY_BINARY;
  reg [2:0] DEV_CAP_MAX_PAYLOAD_SUPPORTED_BINARY;
  reg [2:0] DEV_CAP_RSVD_14_12_BINARY;
  reg [2:0] DEV_CAP_RSVD_31_29_BINARY;
  reg [2:0] LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1_BINARY;
  reg [2:0] LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2_BINARY;
  reg [2:0] LINK_CAP_L0S_EXIT_LATENCY_GEN1_BINARY;
  reg [2:0] LINK_CAP_L0S_EXIT_LATENCY_GEN2_BINARY;
  reg [2:0] LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1_BINARY;
  reg [2:0] LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2_BINARY;
  reg [2:0] LINK_CAP_L1_EXIT_LATENCY_GEN1_BINARY;
  reg [2:0] LINK_CAP_L1_EXIT_LATENCY_GEN2_BINARY;
  reg [2:0] MSIX_CAP_PBA_BIR_BINARY;
  reg [2:0] MSIX_CAP_TABLE_BIR_BINARY;
  reg [2:0] MSI_CAP_MULTIMSGCAP_BINARY;
  reg [2:0] PGL0_LANE_BINARY;
  reg [2:0] PGL1_LANE_BINARY;
  reg [2:0] PGL2_LANE_BINARY;
  reg [2:0] PGL3_LANE_BINARY;
  reg [2:0] PGL4_LANE_BINARY;
  reg [2:0] PGL5_LANE_BINARY;
  reg [2:0] PGL6_LANE_BINARY;
  reg [2:0] PGL7_LANE_BINARY;
  reg [2:0] PL_AUTO_CONFIG_BINARY;
  reg [2:0] PM_CAP_AUXCURRENT_BINARY;
  reg [2:0] PM_CAP_VERSION_BINARY;
  reg [2:0] USER_CLK_FREQ_BINARY;
  reg [3:0] PCIE_REVISION_BINARY;
  reg [4:0] VC0_TX_LASTPACKET_BINARY;
  reg [6:0] VC0_TOTAL_CREDITS_CH_BINARY;
  reg [6:0] VC0_TOTAL_CREDITS_NPH_BINARY;
  reg [6:0] VC0_TOTAL_CREDITS_PH_BINARY;
  reg [7:0] N_FTS_COMCLK_GEN1_BINARY;
  reg [7:0] N_FTS_COMCLK_GEN2_BINARY;
  reg [7:0] N_FTS_GEN1_BINARY;
  reg [7:0] N_FTS_GEN2_BINARY;

  tri0 GSR = glbl.GSR;

  initial begin
    case (AER_CAP_ECRC_CHECK_CAPABLE)
      "FALSE" : AER_CAP_ECRC_CHECK_CAPABLE_BINARY = 1'b0;
      "TRUE" : AER_CAP_ECRC_CHECK_CAPABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute AER_CAP_ECRC_CHECK_CAPABLE on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", AER_CAP_ECRC_CHECK_CAPABLE);
        $finish;
      end
    endcase

    case (AER_CAP_ECRC_GEN_CAPABLE)
      "FALSE" : AER_CAP_ECRC_GEN_CAPABLE_BINARY = 1'b0;
      "TRUE" : AER_CAP_ECRC_GEN_CAPABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute AER_CAP_ECRC_GEN_CAPABLE on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", AER_CAP_ECRC_GEN_CAPABLE);
        $finish;
      end
    endcase

    case (AER_CAP_ON)
      "FALSE" : AER_CAP_ON_BINARY = 1'b0;
      "TRUE" : AER_CAP_ON_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute AER_CAP_ON on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", AER_CAP_ON);
        $finish;
      end
    endcase

    case (AER_CAP_PERMIT_ROOTERR_UPDATE)
      "FALSE" : AER_CAP_PERMIT_ROOTERR_UPDATE_BINARY = 1'b0;
      "TRUE" : AER_CAP_PERMIT_ROOTERR_UPDATE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute AER_CAP_PERMIT_ROOTERR_UPDATE on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", AER_CAP_PERMIT_ROOTERR_UPDATE);
        $finish;
      end
    endcase

    case (ALLOW_X8_GEN2)
      "FALSE" : ALLOW_X8_GEN2_BINARY = 1'b0;
      "TRUE" : ALLOW_X8_GEN2_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute ALLOW_X8_GEN2 on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", ALLOW_X8_GEN2);
        $finish;
      end
    endcase

    case (CMD_INTX_IMPLEMENTED)
      "FALSE" : CMD_INTX_IMPLEMENTED_BINARY = 1'b0;
      "TRUE" : CMD_INTX_IMPLEMENTED_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute CMD_INTX_IMPLEMENTED on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", CMD_INTX_IMPLEMENTED);
        $finish;
      end
    endcase

    case (CPL_TIMEOUT_DISABLE_SUPPORTED)
      "FALSE" : CPL_TIMEOUT_DISABLE_SUPPORTED_BINARY = 1'b0;
      "TRUE" : CPL_TIMEOUT_DISABLE_SUPPORTED_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute CPL_TIMEOUT_DISABLE_SUPPORTED on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", CPL_TIMEOUT_DISABLE_SUPPORTED);
        $finish;
      end
    endcase

    case (DEV_CAP_ENABLE_SLOT_PWR_LIMIT_SCALE)
      "FALSE" : DEV_CAP_ENABLE_SLOT_PWR_LIMIT_SCALE_BINARY = 1'b0;
      "TRUE" : DEV_CAP_ENABLE_SLOT_PWR_LIMIT_SCALE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute DEV_CAP_ENABLE_SLOT_PWR_LIMIT_SCALE on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DEV_CAP_ENABLE_SLOT_PWR_LIMIT_SCALE);
        $finish;
      end
    endcase

    case (DEV_CAP_ENABLE_SLOT_PWR_LIMIT_VALUE)
      "FALSE" : DEV_CAP_ENABLE_SLOT_PWR_LIMIT_VALUE_BINARY = 1'b0;
      "TRUE" : DEV_CAP_ENABLE_SLOT_PWR_LIMIT_VALUE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute DEV_CAP_ENABLE_SLOT_PWR_LIMIT_VALUE on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DEV_CAP_ENABLE_SLOT_PWR_LIMIT_VALUE);
        $finish;
      end
    endcase

    case (DEV_CAP_EXT_TAG_SUPPORTED)
      "FALSE" : DEV_CAP_EXT_TAG_SUPPORTED_BINARY = 1'b0;
      "TRUE" : DEV_CAP_EXT_TAG_SUPPORTED_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute DEV_CAP_EXT_TAG_SUPPORTED on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DEV_CAP_EXT_TAG_SUPPORTED);
        $finish;
      end
    endcase

    case (DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE)
      "FALSE" : DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE_BINARY = 1'b0;
      "TRUE" : DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE);
        $finish;
      end
    endcase

    case (DEV_CAP_ROLE_BASED_ERROR)
      "FALSE" : DEV_CAP_ROLE_BASED_ERROR_BINARY = 1'b0;
      "TRUE" : DEV_CAP_ROLE_BASED_ERROR_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute DEV_CAP_ROLE_BASED_ERROR on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DEV_CAP_ROLE_BASED_ERROR);
        $finish;
      end
    endcase

    case (DEV_CONTROL_AUX_POWER_SUPPORTED)
      "FALSE" : DEV_CONTROL_AUX_POWER_SUPPORTED_BINARY = 1'b0;
      "TRUE" : DEV_CONTROL_AUX_POWER_SUPPORTED_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute DEV_CONTROL_AUX_POWER_SUPPORTED on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DEV_CONTROL_AUX_POWER_SUPPORTED);
        $finish;
      end
    endcase

    case (DISABLE_ASPM_L1_TIMER)
      "FALSE" : DISABLE_ASPM_L1_TIMER_BINARY = 1'b0;
      "TRUE" : DISABLE_ASPM_L1_TIMER_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute DISABLE_ASPM_L1_TIMER on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DISABLE_ASPM_L1_TIMER);
        $finish;
      end
    endcase

    case (DISABLE_BAR_FILTERING)
      "FALSE" : DISABLE_BAR_FILTERING_BINARY = 1'b0;
      "TRUE" : DISABLE_BAR_FILTERING_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute DISABLE_BAR_FILTERING on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DISABLE_BAR_FILTERING);
        $finish;
      end
    endcase

    case (DISABLE_ID_CHECK)
      "FALSE" : DISABLE_ID_CHECK_BINARY = 1'b0;
      "TRUE" : DISABLE_ID_CHECK_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute DISABLE_ID_CHECK on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DISABLE_ID_CHECK);
        $finish;
      end
    endcase

    case (DISABLE_LANE_REVERSAL)
      "FALSE" : DISABLE_LANE_REVERSAL_BINARY = 1'b0;
      "TRUE" : DISABLE_LANE_REVERSAL_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute DISABLE_LANE_REVERSAL on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DISABLE_LANE_REVERSAL);
        $finish;
      end
    endcase

    case (DISABLE_RX_TC_FILTER)
      "FALSE" : DISABLE_RX_TC_FILTER_BINARY = 1'b0;
      "TRUE" : DISABLE_RX_TC_FILTER_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute DISABLE_RX_TC_FILTER on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DISABLE_RX_TC_FILTER);
        $finish;
      end
    endcase

    case (DISABLE_SCRAMBLING)
      "FALSE" : DISABLE_SCRAMBLING_BINARY = 1'b0;
      "TRUE" : DISABLE_SCRAMBLING_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute DISABLE_SCRAMBLING on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DISABLE_SCRAMBLING);
        $finish;
      end
    endcase

    case (DSN_CAP_ON)
      "FALSE" : DSN_CAP_ON_BINARY = 1'b0;
      "TRUE" : DSN_CAP_ON_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute DSN_CAP_ON on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DSN_CAP_ON);
        $finish;
      end
    endcase

    case (ENABLE_RX_TD_ECRC_TRIM)
      "FALSE" : ENABLE_RX_TD_ECRC_TRIM_BINARY = 1'b0;
      "TRUE" : ENABLE_RX_TD_ECRC_TRIM_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute ENABLE_RX_TD_ECRC_TRIM on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", ENABLE_RX_TD_ECRC_TRIM);
        $finish;
      end
    endcase

    case (ENTER_RVRY_EI_L0)
      "FALSE" : ENTER_RVRY_EI_L0_BINARY = 1'b0;
      "TRUE" : ENTER_RVRY_EI_L0_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute ENTER_RVRY_EI_L0 on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", ENTER_RVRY_EI_L0);
        $finish;
      end
    endcase

    case (EXIT_LOOPBACK_ON_EI)
      "FALSE" : EXIT_LOOPBACK_ON_EI_BINARY = 1'b0;
      "TRUE" : EXIT_LOOPBACK_ON_EI_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EXIT_LOOPBACK_ON_EI on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EXIT_LOOPBACK_ON_EI);
        $finish;
      end
    endcase

    case (IS_SWITCH)
      "FALSE" : IS_SWITCH_BINARY = 1'b0;
      "TRUE" : IS_SWITCH_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute IS_SWITCH on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", IS_SWITCH);
        $finish;
      end
    endcase

    case (LINK_CAP_CLOCK_POWER_MANAGEMENT)
      "FALSE" : LINK_CAP_CLOCK_POWER_MANAGEMENT_BINARY = 1'b0;
      "TRUE" : LINK_CAP_CLOCK_POWER_MANAGEMENT_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute LINK_CAP_CLOCK_POWER_MANAGEMENT on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", LINK_CAP_CLOCK_POWER_MANAGEMENT);
        $finish;
      end
    endcase

    case (LINK_CAP_DLL_LINK_ACTIVE_REPORTING_CAP)
      "FALSE" : LINK_CAP_DLL_LINK_ACTIVE_REPORTING_CAP_BINARY = 1'b0;
      "TRUE" : LINK_CAP_DLL_LINK_ACTIVE_REPORTING_CAP_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute LINK_CAP_DLL_LINK_ACTIVE_REPORTING_CAP on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", LINK_CAP_DLL_LINK_ACTIVE_REPORTING_CAP);
        $finish;
      end
    endcase

    case (LINK_CAP_LINK_BANDWIDTH_NOTIFICATION_CAP)
      "FALSE" : LINK_CAP_LINK_BANDWIDTH_NOTIFICATION_CAP_BINARY = 1'b0;
      "TRUE" : LINK_CAP_LINK_BANDWIDTH_NOTIFICATION_CAP_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute LINK_CAP_LINK_BANDWIDTH_NOTIFICATION_CAP on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", LINK_CAP_LINK_BANDWIDTH_NOTIFICATION_CAP);
        $finish;
      end
    endcase

    case (LINK_CAP_SURPRISE_DOWN_ERROR_CAPABLE)
      "FALSE" : LINK_CAP_SURPRISE_DOWN_ERROR_CAPABLE_BINARY = 1'b0;
      "TRUE" : LINK_CAP_SURPRISE_DOWN_ERROR_CAPABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute LINK_CAP_SURPRISE_DOWN_ERROR_CAPABLE on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", LINK_CAP_SURPRISE_DOWN_ERROR_CAPABLE);
        $finish;
      end
    endcase

    case (LINK_CTRL2_DEEMPHASIS)
      "FALSE" : LINK_CTRL2_DEEMPHASIS_BINARY = 1'b0;
      "TRUE" : LINK_CTRL2_DEEMPHASIS_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute LINK_CTRL2_DEEMPHASIS on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", LINK_CTRL2_DEEMPHASIS);
        $finish;
      end
    endcase

    case (LINK_CTRL2_HW_AUTONOMOUS_SPEED_DISABLE)
      "FALSE" : LINK_CTRL2_HW_AUTONOMOUS_SPEED_DISABLE_BINARY = 1'b0;
      "TRUE" : LINK_CTRL2_HW_AUTONOMOUS_SPEED_DISABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute LINK_CTRL2_HW_AUTONOMOUS_SPEED_DISABLE on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", LINK_CTRL2_HW_AUTONOMOUS_SPEED_DISABLE);
        $finish;
      end
    endcase

    case (LINK_STATUS_SLOT_CLOCK_CONFIG)
      "FALSE" : LINK_STATUS_SLOT_CLOCK_CONFIG_BINARY = 1'b0;
      "TRUE" : LINK_STATUS_SLOT_CLOCK_CONFIG_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute LINK_STATUS_SLOT_CLOCK_CONFIG on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", LINK_STATUS_SLOT_CLOCK_CONFIG);
        $finish;
      end
    endcase

    case (LL_ACK_TIMEOUT_EN)
      "FALSE" : LL_ACK_TIMEOUT_EN_BINARY = 1'b0;
      "TRUE" : LL_ACK_TIMEOUT_EN_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute LL_ACK_TIMEOUT_EN on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", LL_ACK_TIMEOUT_EN);
        $finish;
      end
    endcase

    case (LL_REPLAY_TIMEOUT_EN)
      "FALSE" : LL_REPLAY_TIMEOUT_EN_BINARY = 1'b0;
      "TRUE" : LL_REPLAY_TIMEOUT_EN_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute LL_REPLAY_TIMEOUT_EN on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", LL_REPLAY_TIMEOUT_EN);
        $finish;
      end
    endcase

    case (MSIX_CAP_ON)
      "FALSE" : MSIX_CAP_ON_BINARY = 1'b0;
      "TRUE" : MSIX_CAP_ON_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute MSIX_CAP_ON on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", MSIX_CAP_ON);
        $finish;
      end
    endcase

    case (MSI_CAP_64_BIT_ADDR_CAPABLE)
      "FALSE" : MSI_CAP_64_BIT_ADDR_CAPABLE_BINARY = 1'b0;
      "TRUE" : MSI_CAP_64_BIT_ADDR_CAPABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute MSI_CAP_64_BIT_ADDR_CAPABLE on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", MSI_CAP_64_BIT_ADDR_CAPABLE);
        $finish;
      end
    endcase

    case (MSI_CAP_ON)
      "FALSE" : MSI_CAP_ON_BINARY = 1'b0;
      "TRUE" : MSI_CAP_ON_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute MSI_CAP_ON on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", MSI_CAP_ON);
        $finish;
      end
    endcase

    case (MSI_CAP_PER_VECTOR_MASKING_CAPABLE)
      "FALSE" : MSI_CAP_PER_VECTOR_MASKING_CAPABLE_BINARY = 1'b0;
      "TRUE" : MSI_CAP_PER_VECTOR_MASKING_CAPABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute MSI_CAP_PER_VECTOR_MASKING_CAPABLE on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", MSI_CAP_PER_VECTOR_MASKING_CAPABLE);
        $finish;
      end
    endcase

    case (PCIE_CAP_ON)
      "FALSE" : PCIE_CAP_ON_BINARY = 1'b0;
      "TRUE" : PCIE_CAP_ON_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute PCIE_CAP_ON on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PCIE_CAP_ON);
        $finish;
      end
    endcase

    case (PCIE_CAP_SLOT_IMPLEMENTED)
      "FALSE" : PCIE_CAP_SLOT_IMPLEMENTED_BINARY = 1'b0;
      "TRUE" : PCIE_CAP_SLOT_IMPLEMENTED_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute PCIE_CAP_SLOT_IMPLEMENTED on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PCIE_CAP_SLOT_IMPLEMENTED);
        $finish;
      end
    endcase

    case (PL_FAST_TRAIN)
      "FALSE" : PL_FAST_TRAIN_BINARY = 1'b0;
      "TRUE" : PL_FAST_TRAIN_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute PL_FAST_TRAIN on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PL_FAST_TRAIN);
        $finish;
      end
    endcase

    case (PM_CAP_D1SUPPORT)
      "FALSE" : PM_CAP_D1SUPPORT_BINARY = 1'b0;
      "TRUE" : PM_CAP_D1SUPPORT_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute PM_CAP_D1SUPPORT on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PM_CAP_D1SUPPORT);
        $finish;
      end
    endcase

    case (PM_CAP_D2SUPPORT)
      "FALSE" : PM_CAP_D2SUPPORT_BINARY = 1'b0;
      "TRUE" : PM_CAP_D2SUPPORT_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute PM_CAP_D2SUPPORT on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PM_CAP_D2SUPPORT);
        $finish;
      end
    endcase

    case (PM_CAP_DSI)
      "FALSE" : PM_CAP_DSI_BINARY = 1'b0;
      "TRUE" : PM_CAP_DSI_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute PM_CAP_DSI on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PM_CAP_DSI);
        $finish;
      end
    endcase

    case (PM_CAP_ON)
      "FALSE" : PM_CAP_ON_BINARY = 1'b0;
      "TRUE" : PM_CAP_ON_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute PM_CAP_ON on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PM_CAP_ON);
        $finish;
      end
    endcase

    case (PM_CAP_PME_CLOCK)
      "FALSE" : PM_CAP_PME_CLOCK_BINARY = 1'b0;
      "TRUE" : PM_CAP_PME_CLOCK_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute PM_CAP_PME_CLOCK on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PM_CAP_PME_CLOCK);
        $finish;
      end
    endcase

    case (PM_CSR_B2B3)
      "FALSE" : PM_CSR_B2B3_BINARY = 1'b0;
      "TRUE" : PM_CSR_B2B3_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute PM_CSR_B2B3 on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PM_CSR_B2B3);
        $finish;
      end
    endcase

    case (PM_CSR_BPCCEN)
      "FALSE" : PM_CSR_BPCCEN_BINARY = 1'b0;
      "TRUE" : PM_CSR_BPCCEN_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute PM_CSR_BPCCEN on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PM_CSR_BPCCEN);
        $finish;
      end
    endcase

    case (PM_CSR_NOSOFTRST)
      "FALSE" : PM_CSR_NOSOFTRST_BINARY = 1'b0;
      "TRUE" : PM_CSR_NOSOFTRST_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute PM_CSR_NOSOFTRST on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PM_CSR_NOSOFTRST);
        $finish;
      end
    endcase

    case (RECRC_CHK_TRIM)
      "FALSE" : RECRC_CHK_TRIM_BINARY = 1'b0;
      "TRUE" : RECRC_CHK_TRIM_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute RECRC_CHK_TRIM on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RECRC_CHK_TRIM);
        $finish;
      end
    endcase

    case (ROOT_CAP_CRS_SW_VISIBILITY)
      "FALSE" : ROOT_CAP_CRS_SW_VISIBILITY_BINARY = 1'b0;
      "TRUE" : ROOT_CAP_CRS_SW_VISIBILITY_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute ROOT_CAP_CRS_SW_VISIBILITY on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", ROOT_CAP_CRS_SW_VISIBILITY);
        $finish;
      end
    endcase

    case (SELECT_DLL_IF)
      "FALSE" : SELECT_DLL_IF_BINARY = 1'b0;
      "TRUE" : SELECT_DLL_IF_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute SELECT_DLL_IF on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SELECT_DLL_IF);
        $finish;
      end
    endcase

    case (SLOT_CAP_ATT_BUTTON_PRESENT)
      "FALSE" : SLOT_CAP_ATT_BUTTON_PRESENT_BINARY = 1'b0;
      "TRUE" : SLOT_CAP_ATT_BUTTON_PRESENT_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute SLOT_CAP_ATT_BUTTON_PRESENT on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SLOT_CAP_ATT_BUTTON_PRESENT);
        $finish;
      end
    endcase

    case (SLOT_CAP_ATT_INDICATOR_PRESENT)
      "FALSE" : SLOT_CAP_ATT_INDICATOR_PRESENT_BINARY = 1'b0;
      "TRUE" : SLOT_CAP_ATT_INDICATOR_PRESENT_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute SLOT_CAP_ATT_INDICATOR_PRESENT on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SLOT_CAP_ATT_INDICATOR_PRESENT);
        $finish;
      end
    endcase

    case (SLOT_CAP_ELEC_INTERLOCK_PRESENT)
      "FALSE" : SLOT_CAP_ELEC_INTERLOCK_PRESENT_BINARY = 1'b0;
      "TRUE" : SLOT_CAP_ELEC_INTERLOCK_PRESENT_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute SLOT_CAP_ELEC_INTERLOCK_PRESENT on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SLOT_CAP_ELEC_INTERLOCK_PRESENT);
        $finish;
      end
    endcase

    case (SLOT_CAP_HOTPLUG_CAPABLE)
      "FALSE" : SLOT_CAP_HOTPLUG_CAPABLE_BINARY = 1'b0;
      "TRUE" : SLOT_CAP_HOTPLUG_CAPABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute SLOT_CAP_HOTPLUG_CAPABLE on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SLOT_CAP_HOTPLUG_CAPABLE);
        $finish;
      end
    endcase

    case (SLOT_CAP_HOTPLUG_SURPRISE)
      "FALSE" : SLOT_CAP_HOTPLUG_SURPRISE_BINARY = 1'b0;
      "TRUE" : SLOT_CAP_HOTPLUG_SURPRISE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute SLOT_CAP_HOTPLUG_SURPRISE on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SLOT_CAP_HOTPLUG_SURPRISE);
        $finish;
      end
    endcase

    case (SLOT_CAP_MRL_SENSOR_PRESENT)
      "FALSE" : SLOT_CAP_MRL_SENSOR_PRESENT_BINARY = 1'b0;
      "TRUE" : SLOT_CAP_MRL_SENSOR_PRESENT_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute SLOT_CAP_MRL_SENSOR_PRESENT on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SLOT_CAP_MRL_SENSOR_PRESENT);
        $finish;
      end
    endcase

    case (SLOT_CAP_NO_CMD_COMPLETED_SUPPORT)
      "FALSE" : SLOT_CAP_NO_CMD_COMPLETED_SUPPORT_BINARY = 1'b0;
      "TRUE" : SLOT_CAP_NO_CMD_COMPLETED_SUPPORT_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute SLOT_CAP_NO_CMD_COMPLETED_SUPPORT on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SLOT_CAP_NO_CMD_COMPLETED_SUPPORT);
        $finish;
      end
    endcase

    case (SLOT_CAP_POWER_CONTROLLER_PRESENT)
      "FALSE" : SLOT_CAP_POWER_CONTROLLER_PRESENT_BINARY = 1'b0;
      "TRUE" : SLOT_CAP_POWER_CONTROLLER_PRESENT_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute SLOT_CAP_POWER_CONTROLLER_PRESENT on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SLOT_CAP_POWER_CONTROLLER_PRESENT);
        $finish;
      end
    endcase

    case (SLOT_CAP_POWER_INDICATOR_PRESENT)
      "FALSE" : SLOT_CAP_POWER_INDICATOR_PRESENT_BINARY = 1'b0;
      "TRUE" : SLOT_CAP_POWER_INDICATOR_PRESENT_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute SLOT_CAP_POWER_INDICATOR_PRESENT on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SLOT_CAP_POWER_INDICATOR_PRESENT);
        $finish;
      end
    endcase

    case (TL_RBYPASS)
      "FALSE" : TL_RBYPASS_BINARY = 1'b0;
      "TRUE" : TL_RBYPASS_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute TL_RBYPASS on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TL_RBYPASS);
        $finish;
      end
    endcase

    case (TL_TFC_DISABLE)
      "FALSE" : TL_TFC_DISABLE_BINARY = 1'b0;
      "TRUE" : TL_TFC_DISABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute TL_TFC_DISABLE on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TL_TFC_DISABLE);
        $finish;
      end
    endcase

    case (TL_TX_CHECKS_DISABLE)
      "FALSE" : TL_TX_CHECKS_DISABLE_BINARY = 1'b0;
      "TRUE" : TL_TX_CHECKS_DISABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute TL_TX_CHECKS_DISABLE on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TL_TX_CHECKS_DISABLE);
        $finish;
      end
    endcase

    case (UPCONFIG_CAPABLE)
      "FALSE" : UPCONFIG_CAPABLE_BINARY = 1'b0;
      "TRUE" : UPCONFIG_CAPABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute UPCONFIG_CAPABLE on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", UPCONFIG_CAPABLE);
        $finish;
      end
    endcase

    case (UPSTREAM_FACING)
      "FALSE" : UPSTREAM_FACING_BINARY = 1'b0;
      "TRUE" : UPSTREAM_FACING_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute UPSTREAM_FACING on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", UPSTREAM_FACING);
        $finish;
      end
    endcase

    case (UR_INV_REQ)
      "FALSE" : UR_INV_REQ_BINARY = 1'b0;
      "TRUE" : UR_INV_REQ_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute UR_INV_REQ on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", UR_INV_REQ);
        $finish;
      end
    endcase

    case (VC0_CPL_INFINITE)
      "FALSE" : VC0_CPL_INFINITE_BINARY = 1'b0;
      "TRUE" : VC0_CPL_INFINITE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute VC0_CPL_INFINITE on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", VC0_CPL_INFINITE);
        $finish;
      end
    endcase

    case (VC_CAP_ON)
      "FALSE" : VC_CAP_ON_BINARY = 1'b0;
      "TRUE" : VC_CAP_ON_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute VC_CAP_ON on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", VC_CAP_ON);
        $finish;
      end
    endcase

    case (VC_CAP_REJECT_SNOOP_TRANSACTIONS)
      "FALSE" : VC_CAP_REJECT_SNOOP_TRANSACTIONS_BINARY = 1'b0;
      "TRUE" : VC_CAP_REJECT_SNOOP_TRANSACTIONS_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute VC_CAP_REJECT_SNOOP_TRANSACTIONS on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", VC_CAP_REJECT_SNOOP_TRANSACTIONS);
        $finish;
      end
    endcase

    case (VSEC_CAP_IS_LINK_VISIBLE)
      "FALSE" : VSEC_CAP_IS_LINK_VISIBLE_BINARY = 1'b0;
      "TRUE" : VSEC_CAP_IS_LINK_VISIBLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute VSEC_CAP_IS_LINK_VISIBLE on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", VSEC_CAP_IS_LINK_VISIBLE);
        $finish;
      end
    endcase

    case (VSEC_CAP_ON)
      "FALSE" : VSEC_CAP_ON_BINARY = 1'b0;
      "TRUE" : VSEC_CAP_ON_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute VSEC_CAP_ON on PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", VSEC_CAP_ON);
        $finish;
      end
    endcase

    if ((DEV_CAP_ENDPOINT_L0S_LATENCY >= 0) && (DEV_CAP_ENDPOINT_L0S_LATENCY <= 7))
      DEV_CAP_ENDPOINT_L0S_LATENCY_BINARY = DEV_CAP_ENDPOINT_L0S_LATENCY;
    else begin
      $display("Attribute Syntax Error : The Attribute DEV_CAP_ENDPOINT_L0S_LATENCY on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", DEV_CAP_ENDPOINT_L0S_LATENCY);
      $finish;
    end

    if ((DEV_CAP_ENDPOINT_L1_LATENCY >= 0) && (DEV_CAP_ENDPOINT_L1_LATENCY <= 7))
      DEV_CAP_ENDPOINT_L1_LATENCY_BINARY = DEV_CAP_ENDPOINT_L1_LATENCY;
    else begin
      $display("Attribute Syntax Error : The Attribute DEV_CAP_ENDPOINT_L1_LATENCY on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", DEV_CAP_ENDPOINT_L1_LATENCY);
      $finish;
    end

    if ((DEV_CAP_MAX_PAYLOAD_SUPPORTED >= 0) && (DEV_CAP_MAX_PAYLOAD_SUPPORTED <= 7))
      DEV_CAP_MAX_PAYLOAD_SUPPORTED_BINARY = DEV_CAP_MAX_PAYLOAD_SUPPORTED;
    else begin
      $display("Attribute Syntax Error : The Attribute DEV_CAP_MAX_PAYLOAD_SUPPORTED on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", DEV_CAP_MAX_PAYLOAD_SUPPORTED);
      $finish;
    end

    if ((DEV_CAP_PHANTOM_FUNCTIONS_SUPPORT >= 0) && (DEV_CAP_PHANTOM_FUNCTIONS_SUPPORT <= 3))
      DEV_CAP_PHANTOM_FUNCTIONS_SUPPORT_BINARY = DEV_CAP_PHANTOM_FUNCTIONS_SUPPORT;
    else begin
      $display("Attribute Syntax Error : The Attribute DEV_CAP_PHANTOM_FUNCTIONS_SUPPORT on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 3.", DEV_CAP_PHANTOM_FUNCTIONS_SUPPORT);
      $finish;
    end

    if ((DEV_CAP_RSVD_14_12 >= 0) && (DEV_CAP_RSVD_14_12 <= 7))
      DEV_CAP_RSVD_14_12_BINARY = DEV_CAP_RSVD_14_12;
    else begin
      $display("Attribute Syntax Error : The Attribute DEV_CAP_RSVD_14_12 on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", DEV_CAP_RSVD_14_12);
      $finish;
    end

    if ((DEV_CAP_RSVD_17_16 >= 0) && (DEV_CAP_RSVD_17_16 <= 3))
      DEV_CAP_RSVD_17_16_BINARY = DEV_CAP_RSVD_17_16;
    else begin
      $display("Attribute Syntax Error : The Attribute DEV_CAP_RSVD_17_16 on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 3.", DEV_CAP_RSVD_17_16);
      $finish;
    end

    if ((DEV_CAP_RSVD_31_29 >= 0) && (DEV_CAP_RSVD_31_29 <= 7))
      DEV_CAP_RSVD_31_29_BINARY = DEV_CAP_RSVD_31_29;
    else begin
      $display("Attribute Syntax Error : The Attribute DEV_CAP_RSVD_31_29 on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", DEV_CAP_RSVD_31_29);
      $finish;
    end

    if ((LINK_CAP_ASPM_SUPPORT >= 0) && (LINK_CAP_ASPM_SUPPORT <= 3))
      LINK_CAP_ASPM_SUPPORT_BINARY = LINK_CAP_ASPM_SUPPORT;
    else begin
      $display("Attribute Syntax Error : The Attribute LINK_CAP_ASPM_SUPPORT on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 3.", LINK_CAP_ASPM_SUPPORT);
      $finish;
    end

    if ((LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1 >= 0) && (LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1 <= 7))
      LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1_BINARY = LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1;
    else begin
      $display("Attribute Syntax Error : The Attribute LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1 on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1);
      $finish;
    end

    if ((LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2 >= 0) && (LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2 <= 7))
      LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2_BINARY = LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2;
    else begin
      $display("Attribute Syntax Error : The Attribute LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2 on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2);
      $finish;
    end

    if ((LINK_CAP_L0S_EXIT_LATENCY_GEN1 >= 0) && (LINK_CAP_L0S_EXIT_LATENCY_GEN1 <= 7))
      LINK_CAP_L0S_EXIT_LATENCY_GEN1_BINARY = LINK_CAP_L0S_EXIT_LATENCY_GEN1;
    else begin
      $display("Attribute Syntax Error : The Attribute LINK_CAP_L0S_EXIT_LATENCY_GEN1 on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", LINK_CAP_L0S_EXIT_LATENCY_GEN1);
      $finish;
    end

    if ((LINK_CAP_L0S_EXIT_LATENCY_GEN2 >= 0) && (LINK_CAP_L0S_EXIT_LATENCY_GEN2 <= 7))
      LINK_CAP_L0S_EXIT_LATENCY_GEN2_BINARY = LINK_CAP_L0S_EXIT_LATENCY_GEN2;
    else begin
      $display("Attribute Syntax Error : The Attribute LINK_CAP_L0S_EXIT_LATENCY_GEN2 on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", LINK_CAP_L0S_EXIT_LATENCY_GEN2);
      $finish;
    end

    if ((LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1 >= 0) && (LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1 <= 7))
      LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1_BINARY = LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1;
    else begin
      $display("Attribute Syntax Error : The Attribute LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1 on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1);
      $finish;
    end

    if ((LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2 >= 0) && (LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2 <= 7))
      LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2_BINARY = LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2;
    else begin
      $display("Attribute Syntax Error : The Attribute LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2 on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2);
      $finish;
    end

    if ((LINK_CAP_L1_EXIT_LATENCY_GEN1 >= 0) && (LINK_CAP_L1_EXIT_LATENCY_GEN1 <= 7))
      LINK_CAP_L1_EXIT_LATENCY_GEN1_BINARY = LINK_CAP_L1_EXIT_LATENCY_GEN1;
    else begin
      $display("Attribute Syntax Error : The Attribute LINK_CAP_L1_EXIT_LATENCY_GEN1 on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", LINK_CAP_L1_EXIT_LATENCY_GEN1);
      $finish;
    end

    if ((LINK_CAP_L1_EXIT_LATENCY_GEN2 >= 0) && (LINK_CAP_L1_EXIT_LATENCY_GEN2 <= 7))
      LINK_CAP_L1_EXIT_LATENCY_GEN2_BINARY = LINK_CAP_L1_EXIT_LATENCY_GEN2;
    else begin
      $display("Attribute Syntax Error : The Attribute LINK_CAP_L1_EXIT_LATENCY_GEN2 on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", LINK_CAP_L1_EXIT_LATENCY_GEN2);
      $finish;
    end

    if ((LINK_CAP_RSVD_23_22 >= 0) && (LINK_CAP_RSVD_23_22 <= 3))
      LINK_CAP_RSVD_23_22_BINARY = LINK_CAP_RSVD_23_22;
    else begin
      $display("Attribute Syntax Error : The Attribute LINK_CAP_RSVD_23_22 on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 3.", LINK_CAP_RSVD_23_22);
      $finish;
    end

    if ((LINK_CONTROL_RCB >= 0) && (LINK_CONTROL_RCB <= 1))
      LINK_CONTROL_RCB_BINARY = LINK_CONTROL_RCB;
    else begin
      $display("Attribute Syntax Error : The Attribute LINK_CONTROL_RCB on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 1.", LINK_CONTROL_RCB);
      $finish;
    end

    if ((LL_ACK_TIMEOUT_FUNC >= 0) && (LL_ACK_TIMEOUT_FUNC <= 3))
      LL_ACK_TIMEOUT_FUNC_BINARY = LL_ACK_TIMEOUT_FUNC;
    else begin
      $display("Attribute Syntax Error : The Attribute LL_ACK_TIMEOUT_FUNC on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 3.", LL_ACK_TIMEOUT_FUNC);
      $finish;
    end

    if ((LL_REPLAY_TIMEOUT_FUNC >= 0) && (LL_REPLAY_TIMEOUT_FUNC <= 3))
      LL_REPLAY_TIMEOUT_FUNC_BINARY = LL_REPLAY_TIMEOUT_FUNC;
    else begin
      $display("Attribute Syntax Error : The Attribute LL_REPLAY_TIMEOUT_FUNC on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 3.", LL_REPLAY_TIMEOUT_FUNC);
      $finish;
    end

    if ((MSIX_CAP_PBA_BIR >= 0) && (MSIX_CAP_PBA_BIR <= 7))
      MSIX_CAP_PBA_BIR_BINARY = MSIX_CAP_PBA_BIR;
    else begin
      $display("Attribute Syntax Error : The Attribute MSIX_CAP_PBA_BIR on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", MSIX_CAP_PBA_BIR);
      $finish;
    end

    if ((MSIX_CAP_TABLE_BIR >= 0) && (MSIX_CAP_TABLE_BIR <= 7))
      MSIX_CAP_TABLE_BIR_BINARY = MSIX_CAP_TABLE_BIR;
    else begin
      $display("Attribute Syntax Error : The Attribute MSIX_CAP_TABLE_BIR on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", MSIX_CAP_TABLE_BIR);
      $finish;
    end

    if ((MSI_CAP_MULTIMSGCAP >= 0) && (MSI_CAP_MULTIMSGCAP <= 7))
      MSI_CAP_MULTIMSGCAP_BINARY = MSI_CAP_MULTIMSGCAP;
    else begin
      $display("Attribute Syntax Error : The Attribute MSI_CAP_MULTIMSGCAP on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", MSI_CAP_MULTIMSGCAP);
      $finish;
    end

    if ((MSI_CAP_MULTIMSG_EXTENSION >= 0) && (MSI_CAP_MULTIMSG_EXTENSION <= 1))
      MSI_CAP_MULTIMSG_EXTENSION_BINARY = MSI_CAP_MULTIMSG_EXTENSION;
    else begin
      $display("Attribute Syntax Error : The Attribute MSI_CAP_MULTIMSG_EXTENSION on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 1.", MSI_CAP_MULTIMSG_EXTENSION);
      $finish;
    end

    if ((N_FTS_COMCLK_GEN1 >= 0) && (N_FTS_COMCLK_GEN1 <= 255))
      N_FTS_COMCLK_GEN1_BINARY = N_FTS_COMCLK_GEN1;
    else begin
      $display("Attribute Syntax Error : The Attribute N_FTS_COMCLK_GEN1 on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 255.", N_FTS_COMCLK_GEN1);
      $finish;
    end

    if ((N_FTS_COMCLK_GEN2 >= 0) && (N_FTS_COMCLK_GEN2 <= 255))
      N_FTS_COMCLK_GEN2_BINARY = N_FTS_COMCLK_GEN2;
    else begin
      $display("Attribute Syntax Error : The Attribute N_FTS_COMCLK_GEN2 on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 255.", N_FTS_COMCLK_GEN2);
      $finish;
    end

    if ((N_FTS_GEN1 >= 0) && (N_FTS_GEN1 <= 255))
      N_FTS_GEN1_BINARY = N_FTS_GEN1;
    else begin
      $display("Attribute Syntax Error : The Attribute N_FTS_GEN1 on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 255.", N_FTS_GEN1);
      $finish;
    end

    if ((N_FTS_GEN2 >= 0) && (N_FTS_GEN2 <= 255))
      N_FTS_GEN2_BINARY = N_FTS_GEN2;
    else begin
      $display("Attribute Syntax Error : The Attribute N_FTS_GEN2 on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 255.", N_FTS_GEN2);
      $finish;
    end

    if ((PCIE_CAP_RSVD_15_14 >= 0) && (PCIE_CAP_RSVD_15_14 <= 3))
      PCIE_CAP_RSVD_15_14_BINARY = PCIE_CAP_RSVD_15_14;
    else begin
      $display("Attribute Syntax Error : The Attribute PCIE_CAP_RSVD_15_14 on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 3.", PCIE_CAP_RSVD_15_14);
      $finish;
    end

    if ((PCIE_REVISION >= 0) && (PCIE_REVISION <= 15))
      PCIE_REVISION_BINARY = PCIE_REVISION;
    else begin
      $display("Attribute Syntax Error : The Attribute PCIE_REVISION on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 15.", PCIE_REVISION);
      $finish;
    end

    if ((PGL0_LANE >= 0) && (PGL0_LANE <= 7))
      PGL0_LANE_BINARY = PGL0_LANE;
    else begin
      $display("Attribute Syntax Error : The Attribute PGL0_LANE on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", PGL0_LANE);
      $finish;
    end

    if ((PGL1_LANE >= 0) && (PGL1_LANE <= 7))
      PGL1_LANE_BINARY = PGL1_LANE;
    else begin
      $display("Attribute Syntax Error : The Attribute PGL1_LANE on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", PGL1_LANE);
      $finish;
    end

    if ((PGL2_LANE >= 0) && (PGL2_LANE <= 7))
      PGL2_LANE_BINARY = PGL2_LANE;
    else begin
      $display("Attribute Syntax Error : The Attribute PGL2_LANE on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", PGL2_LANE);
      $finish;
    end

    if ((PGL3_LANE >= 0) && (PGL3_LANE <= 7))
      PGL3_LANE_BINARY = PGL3_LANE;
    else begin
      $display("Attribute Syntax Error : The Attribute PGL3_LANE on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", PGL3_LANE);
      $finish;
    end

    if ((PGL4_LANE >= 0) && (PGL4_LANE <= 7))
      PGL4_LANE_BINARY = PGL4_LANE;
    else begin
      $display("Attribute Syntax Error : The Attribute PGL4_LANE on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", PGL4_LANE);
      $finish;
    end

    if ((PGL5_LANE >= 0) && (PGL5_LANE <= 7))
      PGL5_LANE_BINARY = PGL5_LANE;
    else begin
      $display("Attribute Syntax Error : The Attribute PGL5_LANE on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", PGL5_LANE);
      $finish;
    end

    if ((PGL6_LANE >= 0) && (PGL6_LANE <= 7))
      PGL6_LANE_BINARY = PGL6_LANE;
    else begin
      $display("Attribute Syntax Error : The Attribute PGL6_LANE on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", PGL6_LANE);
      $finish;
    end

    if ((PGL7_LANE >= 0) && (PGL7_LANE <= 7))
      PGL7_LANE_BINARY = PGL7_LANE;
    else begin
      $display("Attribute Syntax Error : The Attribute PGL7_LANE on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", PGL7_LANE);
      $finish;
    end

    if ((PL_AUTO_CONFIG >= 0) && (PL_AUTO_CONFIG <= 7))
      PL_AUTO_CONFIG_BINARY = PL_AUTO_CONFIG;
    else begin
      $display("Attribute Syntax Error : The Attribute PL_AUTO_CONFIG on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", PL_AUTO_CONFIG);
      $finish;
    end

    if ((PM_CAP_AUXCURRENT >= 0) && (PM_CAP_AUXCURRENT <= 7))
      PM_CAP_AUXCURRENT_BINARY = PM_CAP_AUXCURRENT;
    else begin
      $display("Attribute Syntax Error : The Attribute PM_CAP_AUXCURRENT on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", PM_CAP_AUXCURRENT);
      $finish;
    end

    if ((PM_CAP_RSVD_04 >= 0) && (PM_CAP_RSVD_04 <= 1))
      PM_CAP_RSVD_04_BINARY = PM_CAP_RSVD_04;
    else begin
      $display("Attribute Syntax Error : The Attribute PM_CAP_RSVD_04 on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 1.", PM_CAP_RSVD_04);
      $finish;
    end

    if ((PM_CAP_VERSION >= 0) && (PM_CAP_VERSION <= 7))
      PM_CAP_VERSION_BINARY = PM_CAP_VERSION;
    else begin
      $display("Attribute Syntax Error : The Attribute PM_CAP_VERSION on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", PM_CAP_VERSION);
      $finish;
    end

    if ((RECRC_CHK >= 0) && (RECRC_CHK <= 3))
      RECRC_CHK_BINARY = RECRC_CHK;
    else begin
      $display("Attribute Syntax Error : The Attribute RECRC_CHK on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 3.", RECRC_CHK);
      $finish;
    end

    if ((SLOT_CAP_SLOT_POWER_LIMIT_SCALE >= 0) && (SLOT_CAP_SLOT_POWER_LIMIT_SCALE <= 3))
      SLOT_CAP_SLOT_POWER_LIMIT_SCALE_BINARY = SLOT_CAP_SLOT_POWER_LIMIT_SCALE;
    else begin
      $display("Attribute Syntax Error : The Attribute SLOT_CAP_SLOT_POWER_LIMIT_SCALE on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 3.", SLOT_CAP_SLOT_POWER_LIMIT_SCALE);
      $finish;
    end

    if ((SPARE_BIT0 >= 0) && (SPARE_BIT0 <= 1))
      SPARE_BIT0_BINARY = SPARE_BIT0;
    else begin
      $display("Attribute Syntax Error : The Attribute SPARE_BIT0 on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 1.", SPARE_BIT0);
      $finish;
    end

    if ((SPARE_BIT1 >= 0) && (SPARE_BIT1 <= 1))
      SPARE_BIT1_BINARY = SPARE_BIT1;
    else begin
      $display("Attribute Syntax Error : The Attribute SPARE_BIT1 on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 1.", SPARE_BIT1);
      $finish;
    end

    if ((SPARE_BIT2 >= 0) && (SPARE_BIT2 <= 1))
      SPARE_BIT2_BINARY = SPARE_BIT2;
    else begin
      $display("Attribute Syntax Error : The Attribute SPARE_BIT2 on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 1.", SPARE_BIT2);
      $finish;
    end

    if ((SPARE_BIT3 >= 0) && (SPARE_BIT3 <= 1))
      SPARE_BIT3_BINARY = SPARE_BIT3;
    else begin
      $display("Attribute Syntax Error : The Attribute SPARE_BIT3 on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 1.", SPARE_BIT3);
      $finish;
    end

    if ((SPARE_BIT4 >= 0) && (SPARE_BIT4 <= 1))
      SPARE_BIT4_BINARY = SPARE_BIT4;
    else begin
      $display("Attribute Syntax Error : The Attribute SPARE_BIT4 on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 1.", SPARE_BIT4);
      $finish;
    end

    if ((SPARE_BIT5 >= 0) && (SPARE_BIT5 <= 1))
      SPARE_BIT5_BINARY = SPARE_BIT5;
    else begin
      $display("Attribute Syntax Error : The Attribute SPARE_BIT5 on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 1.", SPARE_BIT5);
      $finish;
    end

    if ((SPARE_BIT6 >= 0) && (SPARE_BIT6 <= 1))
      SPARE_BIT6_BINARY = SPARE_BIT6;
    else begin
      $display("Attribute Syntax Error : The Attribute SPARE_BIT6 on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 1.", SPARE_BIT6);
      $finish;
    end

    if ((SPARE_BIT7 >= 0) && (SPARE_BIT7 <= 1))
      SPARE_BIT7_BINARY = SPARE_BIT7;
    else begin
      $display("Attribute Syntax Error : The Attribute SPARE_BIT7 on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 1.", SPARE_BIT7);
      $finish;
    end

    if ((SPARE_BIT8 >= 0) && (SPARE_BIT8 <= 1))
      SPARE_BIT8_BINARY = SPARE_BIT8;
    else begin
      $display("Attribute Syntax Error : The Attribute SPARE_BIT8 on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 1.", SPARE_BIT8);
      $finish;
    end

    if ((TL_RX_RAM_RADDR_LATENCY >= 0) && (TL_RX_RAM_RADDR_LATENCY <= 1))
      TL_RX_RAM_RADDR_LATENCY_BINARY = TL_RX_RAM_RADDR_LATENCY;
    else begin
      $display("Attribute Syntax Error : The Attribute TL_RX_RAM_RADDR_LATENCY on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 1.", TL_RX_RAM_RADDR_LATENCY);
      $finish;
    end

    if ((TL_RX_RAM_RDATA_LATENCY >= 0) && (TL_RX_RAM_RDATA_LATENCY <= 3))
      TL_RX_RAM_RDATA_LATENCY_BINARY = TL_RX_RAM_RDATA_LATENCY;
    else begin
      $display("Attribute Syntax Error : The Attribute TL_RX_RAM_RDATA_LATENCY on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 3.", TL_RX_RAM_RDATA_LATENCY);
      $finish;
    end

    if ((TL_RX_RAM_WRITE_LATENCY >= 0) && (TL_RX_RAM_WRITE_LATENCY <= 1))
      TL_RX_RAM_WRITE_LATENCY_BINARY = TL_RX_RAM_WRITE_LATENCY;
    else begin
      $display("Attribute Syntax Error : The Attribute TL_RX_RAM_WRITE_LATENCY on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 1.", TL_RX_RAM_WRITE_LATENCY);
      $finish;
    end

    if ((TL_TX_RAM_RADDR_LATENCY >= 0) && (TL_TX_RAM_RADDR_LATENCY <= 1))
      TL_TX_RAM_RADDR_LATENCY_BINARY = TL_TX_RAM_RADDR_LATENCY;
    else begin
      $display("Attribute Syntax Error : The Attribute TL_TX_RAM_RADDR_LATENCY on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 1.", TL_TX_RAM_RADDR_LATENCY);
      $finish;
    end

    if ((TL_TX_RAM_RDATA_LATENCY >= 0) && (TL_TX_RAM_RDATA_LATENCY <= 3))
      TL_TX_RAM_RDATA_LATENCY_BINARY = TL_TX_RAM_RDATA_LATENCY;
    else begin
      $display("Attribute Syntax Error : The Attribute TL_TX_RAM_RDATA_LATENCY on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 3.", TL_TX_RAM_RDATA_LATENCY);
      $finish;
    end

    if ((TL_TX_RAM_WRITE_LATENCY >= 0) && (TL_TX_RAM_WRITE_LATENCY <= 1))
      TL_TX_RAM_WRITE_LATENCY_BINARY = TL_TX_RAM_WRITE_LATENCY;
    else begin
      $display("Attribute Syntax Error : The Attribute TL_TX_RAM_WRITE_LATENCY on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 1.", TL_TX_RAM_WRITE_LATENCY);
      $finish;
    end

    if ((USER_CLK_FREQ >= 0) && (USER_CLK_FREQ <= 7))
      USER_CLK_FREQ_BINARY = USER_CLK_FREQ;
    else begin
      $display("Attribute Syntax Error : The Attribute USER_CLK_FREQ on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", USER_CLK_FREQ);
      $finish;
    end

    if ((VC0_TOTAL_CREDITS_CD >= 0) && (VC0_TOTAL_CREDITS_CD <= 2047))
      VC0_TOTAL_CREDITS_CD_BINARY = VC0_TOTAL_CREDITS_CD;
    else begin
      $display("Attribute Syntax Error : The Attribute VC0_TOTAL_CREDITS_CD on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 2047.", VC0_TOTAL_CREDITS_CD);
      $finish;
    end

    if ((VC0_TOTAL_CREDITS_CH >= 0) && (VC0_TOTAL_CREDITS_CH <= 127))
      VC0_TOTAL_CREDITS_CH_BINARY = VC0_TOTAL_CREDITS_CH;
    else begin
      $display("Attribute Syntax Error : The Attribute VC0_TOTAL_CREDITS_CH on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 127.", VC0_TOTAL_CREDITS_CH);
      $finish;
    end

    if ((VC0_TOTAL_CREDITS_NPH >= 0) && (VC0_TOTAL_CREDITS_NPH <= 127))
      VC0_TOTAL_CREDITS_NPH_BINARY = VC0_TOTAL_CREDITS_NPH;
    else begin
      $display("Attribute Syntax Error : The Attribute VC0_TOTAL_CREDITS_NPH on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 127.", VC0_TOTAL_CREDITS_NPH);
      $finish;
    end

    if ((VC0_TOTAL_CREDITS_PD >= 0) && (VC0_TOTAL_CREDITS_PD <= 2047))
      VC0_TOTAL_CREDITS_PD_BINARY = VC0_TOTAL_CREDITS_PD;
    else begin
      $display("Attribute Syntax Error : The Attribute VC0_TOTAL_CREDITS_PD on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 2047.", VC0_TOTAL_CREDITS_PD);
      $finish;
    end

    if ((VC0_TOTAL_CREDITS_PH >= 0) && (VC0_TOTAL_CREDITS_PH <= 127))
      VC0_TOTAL_CREDITS_PH_BINARY = VC0_TOTAL_CREDITS_PH;
    else begin
      $display("Attribute Syntax Error : The Attribute VC0_TOTAL_CREDITS_PH on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 127.", VC0_TOTAL_CREDITS_PH);
      $finish;
    end

    if ((VC0_TX_LASTPACKET >= 0) && (VC0_TX_LASTPACKET <= 31))
      VC0_TX_LASTPACKET_BINARY = VC0_TX_LASTPACKET;
    else begin
      $display("Attribute Syntax Error : The Attribute VC0_TX_LASTPACKET on PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 31.", VC0_TX_LASTPACKET);
      $finish;
    end

  end

  wire [11:0] delay_DBGVECC;
  wire [11:0] delay_PLDBGVEC;
  wire [11:0] delay_TRNFCCPLD;
  wire [11:0] delay_TRNFCNPD;
  wire [11:0] delay_TRNFCPD;
  wire [12:0] delay_MIMRXRADDR;
  wire [12:0] delay_MIMRXWADDR;
  wire [12:0] delay_MIMTXRADDR;
  wire [12:0] delay_MIMTXWADDR;
  wire [15:0] delay_CFGMSGDATA;
  wire [15:0] delay_DRPDO;
  wire [15:0] delay_PIPETX0DATA;
  wire [15:0] delay_PIPETX1DATA;
  wire [15:0] delay_PIPETX2DATA;
  wire [15:0] delay_PIPETX3DATA;
  wire [15:0] delay_PIPETX4DATA;
  wire [15:0] delay_PIPETX5DATA;
  wire [15:0] delay_PIPETX6DATA;
  wire [15:0] delay_PIPETX7DATA;
  wire [1:0] delay_CFGLINKCONTROLASPMCONTROL;
  wire [1:0] delay_CFGLINKSTATUSCURRENTSPEED;
  wire [1:0] delay_CFGPMCSRPOWERSTATE;
  wire [1:0] delay_PIPETX0CHARISK;
  wire [1:0] delay_PIPETX0POWERDOWN;
  wire [1:0] delay_PIPETX1CHARISK;
  wire [1:0] delay_PIPETX1POWERDOWN;
  wire [1:0] delay_PIPETX2CHARISK;
  wire [1:0] delay_PIPETX2POWERDOWN;
  wire [1:0] delay_PIPETX3CHARISK;
  wire [1:0] delay_PIPETX3POWERDOWN;
  wire [1:0] delay_PIPETX4CHARISK;
  wire [1:0] delay_PIPETX4POWERDOWN;
  wire [1:0] delay_PIPETX5CHARISK;
  wire [1:0] delay_PIPETX5POWERDOWN;
  wire [1:0] delay_PIPETX6CHARISK;
  wire [1:0] delay_PIPETX6POWERDOWN;
  wire [1:0] delay_PIPETX7CHARISK;
  wire [1:0] delay_PIPETX7POWERDOWN;
  wire [1:0] delay_PLLANEREVERSALMODE;
  wire [1:0] delay_PLRXPMSTATE;
  wire [1:0] delay_PLSELLNKWIDTH;
  wire [2:0] delay_CFGDEVCONTROLMAXPAYLOAD;
  wire [2:0] delay_CFGDEVCONTROLMAXREADREQ;
  wire [2:0] delay_CFGINTERRUPTMMENABLE;
  wire [2:0] delay_CFGPCIELINKSTATE;
  wire [2:0] delay_PIPETXMARGIN;
  wire [2:0] delay_PLINITIALLINKWIDTH;
  wire [2:0] delay_PLTXPMSTATE;
  wire [31:0] delay_CFGDO;
  wire [31:0] delay_TRNRDLLPDATA;
  wire [3:0] delay_CFGDEVCONTROL2CPLTIMEOUTVAL;
  wire [3:0] delay_CFGLINKSTATUSNEGOTIATEDWIDTH;
  wire [5:0] delay_PLLTSSMSTATE;
  wire [5:0] delay_TRNTBUFAV;
  wire [63:0] delay_DBGVECA;
  wire [63:0] delay_DBGVECB;
  wire [63:0] delay_TRNRD;
  wire [67:0] delay_MIMRXWDATA;
  wire [68:0] delay_MIMTXWDATA;
  wire [6:0] delay_CFGTRANSACTIONADDR;
  wire [6:0] delay_CFGVCTCVCMAP;
  wire [6:0] delay_TRNRBARHITN;
  wire [7:0] delay_CFGINTERRUPTDO;
  wire [7:0] delay_TRNFCCPLH;
  wire [7:0] delay_TRNFCNPH;
  wire [7:0] delay_TRNFCPH;
  wire delay_CFGAERECRCCHECKEN;
  wire delay_CFGAERECRCGENEN;
  wire delay_CFGCOMMANDBUSMASTERENABLE;
  wire delay_CFGCOMMANDINTERRUPTDISABLE;
  wire delay_CFGCOMMANDIOENABLE;
  wire delay_CFGCOMMANDMEMENABLE;
  wire delay_CFGCOMMANDSERREN;
  wire delay_CFGDEVCONTROL2CPLTIMEOUTDIS;
  wire delay_CFGDEVCONTROLAUXPOWEREN;
  wire delay_CFGDEVCONTROLCORRERRREPORTINGEN;
  wire delay_CFGDEVCONTROLENABLERO;
  wire delay_CFGDEVCONTROLEXTTAGEN;
  wire delay_CFGDEVCONTROLFATALERRREPORTINGEN;
  wire delay_CFGDEVCONTROLNONFATALREPORTINGEN;
  wire delay_CFGDEVCONTROLNOSNOOPEN;
  wire delay_CFGDEVCONTROLPHANTOMEN;
  wire delay_CFGDEVCONTROLURERRREPORTINGEN;
  wire delay_CFGDEVSTATUSCORRERRDETECTED;
  wire delay_CFGDEVSTATUSFATALERRDETECTED;
  wire delay_CFGDEVSTATUSNONFATALERRDETECTED;
  wire delay_CFGDEVSTATUSURDETECTED;
  wire delay_CFGERRAERHEADERLOGSETN;
  wire delay_CFGERRCPLRDYN;
  wire delay_CFGINTERRUPTMSIENABLE;
  wire delay_CFGINTERRUPTMSIXENABLE;
  wire delay_CFGINTERRUPTMSIXFM;
  wire delay_CFGINTERRUPTRDYN;
  wire delay_CFGLINKCONTROLAUTOBANDWIDTHINTEN;
  wire delay_CFGLINKCONTROLBANDWIDTHINTEN;
  wire delay_CFGLINKCONTROLCLOCKPMEN;
  wire delay_CFGLINKCONTROLCOMMONCLOCK;
  wire delay_CFGLINKCONTROLEXTENDEDSYNC;
  wire delay_CFGLINKCONTROLHWAUTOWIDTHDIS;
  wire delay_CFGLINKCONTROLLINKDISABLE;
  wire delay_CFGLINKCONTROLRCB;
  wire delay_CFGLINKCONTROLRETRAINLINK;
  wire delay_CFGLINKSTATUSAUTOBANDWIDTHSTATUS;
  wire delay_CFGLINKSTATUSBANDWITHSTATUS;
  wire delay_CFGLINKSTATUSDLLACTIVE;
  wire delay_CFGLINKSTATUSLINKTRAINING;
  wire delay_CFGMSGRECEIVED;
  wire delay_CFGMSGRECEIVEDASSERTINTA;
  wire delay_CFGMSGRECEIVEDASSERTINTB;
  wire delay_CFGMSGRECEIVEDASSERTINTC;
  wire delay_CFGMSGRECEIVEDASSERTINTD;
  wire delay_CFGMSGRECEIVEDDEASSERTINTA;
  wire delay_CFGMSGRECEIVEDDEASSERTINTB;
  wire delay_CFGMSGRECEIVEDDEASSERTINTC;
  wire delay_CFGMSGRECEIVEDDEASSERTINTD;
  wire delay_CFGMSGRECEIVEDERRCOR;
  wire delay_CFGMSGRECEIVEDERRFATAL;
  wire delay_CFGMSGRECEIVEDERRNONFATAL;
  wire delay_CFGMSGRECEIVEDPMASNAK;
  wire delay_CFGMSGRECEIVEDPMETO;
  wire delay_CFGMSGRECEIVEDPMETOACK;
  wire delay_CFGMSGRECEIVEDPMPME;
  wire delay_CFGMSGRECEIVEDSETSLOTPOWERLIMIT;
  wire delay_CFGMSGRECEIVEDUNLOCK;
  wire delay_CFGPMCSRPMEEN;
  wire delay_CFGPMCSRPMESTATUS;
  wire delay_CFGPMRCVASREQL1N;
  wire delay_CFGPMRCVENTERL1N;
  wire delay_CFGPMRCVENTERL23N;
  wire delay_CFGPMRCVREQACKN;
  wire delay_CFGRDWRDONEN;
  wire delay_CFGSLOTCONTROLELECTROMECHILCTLPULSE;
  wire delay_CFGTRANSACTION;
  wire delay_CFGTRANSACTIONTYPE;
  wire delay_DBGSCLRA;
  wire delay_DBGSCLRB;
  wire delay_DBGSCLRC;
  wire delay_DBGSCLRD;
  wire delay_DBGSCLRE;
  wire delay_DBGSCLRF;
  wire delay_DBGSCLRG;
  wire delay_DBGSCLRH;
  wire delay_DBGSCLRI;
  wire delay_DBGSCLRJ;
  wire delay_DBGSCLRK;
  wire delay_DRPDRDY;
  wire delay_LL2BADDLLPERRN;
  wire delay_LL2BADTLPERRN;
  wire delay_LL2PROTOCOLERRN;
  wire delay_LL2REPLAYROERRN;
  wire delay_LL2REPLAYTOERRN;
  wire delay_LL2SUSPENDOKN;
  wire delay_LL2TFCINIT1SEQN;
  wire delay_LL2TFCINIT2SEQN;
  wire delay_LNKCLKEN;
  wire delay_MIMRXRCE;
  wire delay_MIMRXREN;
  wire delay_MIMRXWEN;
  wire delay_MIMTXRCE;
  wire delay_MIMTXREN;
  wire delay_MIMTXWEN;
  wire delay_PIPERX0POLARITY;
  wire delay_PIPERX1POLARITY;
  wire delay_PIPERX2POLARITY;
  wire delay_PIPERX3POLARITY;
  wire delay_PIPERX4POLARITY;
  wire delay_PIPERX5POLARITY;
  wire delay_PIPERX6POLARITY;
  wire delay_PIPERX7POLARITY;
  wire delay_PIPETX0COMPLIANCE;
  wire delay_PIPETX0ELECIDLE;
  wire delay_PIPETX1COMPLIANCE;
  wire delay_PIPETX1ELECIDLE;
  wire delay_PIPETX2COMPLIANCE;
  wire delay_PIPETX2ELECIDLE;
  wire delay_PIPETX3COMPLIANCE;
  wire delay_PIPETX3ELECIDLE;
  wire delay_PIPETX4COMPLIANCE;
  wire delay_PIPETX4ELECIDLE;
  wire delay_PIPETX5COMPLIANCE;
  wire delay_PIPETX5ELECIDLE;
  wire delay_PIPETX6COMPLIANCE;
  wire delay_PIPETX6ELECIDLE;
  wire delay_PIPETX7COMPLIANCE;
  wire delay_PIPETX7ELECIDLE;
  wire delay_PIPETXDEEMPH;
  wire delay_PIPETXRATE;
  wire delay_PIPETXRCVRDET;
  wire delay_PIPETXRESET;
  wire delay_PL2LINKUPN;
  wire delay_PL2RECEIVERERRN;
  wire delay_PL2RECOVERYN;
  wire delay_PL2RXELECIDLE;
  wire delay_PL2SUSPENDOK;
  wire delay_PLLINKGEN2CAP;
  wire delay_PLLINKPARTNERGEN2SUPPORTED;
  wire delay_PLLINKUPCFGCAP;
  wire delay_PLPHYLNKUPN;
  wire delay_PLRECEIVEDHOTRST;
  wire delay_PLSELLNKRATE;
  wire delay_RECEIVEDFUNCLVLRSTN;
  wire delay_TL2ASPMSUSPENDCREDITCHECKOKN;
  wire delay_TL2ASPMSUSPENDREQN;
  wire delay_TL2PPMSUSPENDOKN;
  wire delay_TRNLNKUPN;
  wire delay_TRNRDLLPSRCRDYN;
  wire delay_TRNRECRCERRN;
  wire delay_TRNREOFN;
  wire delay_TRNRERRFWDN;
  wire delay_TRNRREMN;
  wire delay_TRNRSOFN;
  wire delay_TRNRSRCDSCN;
  wire delay_TRNRSRCRDYN;
  wire delay_TRNTCFGREQN;
  wire delay_TRNTDLLPDSTRDYN;
  wire delay_TRNTDSTRDYN;
  wire delay_TRNTERRDROPN;
  wire delay_USERRSTN;

  wire [127:0] delay_CFGERRAERHEADERLOG;
  wire [15:0] delay_DRPDI;
  wire [15:0] delay_PIPERX0DATA;
  wire [15:0] delay_PIPERX1DATA;
  wire [15:0] delay_PIPERX2DATA;
  wire [15:0] delay_PIPERX3DATA;
  wire [15:0] delay_PIPERX4DATA;
  wire [15:0] delay_PIPERX5DATA;
  wire [15:0] delay_PIPERX6DATA;
  wire [15:0] delay_PIPERX7DATA;
  wire [1:0] delay_DBGMODE;
  wire [1:0] delay_PIPERX0CHARISK;
  wire [1:0] delay_PIPERX1CHARISK;
  wire [1:0] delay_PIPERX2CHARISK;
  wire [1:0] delay_PIPERX3CHARISK;
  wire [1:0] delay_PIPERX4CHARISK;
  wire [1:0] delay_PIPERX5CHARISK;
  wire [1:0] delay_PIPERX6CHARISK;
  wire [1:0] delay_PIPERX7CHARISK;
  wire [1:0] delay_PLDIRECTEDLINKCHANGE;
  wire [1:0] delay_PLDIRECTEDLINKWIDTH;
  wire [2:0] delay_CFGDSFUNCTIONNUMBER;
  wire [2:0] delay_PIPERX0STATUS;
  wire [2:0] delay_PIPERX1STATUS;
  wire [2:0] delay_PIPERX2STATUS;
  wire [2:0] delay_PIPERX3STATUS;
  wire [2:0] delay_PIPERX4STATUS;
  wire [2:0] delay_PIPERX5STATUS;
  wire [2:0] delay_PIPERX6STATUS;
  wire [2:0] delay_PIPERX7STATUS;
  wire [2:0] delay_PLDBGMODE;
  wire [2:0] delay_TRNFCSEL;
  wire [31:0] delay_CFGDI;
  wire [31:0] delay_TRNTDLLPDATA;
  wire [3:0] delay_CFGBYTEENN;
  wire [47:0] delay_CFGERRTLPCPLHEADER;
  wire [4:0] delay_CFGDSDEVICENUMBER;
  wire [4:0] delay_PL2DIRECTEDLSTATE;
  wire [63:0] delay_CFGDSN;
  wire [63:0] delay_TRNTD;
  wire [67:0] delay_MIMRXRDATA;
  wire [68:0] delay_MIMTXRDATA;
  wire [7:0] delay_CFGDSBUSNUMBER;
  wire [7:0] delay_CFGINTERRUPTDI;
  wire [7:0] delay_CFGPORTNUMBER;
  wire [8:0] delay_DRPDADDR;
  wire [9:0] delay_CFGDWADDR;
  wire delay_CFGERRACSN;
  wire delay_CFGERRCORN;
  wire delay_CFGERRCPLABORTN;
  wire delay_CFGERRCPLTIMEOUTN;
  wire delay_CFGERRCPLUNEXPECTN;
  wire delay_CFGERRECRCN;
  wire delay_CFGERRLOCKEDN;
  wire delay_CFGERRPOSTEDN;
  wire delay_CFGERRURN;
  wire delay_CFGINTERRUPTASSERTN;
  wire delay_CFGINTERRUPTN;
  wire delay_CFGPMDIRECTASPML1N;
  wire delay_CFGPMSENDPMACKN;
  wire delay_CFGPMSENDPMETON;
  wire delay_CFGPMSENDPMNAKN;
  wire delay_CFGPMTURNOFFOKN;
  wire delay_CFGPMWAKEN;
  wire delay_CFGRDENN;
  wire delay_CFGTRNPENDINGN;
  wire delay_CFGWRENN;
  wire delay_CFGWRREADONLYN;
  wire delay_CFGWRRW1CASRWN;
  wire delay_CMRSTN;
  wire delay_CMSTICKYRSTN;
  wire delay_DBGSUBMODE;
  wire delay_DLRSTN;
  wire delay_DRPCLK;
  wire delay_DRPDEN;
  wire delay_DRPDWE;
  wire delay_FUNCLVLRSTN;
  wire delay_LL2SENDASREQL1N;
  wire delay_LL2SENDENTERL1N;
  wire delay_LL2SENDENTERL23N;
  wire delay_LL2SUSPENDNOWN;
  wire delay_LL2TLPRCVN;
  wire delay_PIPECLK;
  wire delay_PIPERX0CHANISALIGNED;
  wire delay_PIPERX0ELECIDLE;
  wire delay_PIPERX0PHYSTATUS;
  wire delay_PIPERX0VALID;
  wire delay_PIPERX1CHANISALIGNED;
  wire delay_PIPERX1ELECIDLE;
  wire delay_PIPERX1PHYSTATUS;
  wire delay_PIPERX1VALID;
  wire delay_PIPERX2CHANISALIGNED;
  wire delay_PIPERX2ELECIDLE;
  wire delay_PIPERX2PHYSTATUS;
  wire delay_PIPERX2VALID;
  wire delay_PIPERX3CHANISALIGNED;
  wire delay_PIPERX3ELECIDLE;
  wire delay_PIPERX3PHYSTATUS;
  wire delay_PIPERX3VALID;
  wire delay_PIPERX4CHANISALIGNED;
  wire delay_PIPERX4ELECIDLE;
  wire delay_PIPERX4PHYSTATUS;
  wire delay_PIPERX4VALID;
  wire delay_PIPERX5CHANISALIGNED;
  wire delay_PIPERX5ELECIDLE;
  wire delay_PIPERX5PHYSTATUS;
  wire delay_PIPERX5VALID;
  wire delay_PIPERX6CHANISALIGNED;
  wire delay_PIPERX6ELECIDLE;
  wire delay_PIPERX6PHYSTATUS;
  wire delay_PIPERX6VALID;
  wire delay_PIPERX7CHANISALIGNED;
  wire delay_PIPERX7ELECIDLE;
  wire delay_PIPERX7PHYSTATUS;
  wire delay_PIPERX7VALID;
  wire delay_PLDIRECTEDLINKAUTON;
  wire delay_PLDIRECTEDLINKSPEED;
  wire delay_PLDOWNSTREAMDEEMPHSOURCE;
  wire delay_PLRSTN;
  wire delay_PLTRANSMITHOTRST;
  wire delay_PLUPSTREAMPREFERDEEMPH;
  wire delay_SYSRSTN;
  wire delay_TL2ASPMSUSPENDCREDITCHECKN;
  wire delay_TL2PPMSUSPENDREQN;
  wire delay_TLRSTN;
  wire delay_TRNRDSTRDYN;
  wire delay_TRNRNPOKN;
  wire delay_TRNTCFGGNTN;
  wire delay_TRNTDLLPSRCRDYN;
  wire delay_TRNTECRCGENN;
  wire delay_TRNTEOFN;
  wire delay_TRNTERRFWDN;
  wire delay_TRNTREMN;
  wire delay_TRNTSOFN;
  wire delay_TRNTSRCDSCN;
  wire delay_TRNTSRCRDYN;
  wire delay_TRNTSTRN;
  wire delay_USERCLK;

  assign #(out_delay) CFGAERECRCCHECKEN = delay_CFGAERECRCCHECKEN;
  assign #(out_delay) CFGAERECRCGENEN = delay_CFGAERECRCGENEN;
  assign #(out_delay) CFGCOMMANDBUSMASTERENABLE = delay_CFGCOMMANDBUSMASTERENABLE;
  assign #(out_delay) CFGCOMMANDINTERRUPTDISABLE = delay_CFGCOMMANDINTERRUPTDISABLE;
  assign #(out_delay) CFGCOMMANDIOENABLE = delay_CFGCOMMANDIOENABLE;
  assign #(out_delay) CFGCOMMANDMEMENABLE = delay_CFGCOMMANDMEMENABLE;
  assign #(out_delay) CFGCOMMANDSERREN = delay_CFGCOMMANDSERREN;
  assign #(out_delay) CFGDEVCONTROL2CPLTIMEOUTDIS = delay_CFGDEVCONTROL2CPLTIMEOUTDIS;
  assign #(out_delay) CFGDEVCONTROL2CPLTIMEOUTVAL = delay_CFGDEVCONTROL2CPLTIMEOUTVAL;
  assign #(out_delay) CFGDEVCONTROLAUXPOWEREN = delay_CFGDEVCONTROLAUXPOWEREN;
  assign #(out_delay) CFGDEVCONTROLCORRERRREPORTINGEN = delay_CFGDEVCONTROLCORRERRREPORTINGEN;
  assign #(out_delay) CFGDEVCONTROLENABLERO = delay_CFGDEVCONTROLENABLERO;
  assign #(out_delay) CFGDEVCONTROLEXTTAGEN = delay_CFGDEVCONTROLEXTTAGEN;
  assign #(out_delay) CFGDEVCONTROLFATALERRREPORTINGEN = delay_CFGDEVCONTROLFATALERRREPORTINGEN;
  assign #(out_delay) CFGDEVCONTROLMAXPAYLOAD = delay_CFGDEVCONTROLMAXPAYLOAD;
  assign #(out_delay) CFGDEVCONTROLMAXREADREQ = delay_CFGDEVCONTROLMAXREADREQ;
  assign #(out_delay) CFGDEVCONTROLNONFATALREPORTINGEN = delay_CFGDEVCONTROLNONFATALREPORTINGEN;
  assign #(out_delay) CFGDEVCONTROLNOSNOOPEN = delay_CFGDEVCONTROLNOSNOOPEN;
  assign #(out_delay) CFGDEVCONTROLPHANTOMEN = delay_CFGDEVCONTROLPHANTOMEN;
  assign #(out_delay) CFGDEVCONTROLURERRREPORTINGEN = delay_CFGDEVCONTROLURERRREPORTINGEN;
  assign #(out_delay) CFGDEVSTATUSCORRERRDETECTED = delay_CFGDEVSTATUSCORRERRDETECTED;
  assign #(out_delay) CFGDEVSTATUSFATALERRDETECTED = delay_CFGDEVSTATUSFATALERRDETECTED;
  assign #(out_delay) CFGDEVSTATUSNONFATALERRDETECTED = delay_CFGDEVSTATUSNONFATALERRDETECTED;
  assign #(out_delay) CFGDEVSTATUSURDETECTED = delay_CFGDEVSTATUSURDETECTED;
  assign #(out_delay) CFGDO = delay_CFGDO;
  assign #(out_delay) CFGERRAERHEADERLOGSETN = delay_CFGERRAERHEADERLOGSETN;
  assign #(out_delay) CFGERRCPLRDYN = delay_CFGERRCPLRDYN;
  assign #(out_delay) CFGINTERRUPTDO = delay_CFGINTERRUPTDO;
  assign #(out_delay) CFGINTERRUPTMMENABLE = delay_CFGINTERRUPTMMENABLE;
  assign #(out_delay) CFGINTERRUPTMSIENABLE = delay_CFGINTERRUPTMSIENABLE;
  assign #(out_delay) CFGINTERRUPTMSIXENABLE = delay_CFGINTERRUPTMSIXENABLE;
  assign #(out_delay) CFGINTERRUPTMSIXFM = delay_CFGINTERRUPTMSIXFM;
  assign #(out_delay) CFGINTERRUPTRDYN = delay_CFGINTERRUPTRDYN;
  assign #(out_delay) CFGLINKCONTROLASPMCONTROL = delay_CFGLINKCONTROLASPMCONTROL;
  assign #(out_delay) CFGLINKCONTROLAUTOBANDWIDTHINTEN = delay_CFGLINKCONTROLAUTOBANDWIDTHINTEN;
  assign #(out_delay) CFGLINKCONTROLBANDWIDTHINTEN = delay_CFGLINKCONTROLBANDWIDTHINTEN;
  assign #(out_delay) CFGLINKCONTROLCLOCKPMEN = delay_CFGLINKCONTROLCLOCKPMEN;
  assign #(out_delay) CFGLINKCONTROLCOMMONCLOCK = delay_CFGLINKCONTROLCOMMONCLOCK;
  assign #(out_delay) CFGLINKCONTROLEXTENDEDSYNC = delay_CFGLINKCONTROLEXTENDEDSYNC;
  assign #(out_delay) CFGLINKCONTROLHWAUTOWIDTHDIS = delay_CFGLINKCONTROLHWAUTOWIDTHDIS;
  assign #(out_delay) CFGLINKCONTROLLINKDISABLE = delay_CFGLINKCONTROLLINKDISABLE;
  assign #(out_delay) CFGLINKCONTROLRCB = delay_CFGLINKCONTROLRCB;
  assign #(out_delay) CFGLINKCONTROLRETRAINLINK = delay_CFGLINKCONTROLRETRAINLINK;
  assign #(out_delay) CFGLINKSTATUSAUTOBANDWIDTHSTATUS = delay_CFGLINKSTATUSAUTOBANDWIDTHSTATUS;
  assign #(out_delay) CFGLINKSTATUSBANDWITHSTATUS = delay_CFGLINKSTATUSBANDWITHSTATUS;
  assign #(out_delay) CFGLINKSTATUSCURRENTSPEED = delay_CFGLINKSTATUSCURRENTSPEED;
  assign #(out_delay) CFGLINKSTATUSDLLACTIVE = delay_CFGLINKSTATUSDLLACTIVE;
  assign #(out_delay) CFGLINKSTATUSLINKTRAINING = delay_CFGLINKSTATUSLINKTRAINING;
  assign #(out_delay) CFGLINKSTATUSNEGOTIATEDWIDTH = delay_CFGLINKSTATUSNEGOTIATEDWIDTH;
  assign #(out_delay) CFGMSGDATA = delay_CFGMSGDATA;
  assign #(out_delay) CFGMSGRECEIVED = delay_CFGMSGRECEIVED;
  assign #(out_delay) CFGMSGRECEIVEDASSERTINTA = delay_CFGMSGRECEIVEDASSERTINTA;
  assign #(out_delay) CFGMSGRECEIVEDASSERTINTB = delay_CFGMSGRECEIVEDASSERTINTB;
  assign #(out_delay) CFGMSGRECEIVEDASSERTINTC = delay_CFGMSGRECEIVEDASSERTINTC;
  assign #(out_delay) CFGMSGRECEIVEDASSERTINTD = delay_CFGMSGRECEIVEDASSERTINTD;
  assign #(out_delay) CFGMSGRECEIVEDDEASSERTINTA = delay_CFGMSGRECEIVEDDEASSERTINTA;
  assign #(out_delay) CFGMSGRECEIVEDDEASSERTINTB = delay_CFGMSGRECEIVEDDEASSERTINTB;
  assign #(out_delay) CFGMSGRECEIVEDDEASSERTINTC = delay_CFGMSGRECEIVEDDEASSERTINTC;
  assign #(out_delay) CFGMSGRECEIVEDDEASSERTINTD = delay_CFGMSGRECEIVEDDEASSERTINTD;
  assign #(out_delay) CFGMSGRECEIVEDERRCOR = delay_CFGMSGRECEIVEDERRCOR;
  assign #(out_delay) CFGMSGRECEIVEDERRFATAL = delay_CFGMSGRECEIVEDERRFATAL;
  assign #(out_delay) CFGMSGRECEIVEDERRNONFATAL = delay_CFGMSGRECEIVEDERRNONFATAL;
  assign #(out_delay) CFGMSGRECEIVEDPMASNAK = delay_CFGMSGRECEIVEDPMASNAK;
  assign #(out_delay) CFGMSGRECEIVEDPMETO = delay_CFGMSGRECEIVEDPMETO;
  assign #(out_delay) CFGMSGRECEIVEDPMETOACK = delay_CFGMSGRECEIVEDPMETOACK;
  assign #(out_delay) CFGMSGRECEIVEDPMPME = delay_CFGMSGRECEIVEDPMPME;
  assign #(out_delay) CFGMSGRECEIVEDSETSLOTPOWERLIMIT = delay_CFGMSGRECEIVEDSETSLOTPOWERLIMIT;
  assign #(out_delay) CFGMSGRECEIVEDUNLOCK = delay_CFGMSGRECEIVEDUNLOCK;
  assign #(out_delay) CFGPCIELINKSTATE = delay_CFGPCIELINKSTATE;
  assign #(out_delay) CFGPMCSRPMEEN = delay_CFGPMCSRPMEEN;
  assign #(out_delay) CFGPMCSRPMESTATUS = delay_CFGPMCSRPMESTATUS;
  assign #(out_delay) CFGPMCSRPOWERSTATE = delay_CFGPMCSRPOWERSTATE;
  assign #(out_delay) CFGPMRCVASREQL1N = delay_CFGPMRCVASREQL1N;
  assign #(out_delay) CFGPMRCVENTERL1N = delay_CFGPMRCVENTERL1N;
  assign #(out_delay) CFGPMRCVENTERL23N = delay_CFGPMRCVENTERL23N;
  assign #(out_delay) CFGPMRCVREQACKN = delay_CFGPMRCVREQACKN;
  assign #(out_delay) CFGRDWRDONEN = delay_CFGRDWRDONEN;
  assign #(out_delay) CFGSLOTCONTROLELECTROMECHILCTLPULSE = delay_CFGSLOTCONTROLELECTROMECHILCTLPULSE;
  assign #(out_delay) CFGTRANSACTION = delay_CFGTRANSACTION;
  assign #(out_delay) CFGTRANSACTIONADDR = delay_CFGTRANSACTIONADDR;
  assign #(out_delay) CFGTRANSACTIONTYPE = delay_CFGTRANSACTIONTYPE;
  assign #(out_delay) CFGVCTCVCMAP = delay_CFGVCTCVCMAP;
  assign #(out_delay) DBGSCLRA = delay_DBGSCLRA;
  assign #(out_delay) DBGSCLRB = delay_DBGSCLRB;
  assign #(out_delay) DBGSCLRC = delay_DBGSCLRC;
  assign #(out_delay) DBGSCLRD = delay_DBGSCLRD;
  assign #(out_delay) DBGSCLRE = delay_DBGSCLRE;
  assign #(out_delay) DBGSCLRF = delay_DBGSCLRF;
  assign #(out_delay) DBGSCLRG = delay_DBGSCLRG;
  assign #(out_delay) DBGSCLRH = delay_DBGSCLRH;
  assign #(out_delay) DBGSCLRI = delay_DBGSCLRI;
  assign #(out_delay) DBGSCLRJ = delay_DBGSCLRJ;
  assign #(out_delay) DBGSCLRK = delay_DBGSCLRK;
  assign #(out_delay) DBGVECA = delay_DBGVECA;
  assign #(out_delay) DBGVECB = delay_DBGVECB;
  assign #(out_delay) DBGVECC = delay_DBGVECC;
  assign #(out_delay) DRPDO = delay_DRPDO;
  assign #(out_delay) DRPDRDY = delay_DRPDRDY;
  assign #(out_delay) LL2BADDLLPERRN = delay_LL2BADDLLPERRN;
  assign #(out_delay) LL2BADTLPERRN = delay_LL2BADTLPERRN;
  assign #(out_delay) LL2PROTOCOLERRN = delay_LL2PROTOCOLERRN;
  assign #(out_delay) LL2REPLAYROERRN = delay_LL2REPLAYROERRN;
  assign #(out_delay) LL2REPLAYTOERRN = delay_LL2REPLAYTOERRN;
  assign #(out_delay) LL2SUSPENDOKN = delay_LL2SUSPENDOKN;
  assign #(out_delay) LL2TFCINIT1SEQN = delay_LL2TFCINIT1SEQN;
  assign #(out_delay) LL2TFCINIT2SEQN = delay_LL2TFCINIT2SEQN;
  assign #(out_delay) LNKCLKEN = delay_LNKCLKEN;
  assign #(out_delay) MIMRXRADDR = delay_MIMRXRADDR;
  assign #(out_delay) MIMRXRCE = delay_MIMRXRCE;
  assign #(out_delay) MIMRXREN = delay_MIMRXREN;
  assign #(out_delay) MIMRXWADDR = delay_MIMRXWADDR;
  assign #(out_delay) MIMRXWDATA = delay_MIMRXWDATA;
  assign #(out_delay) MIMRXWEN = delay_MIMRXWEN;
  assign #(out_delay) MIMTXRADDR = delay_MIMTXRADDR;
  assign #(out_delay) MIMTXRCE = delay_MIMTXRCE;
  assign #(out_delay) MIMTXREN = delay_MIMTXREN;
  assign #(out_delay) MIMTXWADDR = delay_MIMTXWADDR;
  assign #(out_delay) MIMTXWDATA = delay_MIMTXWDATA;
  assign #(out_delay) MIMTXWEN = delay_MIMTXWEN;
  assign #(out_delay) PIPERX0POLARITY = delay_PIPERX0POLARITY;
  assign #(out_delay) PIPERX1POLARITY = delay_PIPERX1POLARITY;
  assign #(out_delay) PIPERX2POLARITY = delay_PIPERX2POLARITY;
  assign #(out_delay) PIPERX3POLARITY = delay_PIPERX3POLARITY;
  assign #(out_delay) PIPERX4POLARITY = delay_PIPERX4POLARITY;
  assign #(out_delay) PIPERX5POLARITY = delay_PIPERX5POLARITY;
  assign #(out_delay) PIPERX6POLARITY = delay_PIPERX6POLARITY;
  assign #(out_delay) PIPERX7POLARITY = delay_PIPERX7POLARITY;
  assign #(out_delay) PIPETX0CHARISK = delay_PIPETX0CHARISK;
  assign #(out_delay) PIPETX0COMPLIANCE = delay_PIPETX0COMPLIANCE;
  assign #(out_delay) PIPETX0DATA = delay_PIPETX0DATA;
  assign #(out_delay) PIPETX0ELECIDLE = delay_PIPETX0ELECIDLE;
  assign #(out_delay) PIPETX0POWERDOWN = delay_PIPETX0POWERDOWN;
  assign #(out_delay) PIPETX1CHARISK = delay_PIPETX1CHARISK;
  assign #(out_delay) PIPETX1COMPLIANCE = delay_PIPETX1COMPLIANCE;
  assign #(out_delay) PIPETX1DATA = delay_PIPETX1DATA;
  assign #(out_delay) PIPETX1ELECIDLE = delay_PIPETX1ELECIDLE;
  assign #(out_delay) PIPETX1POWERDOWN = delay_PIPETX1POWERDOWN;
  assign #(out_delay) PIPETX2CHARISK = delay_PIPETX2CHARISK;
  assign #(out_delay) PIPETX2COMPLIANCE = delay_PIPETX2COMPLIANCE;
  assign #(out_delay) PIPETX2DATA = delay_PIPETX2DATA;
  assign #(out_delay) PIPETX2ELECIDLE = delay_PIPETX2ELECIDLE;
  assign #(out_delay) PIPETX2POWERDOWN = delay_PIPETX2POWERDOWN;
  assign #(out_delay) PIPETX3CHARISK = delay_PIPETX3CHARISK;
  assign #(out_delay) PIPETX3COMPLIANCE = delay_PIPETX3COMPLIANCE;
  assign #(out_delay) PIPETX3DATA = delay_PIPETX3DATA;
  assign #(out_delay) PIPETX3ELECIDLE = delay_PIPETX3ELECIDLE;
  assign #(out_delay) PIPETX3POWERDOWN = delay_PIPETX3POWERDOWN;
  assign #(out_delay) PIPETX4CHARISK = delay_PIPETX4CHARISK;
  assign #(out_delay) PIPETX4COMPLIANCE = delay_PIPETX4COMPLIANCE;
  assign #(out_delay) PIPETX4DATA = delay_PIPETX4DATA;
  assign #(out_delay) PIPETX4ELECIDLE = delay_PIPETX4ELECIDLE;
  assign #(out_delay) PIPETX4POWERDOWN = delay_PIPETX4POWERDOWN;
  assign #(out_delay) PIPETX5CHARISK = delay_PIPETX5CHARISK;
  assign #(out_delay) PIPETX5COMPLIANCE = delay_PIPETX5COMPLIANCE;
  assign #(out_delay) PIPETX5DATA = delay_PIPETX5DATA;
  assign #(out_delay) PIPETX5ELECIDLE = delay_PIPETX5ELECIDLE;
  assign #(out_delay) PIPETX5POWERDOWN = delay_PIPETX5POWERDOWN;
  assign #(out_delay) PIPETX6CHARISK = delay_PIPETX6CHARISK;
  assign #(out_delay) PIPETX6COMPLIANCE = delay_PIPETX6COMPLIANCE;
  assign #(out_delay) PIPETX6DATA = delay_PIPETX6DATA;
  assign #(out_delay) PIPETX6ELECIDLE = delay_PIPETX6ELECIDLE;
  assign #(out_delay) PIPETX6POWERDOWN = delay_PIPETX6POWERDOWN;
  assign #(out_delay) PIPETX7CHARISK = delay_PIPETX7CHARISK;
  assign #(out_delay) PIPETX7COMPLIANCE = delay_PIPETX7COMPLIANCE;
  assign #(out_delay) PIPETX7DATA = delay_PIPETX7DATA;
  assign #(out_delay) PIPETX7ELECIDLE = delay_PIPETX7ELECIDLE;
  assign #(out_delay) PIPETX7POWERDOWN = delay_PIPETX7POWERDOWN;
  assign #(out_delay) PIPETXDEEMPH = delay_PIPETXDEEMPH;
  assign #(out_delay) PIPETXMARGIN = delay_PIPETXMARGIN;
  assign #(out_delay) PIPETXRATE = delay_PIPETXRATE;
  assign #(out_delay) PIPETXRCVRDET = delay_PIPETXRCVRDET;
  assign #(out_delay) PIPETXRESET = delay_PIPETXRESET;
  assign #(out_delay) PL2LINKUPN = delay_PL2LINKUPN;
  assign #(out_delay) PL2RECEIVERERRN = delay_PL2RECEIVERERRN;
  assign #(out_delay) PL2RECOVERYN = delay_PL2RECOVERYN;
  assign #(out_delay) PL2RXELECIDLE = delay_PL2RXELECIDLE;
  assign #(out_delay) PL2SUSPENDOK = delay_PL2SUSPENDOK;
  assign #(out_delay) PLDBGVEC = delay_PLDBGVEC;
  assign #(out_delay) PLINITIALLINKWIDTH = delay_PLINITIALLINKWIDTH;
  assign #(out_delay) PLLANEREVERSALMODE = delay_PLLANEREVERSALMODE;
  assign #(out_delay) PLLINKGEN2CAP = delay_PLLINKGEN2CAP;
  assign #(out_delay) PLLINKPARTNERGEN2SUPPORTED = delay_PLLINKPARTNERGEN2SUPPORTED;
  assign #(out_delay) PLLINKUPCFGCAP = delay_PLLINKUPCFGCAP;
  assign #(out_delay) PLLTSSMSTATE = delay_PLLTSSMSTATE;
  assign #(out_delay) PLPHYLNKUPN = delay_PLPHYLNKUPN;
  assign #(out_delay) PLRECEIVEDHOTRST = delay_PLRECEIVEDHOTRST;
  assign #(out_delay) PLRXPMSTATE = delay_PLRXPMSTATE;
  assign #(out_delay) PLSELLNKRATE = delay_PLSELLNKRATE;
  assign #(out_delay) PLSELLNKWIDTH = delay_PLSELLNKWIDTH;
  assign #(out_delay) PLTXPMSTATE = delay_PLTXPMSTATE;
  assign #(out_delay) RECEIVEDFUNCLVLRSTN = delay_RECEIVEDFUNCLVLRSTN;
  assign #(out_delay) TL2ASPMSUSPENDCREDITCHECKOKN = delay_TL2ASPMSUSPENDCREDITCHECKOKN;
  assign #(out_delay) TL2ASPMSUSPENDREQN = delay_TL2ASPMSUSPENDREQN;
  assign #(out_delay) TL2PPMSUSPENDOKN = delay_TL2PPMSUSPENDOKN;
  assign #(out_delay) TRNFCCPLD = delay_TRNFCCPLD;
  assign #(out_delay) TRNFCCPLH = delay_TRNFCCPLH;
  assign #(out_delay) TRNFCNPD = delay_TRNFCNPD;
  assign #(out_delay) TRNFCNPH = delay_TRNFCNPH;
  assign #(out_delay) TRNFCPD = delay_TRNFCPD;
  assign #(out_delay) TRNFCPH = delay_TRNFCPH;
  assign #(out_delay) TRNLNKUPN = delay_TRNLNKUPN;
  assign #(out_delay) TRNRBARHITN = delay_TRNRBARHITN;
  assign #(out_delay) TRNRD = delay_TRNRD;
  assign #(out_delay) TRNRDLLPDATA = delay_TRNRDLLPDATA;
  assign #(out_delay) TRNRDLLPSRCRDYN = delay_TRNRDLLPSRCRDYN;
  assign #(out_delay) TRNRECRCERRN = delay_TRNRECRCERRN;
  assign #(out_delay) TRNREOFN = delay_TRNREOFN;
  assign #(out_delay) TRNRERRFWDN = delay_TRNRERRFWDN;
  assign #(out_delay) TRNRREMN = delay_TRNRREMN;
  assign #(out_delay) TRNRSOFN = delay_TRNRSOFN;
  assign #(out_delay) TRNRSRCDSCN = delay_TRNRSRCDSCN;
  assign #(out_delay) TRNRSRCRDYN = delay_TRNRSRCRDYN;
  assign #(out_delay) TRNTBUFAV = delay_TRNTBUFAV;
  assign #(out_delay) TRNTCFGREQN = delay_TRNTCFGREQN;
  assign #(out_delay) TRNTDLLPDSTRDYN = delay_TRNTDLLPDSTRDYN;
  assign #(out_delay) TRNTDSTRDYN = delay_TRNTDSTRDYN;
  assign #(out_delay) TRNTERRDROPN = delay_TRNTERRDROPN;
  assign #(out_delay) USERRSTN = delay_USERRSTN;

  assign #(INCLK_DELAY) delay_DRPCLK = DRPCLK;
  assign #(INCLK_DELAY) delay_PIPECLK = PIPECLK;
  assign #(INCLK_DELAY) delay_USERCLK = USERCLK;

  assign #(in_delay) delay_CFGBYTEENN = CFGBYTEENN;
  assign #(in_delay) delay_CFGDI = CFGDI;
  assign #(in_delay) delay_CFGDSBUSNUMBER = CFGDSBUSNUMBER;
  assign #(in_delay) delay_CFGDSDEVICENUMBER = CFGDSDEVICENUMBER;
  assign #(in_delay) delay_CFGDSFUNCTIONNUMBER = CFGDSFUNCTIONNUMBER;
  assign #(in_delay) delay_CFGDSN = CFGDSN;
  assign #(in_delay) delay_CFGDWADDR = CFGDWADDR;
  assign #(in_delay) delay_CFGERRACSN = CFGERRACSN;
  assign #(in_delay) delay_CFGERRAERHEADERLOG = CFGERRAERHEADERLOG;
  assign #(in_delay) delay_CFGERRCORN = CFGERRCORN;
  assign #(in_delay) delay_CFGERRCPLABORTN = CFGERRCPLABORTN;
  assign #(in_delay) delay_CFGERRCPLTIMEOUTN = CFGERRCPLTIMEOUTN;
  assign #(in_delay) delay_CFGERRCPLUNEXPECTN = CFGERRCPLUNEXPECTN;
  assign #(in_delay) delay_CFGERRECRCN = CFGERRECRCN;
  assign #(in_delay) delay_CFGERRLOCKEDN = CFGERRLOCKEDN;
  assign #(in_delay) delay_CFGERRPOSTEDN = CFGERRPOSTEDN;
  assign #(in_delay) delay_CFGERRTLPCPLHEADER = CFGERRTLPCPLHEADER;
  assign #(in_delay) delay_CFGERRURN = CFGERRURN;
  assign #(in_delay) delay_CFGINTERRUPTASSERTN = CFGINTERRUPTASSERTN;
  assign #(in_delay) delay_CFGINTERRUPTDI = CFGINTERRUPTDI;
  assign #(in_delay) delay_CFGINTERRUPTN = CFGINTERRUPTN;
  assign #(in_delay) delay_CFGPMDIRECTASPML1N = CFGPMDIRECTASPML1N;
  assign #(in_delay) delay_CFGPMSENDPMACKN = CFGPMSENDPMACKN;
  assign #(in_delay) delay_CFGPMSENDPMETON = CFGPMSENDPMETON;
  assign #(in_delay) delay_CFGPMSENDPMNAKN = CFGPMSENDPMNAKN;
  assign #(in_delay) delay_CFGPMTURNOFFOKN = CFGPMTURNOFFOKN;
  assign #(in_delay) delay_CFGPMWAKEN = CFGPMWAKEN;
  assign #(in_delay) delay_CFGPORTNUMBER = CFGPORTNUMBER;
  assign #(in_delay) delay_CFGRDENN = CFGRDENN;
  assign #(in_delay) delay_CFGTRNPENDINGN = CFGTRNPENDINGN;
  assign #(in_delay) delay_CFGWRENN = CFGWRENN;
  assign #(in_delay) delay_CFGWRREADONLYN = CFGWRREADONLYN;
  assign #(in_delay) delay_CFGWRRW1CASRWN = CFGWRRW1CASRWN;
  assign #(in_delay) delay_CMRSTN = CMRSTN;
  assign #(in_delay) delay_CMSTICKYRSTN = CMSTICKYRSTN;
  assign #(in_delay) delay_DBGMODE = DBGMODE;
  assign #(in_delay) delay_DBGSUBMODE = DBGSUBMODE;
  assign #(in_delay) delay_DLRSTN = DLRSTN;
  assign #(in_delay) delay_DRPDADDR = DRPDADDR;
  assign #(in_delay) delay_DRPDEN = DRPDEN;
  assign #(in_delay) delay_DRPDI = DRPDI;
  assign #(in_delay) delay_DRPDWE = DRPDWE;
  assign #(in_delay) delay_FUNCLVLRSTN = FUNCLVLRSTN;
  assign #(in_delay) delay_LL2SENDASREQL1N = LL2SENDASREQL1N;
  assign #(in_delay) delay_LL2SENDENTERL1N = LL2SENDENTERL1N;
  assign #(in_delay) delay_LL2SENDENTERL23N = LL2SENDENTERL23N;
  assign #(in_delay) delay_LL2SUSPENDNOWN = LL2SUSPENDNOWN;
  assign #(in_delay) delay_LL2TLPRCVN = LL2TLPRCVN;
  assign #(in_delay) delay_MIMRXRDATA = MIMRXRDATA;
  assign #(in_delay) delay_MIMTXRDATA = MIMTXRDATA;
  assign #(in_delay) delay_PIPERX0CHANISALIGNED = PIPERX0CHANISALIGNED;
  assign #(in_delay) delay_PIPERX0CHARISK = PIPERX0CHARISK;
  assign #(in_delay) delay_PIPERX0DATA = PIPERX0DATA;
  assign #(in_delay) delay_PIPERX0ELECIDLE = PIPERX0ELECIDLE;
  assign #(in_delay) delay_PIPERX0PHYSTATUS = PIPERX0PHYSTATUS;
  assign #(in_delay) delay_PIPERX0STATUS = PIPERX0STATUS;
  assign #(in_delay) delay_PIPERX0VALID = PIPERX0VALID;
  assign #(in_delay) delay_PIPERX1CHANISALIGNED = PIPERX1CHANISALIGNED;
  assign #(in_delay) delay_PIPERX1CHARISK = PIPERX1CHARISK;
  assign #(in_delay) delay_PIPERX1DATA = PIPERX1DATA;
  assign #(in_delay) delay_PIPERX1ELECIDLE = PIPERX1ELECIDLE;
  assign #(in_delay) delay_PIPERX1PHYSTATUS = PIPERX1PHYSTATUS;
  assign #(in_delay) delay_PIPERX1STATUS = PIPERX1STATUS;
  assign #(in_delay) delay_PIPERX1VALID = PIPERX1VALID;
  assign #(in_delay) delay_PIPERX2CHANISALIGNED = PIPERX2CHANISALIGNED;
  assign #(in_delay) delay_PIPERX2CHARISK = PIPERX2CHARISK;
  assign #(in_delay) delay_PIPERX2DATA = PIPERX2DATA;
  assign #(in_delay) delay_PIPERX2ELECIDLE = PIPERX2ELECIDLE;
  assign #(in_delay) delay_PIPERX2PHYSTATUS = PIPERX2PHYSTATUS;
  assign #(in_delay) delay_PIPERX2STATUS = PIPERX2STATUS;
  assign #(in_delay) delay_PIPERX2VALID = PIPERX2VALID;
  assign #(in_delay) delay_PIPERX3CHANISALIGNED = PIPERX3CHANISALIGNED;
  assign #(in_delay) delay_PIPERX3CHARISK = PIPERX3CHARISK;
  assign #(in_delay) delay_PIPERX3DATA = PIPERX3DATA;
  assign #(in_delay) delay_PIPERX3ELECIDLE = PIPERX3ELECIDLE;
  assign #(in_delay) delay_PIPERX3PHYSTATUS = PIPERX3PHYSTATUS;
  assign #(in_delay) delay_PIPERX3STATUS = PIPERX3STATUS;
  assign #(in_delay) delay_PIPERX3VALID = PIPERX3VALID;
  assign #(in_delay) delay_PIPERX4CHANISALIGNED = PIPERX4CHANISALIGNED;
  assign #(in_delay) delay_PIPERX4CHARISK = PIPERX4CHARISK;
  assign #(in_delay) delay_PIPERX4DATA = PIPERX4DATA;
  assign #(in_delay) delay_PIPERX4ELECIDLE = PIPERX4ELECIDLE;
  assign #(in_delay) delay_PIPERX4PHYSTATUS = PIPERX4PHYSTATUS;
  assign #(in_delay) delay_PIPERX4STATUS = PIPERX4STATUS;
  assign #(in_delay) delay_PIPERX4VALID = PIPERX4VALID;
  assign #(in_delay) delay_PIPERX5CHANISALIGNED = PIPERX5CHANISALIGNED;
  assign #(in_delay) delay_PIPERX5CHARISK = PIPERX5CHARISK;
  assign #(in_delay) delay_PIPERX5DATA = PIPERX5DATA;
  assign #(in_delay) delay_PIPERX5ELECIDLE = PIPERX5ELECIDLE;
  assign #(in_delay) delay_PIPERX5PHYSTATUS = PIPERX5PHYSTATUS;
  assign #(in_delay) delay_PIPERX5STATUS = PIPERX5STATUS;
  assign #(in_delay) delay_PIPERX5VALID = PIPERX5VALID;
  assign #(in_delay) delay_PIPERX6CHANISALIGNED = PIPERX6CHANISALIGNED;
  assign #(in_delay) delay_PIPERX6CHARISK = PIPERX6CHARISK;
  assign #(in_delay) delay_PIPERX6DATA = PIPERX6DATA;
  assign #(in_delay) delay_PIPERX6ELECIDLE = PIPERX6ELECIDLE;
  assign #(in_delay) delay_PIPERX6PHYSTATUS = PIPERX6PHYSTATUS;
  assign #(in_delay) delay_PIPERX6STATUS = PIPERX6STATUS;
  assign #(in_delay) delay_PIPERX6VALID = PIPERX6VALID;
  assign #(in_delay) delay_PIPERX7CHANISALIGNED = PIPERX7CHANISALIGNED;
  assign #(in_delay) delay_PIPERX7CHARISK = PIPERX7CHARISK;
  assign #(in_delay) delay_PIPERX7DATA = PIPERX7DATA;
  assign #(in_delay) delay_PIPERX7ELECIDLE = PIPERX7ELECIDLE;
  assign #(in_delay) delay_PIPERX7PHYSTATUS = PIPERX7PHYSTATUS;
  assign #(in_delay) delay_PIPERX7STATUS = PIPERX7STATUS;
  assign #(in_delay) delay_PIPERX7VALID = PIPERX7VALID;
  assign #(in_delay) delay_PL2DIRECTEDLSTATE = PL2DIRECTEDLSTATE;
  assign #(in_delay) delay_PLDBGMODE = PLDBGMODE;
  assign #(in_delay) delay_PLDIRECTEDLINKAUTON = PLDIRECTEDLINKAUTON;
  assign #(in_delay) delay_PLDIRECTEDLINKCHANGE = PLDIRECTEDLINKCHANGE;
  assign #(in_delay) delay_PLDIRECTEDLINKSPEED = PLDIRECTEDLINKSPEED;
  assign #(in_delay) delay_PLDIRECTEDLINKWIDTH = PLDIRECTEDLINKWIDTH;
  assign #(in_delay) delay_PLDOWNSTREAMDEEMPHSOURCE = PLDOWNSTREAMDEEMPHSOURCE;
  assign #(in_delay) delay_PLRSTN = PLRSTN;
  assign #(in_delay) delay_PLTRANSMITHOTRST = PLTRANSMITHOTRST;
  assign #(in_delay) delay_PLUPSTREAMPREFERDEEMPH = PLUPSTREAMPREFERDEEMPH;
  assign #(in_delay) delay_SYSRSTN = SYSRSTN;
  assign #(in_delay) delay_TL2ASPMSUSPENDCREDITCHECKN = TL2ASPMSUSPENDCREDITCHECKN;
  assign #(in_delay) delay_TL2PPMSUSPENDREQN = TL2PPMSUSPENDREQN;
  assign #(in_delay) delay_TLRSTN = TLRSTN;
  assign #(in_delay) delay_TRNFCSEL = TRNFCSEL;
  assign #(in_delay) delay_TRNRDSTRDYN = TRNRDSTRDYN;
  assign #(in_delay) delay_TRNRNPOKN = TRNRNPOKN;
  assign #(in_delay) delay_TRNTCFGGNTN = TRNTCFGGNTN;
  assign #(in_delay) delay_TRNTD = TRNTD;
  assign #(in_delay) delay_TRNTDLLPDATA = TRNTDLLPDATA;
  assign #(in_delay) delay_TRNTDLLPSRCRDYN = TRNTDLLPSRCRDYN;
  assign #(in_delay) delay_TRNTECRCGENN = TRNTECRCGENN;
  assign #(in_delay) delay_TRNTEOFN = TRNTEOFN;
  assign #(in_delay) delay_TRNTERRFWDN = TRNTERRFWDN;
  assign #(in_delay) delay_TRNTREMN = TRNTREMN;
  assign #(in_delay) delay_TRNTSOFN = TRNTSOFN;
  assign #(in_delay) delay_TRNTSRCDSCN = TRNTSRCDSCN;
  assign #(in_delay) delay_TRNTSRCRDYN = TRNTSRCRDYN;
  assign #(in_delay) delay_TRNTSTRN = TRNTSTRN;

  B_PCIE_2_0 #(
    .AER_BASE_PTR (AER_BASE_PTR),
    .AER_CAP_ECRC_CHECK_CAPABLE (AER_CAP_ECRC_CHECK_CAPABLE),
    .AER_CAP_ECRC_GEN_CAPABLE (AER_CAP_ECRC_GEN_CAPABLE),
    .AER_CAP_ID (AER_CAP_ID),
    .AER_CAP_INT_MSG_NUM_MSI (AER_CAP_INT_MSG_NUM_MSI),
    .AER_CAP_INT_MSG_NUM_MSIX (AER_CAP_INT_MSG_NUM_MSIX),
    .AER_CAP_NEXTPTR (AER_CAP_NEXTPTR),
    .AER_CAP_ON (AER_CAP_ON),
    .AER_CAP_PERMIT_ROOTERR_UPDATE (AER_CAP_PERMIT_ROOTERR_UPDATE),
    .AER_CAP_VERSION (AER_CAP_VERSION),
    .ALLOW_X8_GEN2 (ALLOW_X8_GEN2),
    .BAR0 (BAR0),
    .BAR1 (BAR1),
    .BAR2 (BAR2),
    .BAR3 (BAR3),
    .BAR4 (BAR4),
    .BAR5 (BAR5),
    .CAPABILITIES_PTR (CAPABILITIES_PTR),
    .CARDBUS_CIS_POINTER (CARDBUS_CIS_POINTER),
    .CLASS_CODE (CLASS_CODE),
    .CMD_INTX_IMPLEMENTED (CMD_INTX_IMPLEMENTED),
    .CPL_TIMEOUT_DISABLE_SUPPORTED (CPL_TIMEOUT_DISABLE_SUPPORTED),
    .CPL_TIMEOUT_RANGES_SUPPORTED (CPL_TIMEOUT_RANGES_SUPPORTED),
    .CRM_MODULE_RSTS (CRM_MODULE_RSTS),
    .DEVICE_ID (DEVICE_ID),
    .DEV_CAP_ENABLE_SLOT_PWR_LIMIT_SCALE (DEV_CAP_ENABLE_SLOT_PWR_LIMIT_SCALE),
    .DEV_CAP_ENABLE_SLOT_PWR_LIMIT_VALUE (DEV_CAP_ENABLE_SLOT_PWR_LIMIT_VALUE),
    .DEV_CAP_ENDPOINT_L0S_LATENCY (DEV_CAP_ENDPOINT_L0S_LATENCY),
    .DEV_CAP_ENDPOINT_L1_LATENCY (DEV_CAP_ENDPOINT_L1_LATENCY),
    .DEV_CAP_EXT_TAG_SUPPORTED (DEV_CAP_EXT_TAG_SUPPORTED),
    .DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE (DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE),
    .DEV_CAP_MAX_PAYLOAD_SUPPORTED (DEV_CAP_MAX_PAYLOAD_SUPPORTED),
    .DEV_CAP_PHANTOM_FUNCTIONS_SUPPORT (DEV_CAP_PHANTOM_FUNCTIONS_SUPPORT),
    .DEV_CAP_ROLE_BASED_ERROR (DEV_CAP_ROLE_BASED_ERROR),
    .DEV_CAP_RSVD_14_12 (DEV_CAP_RSVD_14_12),
    .DEV_CAP_RSVD_17_16 (DEV_CAP_RSVD_17_16),
    .DEV_CAP_RSVD_31_29 (DEV_CAP_RSVD_31_29),
    .DEV_CONTROL_AUX_POWER_SUPPORTED (DEV_CONTROL_AUX_POWER_SUPPORTED),
    .DISABLE_ASPM_L1_TIMER (DISABLE_ASPM_L1_TIMER),
    .DISABLE_BAR_FILTERING (DISABLE_BAR_FILTERING),
    .DISABLE_ID_CHECK (DISABLE_ID_CHECK),
    .DISABLE_LANE_REVERSAL (DISABLE_LANE_REVERSAL),
    .DISABLE_RX_TC_FILTER (DISABLE_RX_TC_FILTER),
    .DISABLE_SCRAMBLING (DISABLE_SCRAMBLING),
    .DNSTREAM_LINK_NUM (DNSTREAM_LINK_NUM),
    .DSN_BASE_PTR (DSN_BASE_PTR),
    .DSN_CAP_ID (DSN_CAP_ID),
    .DSN_CAP_NEXTPTR (DSN_CAP_NEXTPTR),
    .DSN_CAP_ON (DSN_CAP_ON),
    .DSN_CAP_VERSION (DSN_CAP_VERSION),
    .ENABLE_MSG_ROUTE (ENABLE_MSG_ROUTE),
    .ENABLE_RX_TD_ECRC_TRIM (ENABLE_RX_TD_ECRC_TRIM),
    .ENTER_RVRY_EI_L0 (ENTER_RVRY_EI_L0),
    .EXIT_LOOPBACK_ON_EI (EXIT_LOOPBACK_ON_EI),       
    .EXPANSION_ROM (EXPANSION_ROM),
    .EXT_CFG_CAP_PTR (EXT_CFG_CAP_PTR),
    .EXT_CFG_XP_CAP_PTR (EXT_CFG_XP_CAP_PTR),
    .HEADER_TYPE (HEADER_TYPE),
    .INFER_EI (INFER_EI),
    .INTERRUPT_PIN (INTERRUPT_PIN),
    .IS_SWITCH (IS_SWITCH),
    .LAST_CONFIG_DWORD (LAST_CONFIG_DWORD),
    .LINK_CAP_ASPM_SUPPORT (LINK_CAP_ASPM_SUPPORT),
    .LINK_CAP_CLOCK_POWER_MANAGEMENT (LINK_CAP_CLOCK_POWER_MANAGEMENT),
    .LINK_CAP_DLL_LINK_ACTIVE_REPORTING_CAP (LINK_CAP_DLL_LINK_ACTIVE_REPORTING_CAP),
    .LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1 (LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1),
    .LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2 (LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2),
    .LINK_CAP_L0S_EXIT_LATENCY_GEN1 (LINK_CAP_L0S_EXIT_LATENCY_GEN1),
    .LINK_CAP_L0S_EXIT_LATENCY_GEN2 (LINK_CAP_L0S_EXIT_LATENCY_GEN2),
    .LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1 (LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1),
    .LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2 (LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2),
    .LINK_CAP_L1_EXIT_LATENCY_GEN1 (LINK_CAP_L1_EXIT_LATENCY_GEN1),
    .LINK_CAP_L1_EXIT_LATENCY_GEN2 (LINK_CAP_L1_EXIT_LATENCY_GEN2),
    .LINK_CAP_LINK_BANDWIDTH_NOTIFICATION_CAP (LINK_CAP_LINK_BANDWIDTH_NOTIFICATION_CAP),
    .LINK_CAP_MAX_LINK_SPEED (LINK_CAP_MAX_LINK_SPEED),
    .LINK_CAP_MAX_LINK_WIDTH (LINK_CAP_MAX_LINK_WIDTH),
    .LINK_CAP_RSVD_23_22 (LINK_CAP_RSVD_23_22),
    .LINK_CAP_SURPRISE_DOWN_ERROR_CAPABLE (LINK_CAP_SURPRISE_DOWN_ERROR_CAPABLE),
    .LINK_CONTROL_RCB (LINK_CONTROL_RCB),
    .LINK_CTRL2_DEEMPHASIS (LINK_CTRL2_DEEMPHASIS),
    .LINK_CTRL2_HW_AUTONOMOUS_SPEED_DISABLE (LINK_CTRL2_HW_AUTONOMOUS_SPEED_DISABLE),
    .LINK_CTRL2_TARGET_LINK_SPEED (LINK_CTRL2_TARGET_LINK_SPEED),
    .LINK_STATUS_SLOT_CLOCK_CONFIG (LINK_STATUS_SLOT_CLOCK_CONFIG),
    .LL_ACK_TIMEOUT (LL_ACK_TIMEOUT),
    .LL_ACK_TIMEOUT_EN (LL_ACK_TIMEOUT_EN),
    .LL_ACK_TIMEOUT_FUNC (LL_ACK_TIMEOUT_FUNC),
    .LL_REPLAY_TIMEOUT (LL_REPLAY_TIMEOUT),
    .LL_REPLAY_TIMEOUT_EN (LL_REPLAY_TIMEOUT_EN),
    .LL_REPLAY_TIMEOUT_FUNC (LL_REPLAY_TIMEOUT_FUNC),
    .LTSSM_MAX_LINK_WIDTH (LTSSM_MAX_LINK_WIDTH),
    .MSIX_BASE_PTR (MSIX_BASE_PTR),
    .MSIX_CAP_ID (MSIX_CAP_ID),
    .MSIX_CAP_NEXTPTR (MSIX_CAP_NEXTPTR),
    .MSIX_CAP_ON (MSIX_CAP_ON),
    .MSIX_CAP_PBA_BIR (MSIX_CAP_PBA_BIR),
    .MSIX_CAP_PBA_OFFSET (MSIX_CAP_PBA_OFFSET),
    .MSIX_CAP_TABLE_BIR (MSIX_CAP_TABLE_BIR),
    .MSIX_CAP_TABLE_OFFSET (MSIX_CAP_TABLE_OFFSET),
    .MSIX_CAP_TABLE_SIZE (MSIX_CAP_TABLE_SIZE),
    .MSI_BASE_PTR (MSI_BASE_PTR),
    .MSI_CAP_64_BIT_ADDR_CAPABLE (MSI_CAP_64_BIT_ADDR_CAPABLE),
    .MSI_CAP_ID (MSI_CAP_ID),
    .MSI_CAP_MULTIMSGCAP (MSI_CAP_MULTIMSGCAP),
    .MSI_CAP_MULTIMSG_EXTENSION (MSI_CAP_MULTIMSG_EXTENSION),
    .MSI_CAP_NEXTPTR (MSI_CAP_NEXTPTR),
    .MSI_CAP_ON (MSI_CAP_ON),
    .MSI_CAP_PER_VECTOR_MASKING_CAPABLE (MSI_CAP_PER_VECTOR_MASKING_CAPABLE),
    .N_FTS_COMCLK_GEN1 (N_FTS_COMCLK_GEN1),
    .N_FTS_COMCLK_GEN2 (N_FTS_COMCLK_GEN2),
    .N_FTS_GEN1 (N_FTS_GEN1),
    .N_FTS_GEN2 (N_FTS_GEN2),
    .PCIE_BASE_PTR (PCIE_BASE_PTR),
    .PCIE_CAP_CAPABILITY_ID (PCIE_CAP_CAPABILITY_ID),
    .PCIE_CAP_CAPABILITY_VERSION (PCIE_CAP_CAPABILITY_VERSION),
    .PCIE_CAP_DEVICE_PORT_TYPE (PCIE_CAP_DEVICE_PORT_TYPE),
    .PCIE_CAP_INT_MSG_NUM (PCIE_CAP_INT_MSG_NUM),
    .PCIE_CAP_NEXTPTR (PCIE_CAP_NEXTPTR),
    .PCIE_CAP_ON (PCIE_CAP_ON),
    .PCIE_CAP_RSVD_15_14 (PCIE_CAP_RSVD_15_14),
    .PCIE_CAP_SLOT_IMPLEMENTED (PCIE_CAP_SLOT_IMPLEMENTED),
    .PCIE_REVISION (PCIE_REVISION),
    .PGL0_LANE (PGL0_LANE),
    .PGL1_LANE (PGL1_LANE),
    .PGL2_LANE (PGL2_LANE),
    .PGL3_LANE (PGL3_LANE),
    .PGL4_LANE (PGL4_LANE),
    .PGL5_LANE (PGL5_LANE),
    .PGL6_LANE (PGL6_LANE),
    .PGL7_LANE (PGL7_LANE),
    .PL_AUTO_CONFIG (PL_AUTO_CONFIG),
    .PL_FAST_TRAIN (PL_FAST_TRAIN),
    .PM_BASE_PTR (PM_BASE_PTR),
    .PM_CAP_AUXCURRENT (PM_CAP_AUXCURRENT),
    .PM_CAP_D1SUPPORT (PM_CAP_D1SUPPORT),
    .PM_CAP_D2SUPPORT (PM_CAP_D2SUPPORT),
    .PM_CAP_DSI (PM_CAP_DSI),
    .PM_CAP_ID (PM_CAP_ID),
    .PM_CAP_NEXTPTR (PM_CAP_NEXTPTR),
    .PM_CAP_ON (PM_CAP_ON),
    .PM_CAP_PMESUPPORT (PM_CAP_PMESUPPORT),
    .PM_CAP_PME_CLOCK (PM_CAP_PME_CLOCK),
    .PM_CAP_RSVD_04 (PM_CAP_RSVD_04),
    .PM_CAP_VERSION (PM_CAP_VERSION),
    .PM_CSR_B2B3 (PM_CSR_B2B3),
    .PM_CSR_BPCCEN (PM_CSR_BPCCEN),
    .PM_CSR_NOSOFTRST (PM_CSR_NOSOFTRST),
    .PM_DATA0 (PM_DATA0),
    .PM_DATA1 (PM_DATA1),
    .PM_DATA2 (PM_DATA2),
    .PM_DATA3 (PM_DATA3),
    .PM_DATA4 (PM_DATA4),
    .PM_DATA5 (PM_DATA5),
    .PM_DATA6 (PM_DATA6),
    .PM_DATA7 (PM_DATA7),
    .PM_DATA_SCALE0 (PM_DATA_SCALE0),
    .PM_DATA_SCALE1 (PM_DATA_SCALE1),
    .PM_DATA_SCALE2 (PM_DATA_SCALE2),
    .PM_DATA_SCALE3 (PM_DATA_SCALE3),
    .PM_DATA_SCALE4 (PM_DATA_SCALE4),
    .PM_DATA_SCALE5 (PM_DATA_SCALE5),
    .PM_DATA_SCALE6 (PM_DATA_SCALE6),
    .PM_DATA_SCALE7 (PM_DATA_SCALE7),
    .RECRC_CHK (RECRC_CHK),
    .RECRC_CHK_TRIM (RECRC_CHK_TRIM),
    .REVISION_ID (REVISION_ID),
    .ROOT_CAP_CRS_SW_VISIBILITY (ROOT_CAP_CRS_SW_VISIBILITY),
    .SELECT_DLL_IF (SELECT_DLL_IF),
    .SIM_VERSION (SIM_VERSION),    
    .SLOT_CAP_ATT_BUTTON_PRESENT (SLOT_CAP_ATT_BUTTON_PRESENT),
    .SLOT_CAP_ATT_INDICATOR_PRESENT (SLOT_CAP_ATT_INDICATOR_PRESENT),
    .SLOT_CAP_ELEC_INTERLOCK_PRESENT (SLOT_CAP_ELEC_INTERLOCK_PRESENT),
    .SLOT_CAP_HOTPLUG_CAPABLE (SLOT_CAP_HOTPLUG_CAPABLE),
    .SLOT_CAP_HOTPLUG_SURPRISE (SLOT_CAP_HOTPLUG_SURPRISE),
    .SLOT_CAP_MRL_SENSOR_PRESENT (SLOT_CAP_MRL_SENSOR_PRESENT),
    .SLOT_CAP_NO_CMD_COMPLETED_SUPPORT (SLOT_CAP_NO_CMD_COMPLETED_SUPPORT),
    .SLOT_CAP_PHYSICAL_SLOT_NUM (SLOT_CAP_PHYSICAL_SLOT_NUM),
    .SLOT_CAP_POWER_CONTROLLER_PRESENT (SLOT_CAP_POWER_CONTROLLER_PRESENT),
    .SLOT_CAP_POWER_INDICATOR_PRESENT (SLOT_CAP_POWER_INDICATOR_PRESENT),
    .SLOT_CAP_SLOT_POWER_LIMIT_SCALE (SLOT_CAP_SLOT_POWER_LIMIT_SCALE),
    .SLOT_CAP_SLOT_POWER_LIMIT_VALUE (SLOT_CAP_SLOT_POWER_LIMIT_VALUE),
    .SPARE_BIT0 (SPARE_BIT0),
    .SPARE_BIT1 (SPARE_BIT1),
    .SPARE_BIT2 (SPARE_BIT2),
    .SPARE_BIT3 (SPARE_BIT3),
    .SPARE_BIT4 (SPARE_BIT4),
    .SPARE_BIT5 (SPARE_BIT5),
    .SPARE_BIT6 (SPARE_BIT6),
    .SPARE_BIT7 (SPARE_BIT7),
    .SPARE_BIT8 (SPARE_BIT8),
    .SPARE_BYTE0 (SPARE_BYTE0),
    .SPARE_BYTE1 (SPARE_BYTE1),
    .SPARE_BYTE2 (SPARE_BYTE2),
    .SPARE_BYTE3 (SPARE_BYTE3),
    .SPARE_WORD0 (SPARE_WORD0),
    .SPARE_WORD1 (SPARE_WORD1),
    .SPARE_WORD2 (SPARE_WORD2),
    .SPARE_WORD3 (SPARE_WORD3),
    .SUBSYSTEM_ID (SUBSYSTEM_ID),
    .SUBSYSTEM_VENDOR_ID (SUBSYSTEM_VENDOR_ID),
    .TL_RBYPASS (TL_RBYPASS),
    .TL_RX_RAM_RADDR_LATENCY (TL_RX_RAM_RADDR_LATENCY),
    .TL_RX_RAM_RDATA_LATENCY (TL_RX_RAM_RDATA_LATENCY),
    .TL_RX_RAM_WRITE_LATENCY (TL_RX_RAM_WRITE_LATENCY),
    .TL_TFC_DISABLE (TL_TFC_DISABLE),
    .TL_TX_CHECKS_DISABLE (TL_TX_CHECKS_DISABLE),
    .TL_TX_RAM_RADDR_LATENCY (TL_TX_RAM_RADDR_LATENCY),
    .TL_TX_RAM_RDATA_LATENCY (TL_TX_RAM_RDATA_LATENCY),
    .TL_TX_RAM_WRITE_LATENCY (TL_TX_RAM_WRITE_LATENCY),
    .UPCONFIG_CAPABLE (UPCONFIG_CAPABLE),
    .UPSTREAM_FACING (UPSTREAM_FACING),
    .UR_INV_REQ (UR_INV_REQ),
    .USER_CLK_FREQ (USER_CLK_FREQ),
    .VC0_CPL_INFINITE (VC0_CPL_INFINITE),
    .VC0_RX_RAM_LIMIT (VC0_RX_RAM_LIMIT),
    .VC0_TOTAL_CREDITS_CD (VC0_TOTAL_CREDITS_CD),
    .VC0_TOTAL_CREDITS_CH (VC0_TOTAL_CREDITS_CH),
    .VC0_TOTAL_CREDITS_NPH (VC0_TOTAL_CREDITS_NPH),
    .VC0_TOTAL_CREDITS_PD (VC0_TOTAL_CREDITS_PD),
    .VC0_TOTAL_CREDITS_PH (VC0_TOTAL_CREDITS_PH),
    .VC0_TX_LASTPACKET (VC0_TX_LASTPACKET),
    .VC_BASE_PTR (VC_BASE_PTR),
    .VC_CAP_ID (VC_CAP_ID),
    .VC_CAP_NEXTPTR (VC_CAP_NEXTPTR),
    .VC_CAP_ON (VC_CAP_ON),
    .VC_CAP_REJECT_SNOOP_TRANSACTIONS (VC_CAP_REJECT_SNOOP_TRANSACTIONS),
    .VC_CAP_VERSION (VC_CAP_VERSION),
    .VENDOR_ID (VENDOR_ID),
    .VSEC_BASE_PTR (VSEC_BASE_PTR),
    .VSEC_CAP_HDR_ID (VSEC_CAP_HDR_ID),
    .VSEC_CAP_HDR_LENGTH (VSEC_CAP_HDR_LENGTH),
    .VSEC_CAP_HDR_REVISION (VSEC_CAP_HDR_REVISION),
    .VSEC_CAP_ID (VSEC_CAP_ID),
    .VSEC_CAP_IS_LINK_VISIBLE (VSEC_CAP_IS_LINK_VISIBLE),
    .VSEC_CAP_NEXTPTR (VSEC_CAP_NEXTPTR),
    .VSEC_CAP_ON (VSEC_CAP_ON),
    .VSEC_CAP_VERSION (VSEC_CAP_VERSION))

    B_PCIE_2_0_INST(
    .CFGAERECRCCHECKEN (delay_CFGAERECRCCHECKEN),
    .CFGAERECRCGENEN (delay_CFGAERECRCGENEN),
    .CFGCOMMANDBUSMASTERENABLE (delay_CFGCOMMANDBUSMASTERENABLE),
    .CFGCOMMANDINTERRUPTDISABLE (delay_CFGCOMMANDINTERRUPTDISABLE),
    .CFGCOMMANDIOENABLE (delay_CFGCOMMANDIOENABLE),
    .CFGCOMMANDMEMENABLE (delay_CFGCOMMANDMEMENABLE),
    .CFGCOMMANDSERREN (delay_CFGCOMMANDSERREN),
    .CFGDEVCONTROL2CPLTIMEOUTDIS (delay_CFGDEVCONTROL2CPLTIMEOUTDIS),
    .CFGDEVCONTROL2CPLTIMEOUTVAL (delay_CFGDEVCONTROL2CPLTIMEOUTVAL),
    .CFGDEVCONTROLAUXPOWEREN (delay_CFGDEVCONTROLAUXPOWEREN),
    .CFGDEVCONTROLCORRERRREPORTINGEN (delay_CFGDEVCONTROLCORRERRREPORTINGEN),
    .CFGDEVCONTROLENABLERO (delay_CFGDEVCONTROLENABLERO),
    .CFGDEVCONTROLEXTTAGEN (delay_CFGDEVCONTROLEXTTAGEN),
    .CFGDEVCONTROLFATALERRREPORTINGEN (delay_CFGDEVCONTROLFATALERRREPORTINGEN),
    .CFGDEVCONTROLMAXPAYLOAD (delay_CFGDEVCONTROLMAXPAYLOAD),
    .CFGDEVCONTROLMAXREADREQ (delay_CFGDEVCONTROLMAXREADREQ),
    .CFGDEVCONTROLNONFATALREPORTINGEN (delay_CFGDEVCONTROLNONFATALREPORTINGEN),
    .CFGDEVCONTROLNOSNOOPEN (delay_CFGDEVCONTROLNOSNOOPEN),
    .CFGDEVCONTROLPHANTOMEN (delay_CFGDEVCONTROLPHANTOMEN),
    .CFGDEVCONTROLURERRREPORTINGEN (delay_CFGDEVCONTROLURERRREPORTINGEN),
    .CFGDEVSTATUSCORRERRDETECTED (delay_CFGDEVSTATUSCORRERRDETECTED),
    .CFGDEVSTATUSFATALERRDETECTED (delay_CFGDEVSTATUSFATALERRDETECTED),
    .CFGDEVSTATUSNONFATALERRDETECTED (delay_CFGDEVSTATUSNONFATALERRDETECTED),
    .CFGDEVSTATUSURDETECTED (delay_CFGDEVSTATUSURDETECTED),
    .CFGDO (delay_CFGDO),
    .CFGERRAERHEADERLOGSETN (delay_CFGERRAERHEADERLOGSETN),
    .CFGERRCPLRDYN (delay_CFGERRCPLRDYN),
    .CFGINTERRUPTDO (delay_CFGINTERRUPTDO),
    .CFGINTERRUPTMMENABLE (delay_CFGINTERRUPTMMENABLE),
    .CFGINTERRUPTMSIENABLE (delay_CFGINTERRUPTMSIENABLE),
    .CFGINTERRUPTMSIXENABLE (delay_CFGINTERRUPTMSIXENABLE),
    .CFGINTERRUPTMSIXFM (delay_CFGINTERRUPTMSIXFM),
    .CFGINTERRUPTRDYN (delay_CFGINTERRUPTRDYN),
    .CFGLINKCONTROLASPMCONTROL (delay_CFGLINKCONTROLASPMCONTROL),
    .CFGLINKCONTROLAUTOBANDWIDTHINTEN (delay_CFGLINKCONTROLAUTOBANDWIDTHINTEN),
    .CFGLINKCONTROLBANDWIDTHINTEN (delay_CFGLINKCONTROLBANDWIDTHINTEN),
    .CFGLINKCONTROLCLOCKPMEN (delay_CFGLINKCONTROLCLOCKPMEN),
    .CFGLINKCONTROLCOMMONCLOCK (delay_CFGLINKCONTROLCOMMONCLOCK),
    .CFGLINKCONTROLEXTENDEDSYNC (delay_CFGLINKCONTROLEXTENDEDSYNC),
    .CFGLINKCONTROLHWAUTOWIDTHDIS (delay_CFGLINKCONTROLHWAUTOWIDTHDIS),
    .CFGLINKCONTROLLINKDISABLE (delay_CFGLINKCONTROLLINKDISABLE),
    .CFGLINKCONTROLRCB (delay_CFGLINKCONTROLRCB),
    .CFGLINKCONTROLRETRAINLINK (delay_CFGLINKCONTROLRETRAINLINK),
    .CFGLINKSTATUSAUTOBANDWIDTHSTATUS (delay_CFGLINKSTATUSAUTOBANDWIDTHSTATUS),
    .CFGLINKSTATUSBANDWITHSTATUS (delay_CFGLINKSTATUSBANDWITHSTATUS),
    .CFGLINKSTATUSCURRENTSPEED (delay_CFGLINKSTATUSCURRENTSPEED),
    .CFGLINKSTATUSDLLACTIVE (delay_CFGLINKSTATUSDLLACTIVE),
    .CFGLINKSTATUSLINKTRAINING (delay_CFGLINKSTATUSLINKTRAINING),
    .CFGLINKSTATUSNEGOTIATEDWIDTH (delay_CFGLINKSTATUSNEGOTIATEDWIDTH),
    .CFGMSGDATA (delay_CFGMSGDATA),
    .CFGMSGRECEIVED (delay_CFGMSGRECEIVED),
    .CFGMSGRECEIVEDASSERTINTA (delay_CFGMSGRECEIVEDASSERTINTA),
    .CFGMSGRECEIVEDASSERTINTB (delay_CFGMSGRECEIVEDASSERTINTB),
    .CFGMSGRECEIVEDASSERTINTC (delay_CFGMSGRECEIVEDASSERTINTC),
    .CFGMSGRECEIVEDASSERTINTD (delay_CFGMSGRECEIVEDASSERTINTD),
    .CFGMSGRECEIVEDDEASSERTINTA (delay_CFGMSGRECEIVEDDEASSERTINTA),
    .CFGMSGRECEIVEDDEASSERTINTB (delay_CFGMSGRECEIVEDDEASSERTINTB),
    .CFGMSGRECEIVEDDEASSERTINTC (delay_CFGMSGRECEIVEDDEASSERTINTC),
    .CFGMSGRECEIVEDDEASSERTINTD (delay_CFGMSGRECEIVEDDEASSERTINTD),
    .CFGMSGRECEIVEDERRCOR (delay_CFGMSGRECEIVEDERRCOR),
    .CFGMSGRECEIVEDERRFATAL (delay_CFGMSGRECEIVEDERRFATAL),
    .CFGMSGRECEIVEDERRNONFATAL (delay_CFGMSGRECEIVEDERRNONFATAL),
    .CFGMSGRECEIVEDPMASNAK (delay_CFGMSGRECEIVEDPMASNAK),
    .CFGMSGRECEIVEDPMETO (delay_CFGMSGRECEIVEDPMETO),
    .CFGMSGRECEIVEDPMETOACK (delay_CFGMSGRECEIVEDPMETOACK),
    .CFGMSGRECEIVEDPMPME (delay_CFGMSGRECEIVEDPMPME),
    .CFGMSGRECEIVEDSETSLOTPOWERLIMIT (delay_CFGMSGRECEIVEDSETSLOTPOWERLIMIT),
    .CFGMSGRECEIVEDUNLOCK (delay_CFGMSGRECEIVEDUNLOCK),
    .CFGPCIELINKSTATE (delay_CFGPCIELINKSTATE),
    .CFGPMCSRPMEEN (delay_CFGPMCSRPMEEN),
    .CFGPMCSRPMESTATUS(delay_CFGPMCSRPMESTATUS),
    .CFGPMCSRPOWERSTATE(delay_CFGPMCSRPOWERSTATE),
    .CFGPMRCVASREQL1N (delay_CFGPMRCVASREQL1N),
    .CFGPMRCVENTERL1N (delay_CFGPMRCVENTERL1N),
    .CFGPMRCVENTERL23N (delay_CFGPMRCVENTERL23N),
    .CFGPMRCVREQACKN (delay_CFGPMRCVREQACKN),
    .CFGRDWRDONEN (delay_CFGRDWRDONEN),
    .CFGSLOTCONTROLELECTROMECHILCTLPULSE (delay_CFGSLOTCONTROLELECTROMECHILCTLPULSE),
    .CFGTRANSACTION (delay_CFGTRANSACTION),
    .CFGTRANSACTIONADDR (delay_CFGTRANSACTIONADDR),
    .CFGTRANSACTIONTYPE (delay_CFGTRANSACTIONTYPE),
    .CFGVCTCVCMAP (delay_CFGVCTCVCMAP),
    .DBGSCLRA (delay_DBGSCLRA),
    .DBGSCLRB (delay_DBGSCLRB),
    .DBGSCLRC (delay_DBGSCLRC),
    .DBGSCLRD (delay_DBGSCLRD),
    .DBGSCLRE (delay_DBGSCLRE),
    .DBGSCLRF (delay_DBGSCLRF),
    .DBGSCLRG (delay_DBGSCLRG),
    .DBGSCLRH (delay_DBGSCLRH),
    .DBGSCLRI (delay_DBGSCLRI),
    .DBGSCLRJ (delay_DBGSCLRJ),
    .DBGSCLRK (delay_DBGSCLRK),
    .DBGVECA (delay_DBGVECA),
    .DBGVECB (delay_DBGVECB),
    .DBGVECC (delay_DBGVECC),
    .DRPDO (delay_DRPDO),
    .DRPDRDY (delay_DRPDRDY),
    .LL2BADDLLPERRN (delay_LL2BADDLLPERRN),
    .LL2BADTLPERRN (delay_LL2BADTLPERRN),
    .LL2PROTOCOLERRN (delay_LL2PROTOCOLERRN),
    .LL2REPLAYROERRN (delay_LL2REPLAYROERRN),
    .LL2REPLAYTOERRN (delay_LL2REPLAYTOERRN),
    .LL2SUSPENDOKN (delay_LL2SUSPENDOKN),
    .LL2TFCINIT1SEQN (delay_LL2TFCINIT1SEQN),
    .LL2TFCINIT2SEQN (delay_LL2TFCINIT2SEQN),
    .LNKCLKEN (delay_LNKCLKEN),
    .MIMRXRADDR (delay_MIMRXRADDR),
    .MIMRXRCE (delay_MIMRXRCE),
    .MIMRXREN (delay_MIMRXREN),
    .MIMRXWADDR (delay_MIMRXWADDR),
    .MIMRXWDATA (delay_MIMRXWDATA),
    .MIMRXWEN (delay_MIMRXWEN),
    .MIMTXRADDR (delay_MIMTXRADDR),
    .MIMTXRCE (delay_MIMTXRCE),
    .MIMTXREN (delay_MIMTXREN),
    .MIMTXWADDR (delay_MIMTXWADDR),
    .MIMTXWDATA (delay_MIMTXWDATA),
    .MIMTXWEN (delay_MIMTXWEN),
    .PIPERX0POLARITY (delay_PIPERX0POLARITY),
    .PIPERX1POLARITY (delay_PIPERX1POLARITY),
    .PIPERX2POLARITY (delay_PIPERX2POLARITY),
    .PIPERX3POLARITY (delay_PIPERX3POLARITY),
    .PIPERX4POLARITY (delay_PIPERX4POLARITY),
    .PIPERX5POLARITY (delay_PIPERX5POLARITY),
    .PIPERX6POLARITY (delay_PIPERX6POLARITY),
    .PIPERX7POLARITY (delay_PIPERX7POLARITY),
    .PIPETX0CHARISK (delay_PIPETX0CHARISK),
    .PIPETX0COMPLIANCE (delay_PIPETX0COMPLIANCE),
    .PIPETX0DATA (delay_PIPETX0DATA),
    .PIPETX0ELECIDLE (delay_PIPETX0ELECIDLE),
    .PIPETX0POWERDOWN (delay_PIPETX0POWERDOWN),
    .PIPETX1CHARISK (delay_PIPETX1CHARISK),
    .PIPETX1COMPLIANCE (delay_PIPETX1COMPLIANCE),
    .PIPETX1DATA (delay_PIPETX1DATA),
    .PIPETX1ELECIDLE (delay_PIPETX1ELECIDLE),
    .PIPETX1POWERDOWN (delay_PIPETX1POWERDOWN),
    .PIPETX2CHARISK (delay_PIPETX2CHARISK),
    .PIPETX2COMPLIANCE (delay_PIPETX2COMPLIANCE),
    .PIPETX2DATA (delay_PIPETX2DATA),
    .PIPETX2ELECIDLE (delay_PIPETX2ELECIDLE),
    .PIPETX2POWERDOWN (delay_PIPETX2POWERDOWN),
    .PIPETX3CHARISK (delay_PIPETX3CHARISK),
    .PIPETX3COMPLIANCE (delay_PIPETX3COMPLIANCE),
    .PIPETX3DATA (delay_PIPETX3DATA),
    .PIPETX3ELECIDLE (delay_PIPETX3ELECIDLE),
    .PIPETX3POWERDOWN (delay_PIPETX3POWERDOWN),
    .PIPETX4CHARISK (delay_PIPETX4CHARISK),
    .PIPETX4COMPLIANCE (delay_PIPETX4COMPLIANCE),
    .PIPETX4DATA (delay_PIPETX4DATA),
    .PIPETX4ELECIDLE (delay_PIPETX4ELECIDLE),
    .PIPETX4POWERDOWN (delay_PIPETX4POWERDOWN),
    .PIPETX5CHARISK (delay_PIPETX5CHARISK),
    .PIPETX5COMPLIANCE (delay_PIPETX5COMPLIANCE),
    .PIPETX5DATA (delay_PIPETX5DATA),
    .PIPETX5ELECIDLE (delay_PIPETX5ELECIDLE),
    .PIPETX5POWERDOWN (delay_PIPETX5POWERDOWN),
    .PIPETX6CHARISK (delay_PIPETX6CHARISK),
    .PIPETX6COMPLIANCE (delay_PIPETX6COMPLIANCE),
    .PIPETX6DATA (delay_PIPETX6DATA),
    .PIPETX6ELECIDLE (delay_PIPETX6ELECIDLE),
    .PIPETX6POWERDOWN (delay_PIPETX6POWERDOWN),
    .PIPETX7CHARISK (delay_PIPETX7CHARISK),
    .PIPETX7COMPLIANCE (delay_PIPETX7COMPLIANCE),
    .PIPETX7DATA (delay_PIPETX7DATA),
    .PIPETX7ELECIDLE (delay_PIPETX7ELECIDLE),
    .PIPETX7POWERDOWN (delay_PIPETX7POWERDOWN),
    .PIPETXDEEMPH (delay_PIPETXDEEMPH),
    .PIPETXMARGIN (delay_PIPETXMARGIN),
    .PIPETXRATE (delay_PIPETXRATE),
    .PIPETXRCVRDET (delay_PIPETXRCVRDET),
    .PIPETXRESET (delay_PIPETXRESET),
    .PL2LINKUPN (delay_PL2LINKUPN),
    .PL2RECEIVERERRN (delay_PL2RECEIVERERRN),
    .PL2RECOVERYN (delay_PL2RECOVERYN),
    .PL2RXELECIDLE (delay_PL2RXELECIDLE),
    .PL2SUSPENDOK (delay_PL2SUSPENDOK),
    .PLDBGVEC (delay_PLDBGVEC),
    .PLINITIALLINKWIDTH (delay_PLINITIALLINKWIDTH),
    .PLLANEREVERSALMODE (delay_PLLANEREVERSALMODE),
    .PLLINKGEN2CAP (delay_PLLINKGEN2CAP),
    .PLLINKPARTNERGEN2SUPPORTED (delay_PLLINKPARTNERGEN2SUPPORTED),
    .PLLINKUPCFGCAP (delay_PLLINKUPCFGCAP),
    .PLLTSSMSTATE (delay_PLLTSSMSTATE),
    .PLPHYLNKUPN (delay_PLPHYLNKUPN),
    .PLRECEIVEDHOTRST (delay_PLRECEIVEDHOTRST),
    .PLRXPMSTATE (delay_PLRXPMSTATE),
    .PLSELLNKRATE (delay_PLSELLNKRATE),
    .PLSELLNKWIDTH (delay_PLSELLNKWIDTH),
    .PLTXPMSTATE (delay_PLTXPMSTATE),
    .RECEIVEDFUNCLVLRSTN (delay_RECEIVEDFUNCLVLRSTN),
    .TL2ASPMSUSPENDCREDITCHECKOKN (delay_TL2ASPMSUSPENDCREDITCHECKOKN),
    .TL2ASPMSUSPENDREQN (delay_TL2ASPMSUSPENDREQN),
    .TL2PPMSUSPENDOKN (delay_TL2PPMSUSPENDOKN),
    .TRNFCCPLD (delay_TRNFCCPLD),
    .TRNFCCPLH (delay_TRNFCCPLH),
    .TRNFCNPD (delay_TRNFCNPD),
    .TRNFCNPH (delay_TRNFCNPH),
    .TRNFCPD (delay_TRNFCPD),
    .TRNFCPH (delay_TRNFCPH),
    .TRNLNKUPN (delay_TRNLNKUPN),
    .TRNRBARHITN (delay_TRNRBARHITN),
    .TRNRD (delay_TRNRD),
    .TRNRDLLPDATA (delay_TRNRDLLPDATA),
    .TRNRDLLPSRCRDYN (delay_TRNRDLLPSRCRDYN),
    .TRNRECRCERRN (delay_TRNRECRCERRN),
    .TRNREOFN (delay_TRNREOFN),
    .TRNRERRFWDN (delay_TRNRERRFWDN),
    .TRNRREMN (delay_TRNRREMN),
    .TRNRSOFN (delay_TRNRSOFN),
    .TRNRSRCDSCN (delay_TRNRSRCDSCN),
    .TRNRSRCRDYN (delay_TRNRSRCRDYN),
    .TRNTBUFAV (delay_TRNTBUFAV),
    .TRNTCFGREQN (delay_TRNTCFGREQN),
    .TRNTDLLPDSTRDYN (delay_TRNTDLLPDSTRDYN),
    .TRNTDSTRDYN (delay_TRNTDSTRDYN),
    .TRNTERRDROPN (delay_TRNTERRDROPN),
    .USERRSTN (delay_USERRSTN),
    .CFGBYTEENN (delay_CFGBYTEENN),
    .CFGDI (delay_CFGDI),
    .CFGDSBUSNUMBER (delay_CFGDSBUSNUMBER),
    .CFGDSDEVICENUMBER (delay_CFGDSDEVICENUMBER),
    .CFGDSFUNCTIONNUMBER (delay_CFGDSFUNCTIONNUMBER),
    .CFGDSN (delay_CFGDSN),
    .CFGDWADDR (delay_CFGDWADDR),
    .CFGERRACSN (delay_CFGERRACSN),
    .CFGERRAERHEADERLOG (delay_CFGERRAERHEADERLOG),
    .CFGERRCORN (delay_CFGERRCORN),
    .CFGERRCPLABORTN (delay_CFGERRCPLABORTN),
    .CFGERRCPLTIMEOUTN (delay_CFGERRCPLTIMEOUTN),
    .CFGERRCPLUNEXPECTN (delay_CFGERRCPLUNEXPECTN),
    .CFGERRECRCN (delay_CFGERRECRCN),
    .CFGERRLOCKEDN (delay_CFGERRLOCKEDN),
    .CFGERRPOSTEDN (delay_CFGERRPOSTEDN),
    .CFGERRTLPCPLHEADER (delay_CFGERRTLPCPLHEADER),
    .CFGERRURN (delay_CFGERRURN),
    .CFGINTERRUPTASSERTN (delay_CFGINTERRUPTASSERTN),
    .CFGINTERRUPTDI (delay_CFGINTERRUPTDI),
    .CFGINTERRUPTN (delay_CFGINTERRUPTN),
    .CFGPMDIRECTASPML1N (delay_CFGPMDIRECTASPML1N),
    .CFGPMSENDPMACKN (delay_CFGPMSENDPMACKN),
    .CFGPMSENDPMETON (delay_CFGPMSENDPMETON),
    .CFGPMSENDPMNAKN (delay_CFGPMSENDPMNAKN),
    .CFGPMTURNOFFOKN (delay_CFGPMTURNOFFOKN),
    .CFGPMWAKEN (delay_CFGPMWAKEN),
    .CFGPORTNUMBER (delay_CFGPORTNUMBER),
    .CFGRDENN (delay_CFGRDENN),
    .CFGTRNPENDINGN (delay_CFGTRNPENDINGN),
    .CFGWRENN (delay_CFGWRENN),
    .CFGWRREADONLYN (delay_CFGWRREADONLYN),
    .CFGWRRW1CASRWN (delay_CFGWRRW1CASRWN),
    .CMRSTN (delay_CMRSTN),
    .CMSTICKYRSTN (delay_CMSTICKYRSTN),
    .DBGMODE (delay_DBGMODE),
    .DBGSUBMODE (delay_DBGSUBMODE),
    .DLRSTN (delay_DLRSTN),
    .DRPCLK (delay_DRPCLK),
    .DRPDADDR (delay_DRPDADDR),
    .DRPDEN (delay_DRPDEN),
    .DRPDI (delay_DRPDI),
    .DRPDWE (delay_DRPDWE),
    .FUNCLVLRSTN (delay_FUNCLVLRSTN),
    .LL2SENDASREQL1N (delay_LL2SENDASREQL1N),
    .LL2SENDENTERL1N (delay_LL2SENDENTERL1N),
    .LL2SENDENTERL23N (delay_LL2SENDENTERL23N),
    .LL2SUSPENDNOWN (delay_LL2SUSPENDNOWN),
    .LL2TLPRCVN (delay_LL2TLPRCVN),
    .MIMRXRDATA (delay_MIMRXRDATA),
    .MIMTXRDATA (delay_MIMTXRDATA),
    .PIPECLK (delay_PIPECLK),
    .PIPERX0CHANISALIGNED (delay_PIPERX0CHANISALIGNED),
    .PIPERX0CHARISK (delay_PIPERX0CHARISK),
    .PIPERX0DATA (delay_PIPERX0DATA),
    .PIPERX0ELECIDLE (delay_PIPERX0ELECIDLE),
    .PIPERX0PHYSTATUS (delay_PIPERX0PHYSTATUS),
    .PIPERX0STATUS (delay_PIPERX0STATUS),
    .PIPERX0VALID (delay_PIPERX0VALID),
    .PIPERX1CHANISALIGNED (delay_PIPERX1CHANISALIGNED),
    .PIPERX1CHARISK (delay_PIPERX1CHARISK),
    .PIPERX1DATA (delay_PIPERX1DATA),
    .PIPERX1ELECIDLE (delay_PIPERX1ELECIDLE),
    .PIPERX1PHYSTATUS (delay_PIPERX1PHYSTATUS),
    .PIPERX1STATUS (delay_PIPERX1STATUS),
    .PIPERX1VALID (delay_PIPERX1VALID),
    .PIPERX2CHANISALIGNED (delay_PIPERX2CHANISALIGNED),
    .PIPERX2CHARISK (delay_PIPERX2CHARISK),
    .PIPERX2DATA (delay_PIPERX2DATA),
    .PIPERX2ELECIDLE (delay_PIPERX2ELECIDLE),
    .PIPERX2PHYSTATUS (delay_PIPERX2PHYSTATUS),
    .PIPERX2STATUS (delay_PIPERX2STATUS),
    .PIPERX2VALID (delay_PIPERX2VALID),
    .PIPERX3CHANISALIGNED (delay_PIPERX3CHANISALIGNED),
    .PIPERX3CHARISK (delay_PIPERX3CHARISK),
    .PIPERX3DATA (delay_PIPERX3DATA),
    .PIPERX3ELECIDLE (delay_PIPERX3ELECIDLE),
    .PIPERX3PHYSTATUS (delay_PIPERX3PHYSTATUS),
    .PIPERX3STATUS (delay_PIPERX3STATUS),
    .PIPERX3VALID (delay_PIPERX3VALID),
    .PIPERX4CHANISALIGNED (delay_PIPERX4CHANISALIGNED),
    .PIPERX4CHARISK (delay_PIPERX4CHARISK),
    .PIPERX4DATA (delay_PIPERX4DATA),
    .PIPERX4ELECIDLE (delay_PIPERX4ELECIDLE),
    .PIPERX4PHYSTATUS (delay_PIPERX4PHYSTATUS),
    .PIPERX4STATUS (delay_PIPERX4STATUS),
    .PIPERX4VALID (delay_PIPERX4VALID),
    .PIPERX5CHANISALIGNED (delay_PIPERX5CHANISALIGNED),
    .PIPERX5CHARISK (delay_PIPERX5CHARISK),
    .PIPERX5DATA (delay_PIPERX5DATA),
    .PIPERX5ELECIDLE (delay_PIPERX5ELECIDLE),
    .PIPERX5PHYSTATUS (delay_PIPERX5PHYSTATUS),
    .PIPERX5STATUS (delay_PIPERX5STATUS),
    .PIPERX5VALID (delay_PIPERX5VALID),
    .PIPERX6CHANISALIGNED (delay_PIPERX6CHANISALIGNED),
    .PIPERX6CHARISK (delay_PIPERX6CHARISK),
    .PIPERX6DATA (delay_PIPERX6DATA),
    .PIPERX6ELECIDLE (delay_PIPERX6ELECIDLE),
    .PIPERX6PHYSTATUS (delay_PIPERX6PHYSTATUS),
    .PIPERX6STATUS (delay_PIPERX6STATUS),
    .PIPERX6VALID (delay_PIPERX6VALID),
    .PIPERX7CHANISALIGNED (delay_PIPERX7CHANISALIGNED),
    .PIPERX7CHARISK (delay_PIPERX7CHARISK),
    .PIPERX7DATA (delay_PIPERX7DATA),
    .PIPERX7ELECIDLE (delay_PIPERX7ELECIDLE),
    .PIPERX7PHYSTATUS (delay_PIPERX7PHYSTATUS),
    .PIPERX7STATUS (delay_PIPERX7STATUS),
    .PIPERX7VALID (delay_PIPERX7VALID),
    .PL2DIRECTEDLSTATE (delay_PL2DIRECTEDLSTATE),
    .PLDBGMODE (delay_PLDBGMODE),
    .PLDIRECTEDLINKAUTON (delay_PLDIRECTEDLINKAUTON),
    .PLDIRECTEDLINKCHANGE (delay_PLDIRECTEDLINKCHANGE),
    .PLDIRECTEDLINKSPEED (delay_PLDIRECTEDLINKSPEED),
    .PLDIRECTEDLINKWIDTH (delay_PLDIRECTEDLINKWIDTH),
    .PLDOWNSTREAMDEEMPHSOURCE (delay_PLDOWNSTREAMDEEMPHSOURCE),
    .PLRSTN (delay_PLRSTN),
    .PLTRANSMITHOTRST (delay_PLTRANSMITHOTRST),
    .PLUPSTREAMPREFERDEEMPH (delay_PLUPSTREAMPREFERDEEMPH),
    .SYSRSTN (delay_SYSRSTN),
    .TL2ASPMSUSPENDCREDITCHECKN (delay_TL2ASPMSUSPENDCREDITCHECKN),
    .TL2PPMSUSPENDREQN (delay_TL2PPMSUSPENDREQN),
    .TLRSTN (delay_TLRSTN),
    .TRNFCSEL (delay_TRNFCSEL),
    .TRNRDSTRDYN (delay_TRNRDSTRDYN),
    .TRNRNPOKN (delay_TRNRNPOKN),
    .TRNTCFGGNTN (delay_TRNTCFGGNTN),
    .TRNTD (delay_TRNTD),
    .TRNTDLLPDATA (delay_TRNTDLLPDATA),
    .TRNTDLLPSRCRDYN (delay_TRNTDLLPSRCRDYN),
    .TRNTECRCGENN (delay_TRNTECRCGENN),
    .TRNTEOFN (delay_TRNTEOFN),
    .TRNTERRFWDN (delay_TRNTERRFWDN),
    .TRNTREMN (delay_TRNTREMN),
    .TRNTSOFN (delay_TRNTSOFN),
    .TRNTSRCDSCN (delay_TRNTSRCDSCN),
    .TRNTSRCRDYN (delay_TRNTSRCRDYN),
    .TRNTSTRN (delay_TRNTSTRN),
    .USERCLK (delay_USERCLK),
    .GSR(GSR)
 );

  specify
    ( DRPCLK => DRPDO[0]) = (0, 0);
    ( DRPCLK => DRPDO[10]) = (0, 0);
    ( DRPCLK => DRPDO[11]) = (0, 0);
    ( DRPCLK => DRPDO[12]) = (0, 0);
    ( DRPCLK => DRPDO[13]) = (0, 0);
    ( DRPCLK => DRPDO[14]) = (0, 0);
    ( DRPCLK => DRPDO[15]) = (0, 0);
    ( DRPCLK => DRPDO[1]) = (0, 0);
    ( DRPCLK => DRPDO[2]) = (0, 0);
    ( DRPCLK => DRPDO[3]) = (0, 0);
    ( DRPCLK => DRPDO[4]) = (0, 0);
    ( DRPCLK => DRPDO[5]) = (0, 0);
    ( DRPCLK => DRPDO[6]) = (0, 0);
    ( DRPCLK => DRPDO[7]) = (0, 0);
    ( DRPCLK => DRPDO[8]) = (0, 0);
    ( DRPCLK => DRPDO[9]) = (0, 0);
    ( DRPCLK => DRPDRDY) = (0, 0);
    ( PIPECLK => PIPERX0POLARITY) = (0, 0);
    ( PIPECLK => PIPERX1POLARITY) = (0, 0);
    ( PIPECLK => PIPERX2POLARITY) = (0, 0);
    ( PIPECLK => PIPERX3POLARITY) = (0, 0);
    ( PIPECLK => PIPERX4POLARITY) = (0, 0);
    ( PIPECLK => PIPERX5POLARITY) = (0, 0);
    ( PIPECLK => PIPERX6POLARITY) = (0, 0);
    ( PIPECLK => PIPERX7POLARITY) = (0, 0);
    ( PIPECLK => PIPETX0CHARISK[0]) = (0, 0);
    ( PIPECLK => PIPETX0CHARISK[1]) = (0, 0);
    ( PIPECLK => PIPETX0COMPLIANCE) = (0, 0);
    ( PIPECLK => PIPETX0DATA[0]) = (0, 0);
    ( PIPECLK => PIPETX0DATA[10]) = (0, 0);
    ( PIPECLK => PIPETX0DATA[11]) = (0, 0);
    ( PIPECLK => PIPETX0DATA[12]) = (0, 0);
    ( PIPECLK => PIPETX0DATA[13]) = (0, 0);
    ( PIPECLK => PIPETX0DATA[14]) = (0, 0);
    ( PIPECLK => PIPETX0DATA[15]) = (0, 0);
    ( PIPECLK => PIPETX0DATA[1]) = (0, 0);
    ( PIPECLK => PIPETX0DATA[2]) = (0, 0);
    ( PIPECLK => PIPETX0DATA[3]) = (0, 0);
    ( PIPECLK => PIPETX0DATA[4]) = (0, 0);
    ( PIPECLK => PIPETX0DATA[5]) = (0, 0);
    ( PIPECLK => PIPETX0DATA[6]) = (0, 0);
    ( PIPECLK => PIPETX0DATA[7]) = (0, 0);
    ( PIPECLK => PIPETX0DATA[8]) = (0, 0);
    ( PIPECLK => PIPETX0DATA[9]) = (0, 0);
    ( PIPECLK => PIPETX0ELECIDLE) = (0, 0);
    ( PIPECLK => PIPETX0POWERDOWN[0]) = (0, 0);
    ( PIPECLK => PIPETX0POWERDOWN[1]) = (0, 0);
    ( PIPECLK => PIPETX1CHARISK[0]) = (0, 0);
    ( PIPECLK => PIPETX1CHARISK[1]) = (0, 0);
    ( PIPECLK => PIPETX1COMPLIANCE) = (0, 0);
    ( PIPECLK => PIPETX1DATA[0]) = (0, 0);
    ( PIPECLK => PIPETX1DATA[10]) = (0, 0);
    ( PIPECLK => PIPETX1DATA[11]) = (0, 0);
    ( PIPECLK => PIPETX1DATA[12]) = (0, 0);
    ( PIPECLK => PIPETX1DATA[13]) = (0, 0);
    ( PIPECLK => PIPETX1DATA[14]) = (0, 0);
    ( PIPECLK => PIPETX1DATA[15]) = (0, 0);
    ( PIPECLK => PIPETX1DATA[1]) = (0, 0);
    ( PIPECLK => PIPETX1DATA[2]) = (0, 0);
    ( PIPECLK => PIPETX1DATA[3]) = (0, 0);
    ( PIPECLK => PIPETX1DATA[4]) = (0, 0);
    ( PIPECLK => PIPETX1DATA[5]) = (0, 0);
    ( PIPECLK => PIPETX1DATA[6]) = (0, 0);
    ( PIPECLK => PIPETX1DATA[7]) = (0, 0);
    ( PIPECLK => PIPETX1DATA[8]) = (0, 0);
    ( PIPECLK => PIPETX1DATA[9]) = (0, 0);
    ( PIPECLK => PIPETX1ELECIDLE) = (0, 0);
    ( PIPECLK => PIPETX1POWERDOWN[0]) = (0, 0);
    ( PIPECLK => PIPETX1POWERDOWN[1]) = (0, 0);
    ( PIPECLK => PIPETX2CHARISK[0]) = (0, 0);
    ( PIPECLK => PIPETX2CHARISK[1]) = (0, 0);
    ( PIPECLK => PIPETX2COMPLIANCE) = (0, 0);
    ( PIPECLK => PIPETX2DATA[0]) = (0, 0);
    ( PIPECLK => PIPETX2DATA[10]) = (0, 0);
    ( PIPECLK => PIPETX2DATA[11]) = (0, 0);
    ( PIPECLK => PIPETX2DATA[12]) = (0, 0);
    ( PIPECLK => PIPETX2DATA[13]) = (0, 0);
    ( PIPECLK => PIPETX2DATA[14]) = (0, 0);
    ( PIPECLK => PIPETX2DATA[15]) = (0, 0);
    ( PIPECLK => PIPETX2DATA[1]) = (0, 0);
    ( PIPECLK => PIPETX2DATA[2]) = (0, 0);
    ( PIPECLK => PIPETX2DATA[3]) = (0, 0);
    ( PIPECLK => PIPETX2DATA[4]) = (0, 0);
    ( PIPECLK => PIPETX2DATA[5]) = (0, 0);
    ( PIPECLK => PIPETX2DATA[6]) = (0, 0);
    ( PIPECLK => PIPETX2DATA[7]) = (0, 0);
    ( PIPECLK => PIPETX2DATA[8]) = (0, 0);
    ( PIPECLK => PIPETX2DATA[9]) = (0, 0);
    ( PIPECLK => PIPETX2ELECIDLE) = (0, 0);
    ( PIPECLK => PIPETX2POWERDOWN[0]) = (0, 0);
    ( PIPECLK => PIPETX2POWERDOWN[1]) = (0, 0);
    ( PIPECLK => PIPETX3CHARISK[0]) = (0, 0);
    ( PIPECLK => PIPETX3CHARISK[1]) = (0, 0);
    ( PIPECLK => PIPETX3COMPLIANCE) = (0, 0);
    ( PIPECLK => PIPETX3DATA[0]) = (0, 0);
    ( PIPECLK => PIPETX3DATA[10]) = (0, 0);
    ( PIPECLK => PIPETX3DATA[11]) = (0, 0);
    ( PIPECLK => PIPETX3DATA[12]) = (0, 0);
    ( PIPECLK => PIPETX3DATA[13]) = (0, 0);
    ( PIPECLK => PIPETX3DATA[14]) = (0, 0);
    ( PIPECLK => PIPETX3DATA[15]) = (0, 0);
    ( PIPECLK => PIPETX3DATA[1]) = (0, 0);
    ( PIPECLK => PIPETX3DATA[2]) = (0, 0);
    ( PIPECLK => PIPETX3DATA[3]) = (0, 0);
    ( PIPECLK => PIPETX3DATA[4]) = (0, 0);
    ( PIPECLK => PIPETX3DATA[5]) = (0, 0);
    ( PIPECLK => PIPETX3DATA[6]) = (0, 0);
    ( PIPECLK => PIPETX3DATA[7]) = (0, 0);
    ( PIPECLK => PIPETX3DATA[8]) = (0, 0);
    ( PIPECLK => PIPETX3DATA[9]) = (0, 0);
    ( PIPECLK => PIPETX3ELECIDLE) = (0, 0);
    ( PIPECLK => PIPETX3POWERDOWN[0]) = (0, 0);
    ( PIPECLK => PIPETX3POWERDOWN[1]) = (0, 0);
    ( PIPECLK => PIPETX4CHARISK[0]) = (0, 0);
    ( PIPECLK => PIPETX4CHARISK[1]) = (0, 0);
    ( PIPECLK => PIPETX4COMPLIANCE) = (0, 0);
    ( PIPECLK => PIPETX4DATA[0]) = (0, 0);
    ( PIPECLK => PIPETX4DATA[10]) = (0, 0);
    ( PIPECLK => PIPETX4DATA[11]) = (0, 0);
    ( PIPECLK => PIPETX4DATA[12]) = (0, 0);
    ( PIPECLK => PIPETX4DATA[13]) = (0, 0);
    ( PIPECLK => PIPETX4DATA[14]) = (0, 0);
    ( PIPECLK => PIPETX4DATA[15]) = (0, 0);
    ( PIPECLK => PIPETX4DATA[1]) = (0, 0);
    ( PIPECLK => PIPETX4DATA[2]) = (0, 0);
    ( PIPECLK => PIPETX4DATA[3]) = (0, 0);
    ( PIPECLK => PIPETX4DATA[4]) = (0, 0);
    ( PIPECLK => PIPETX4DATA[5]) = (0, 0);
    ( PIPECLK => PIPETX4DATA[6]) = (0, 0);
    ( PIPECLK => PIPETX4DATA[7]) = (0, 0);
    ( PIPECLK => PIPETX4DATA[8]) = (0, 0);
    ( PIPECLK => PIPETX4DATA[9]) = (0, 0);
    ( PIPECLK => PIPETX4ELECIDLE) = (0, 0);
    ( PIPECLK => PIPETX4POWERDOWN[0]) = (0, 0);
    ( PIPECLK => PIPETX4POWERDOWN[1]) = (0, 0);
    ( PIPECLK => PIPETX5CHARISK[0]) = (0, 0);
    ( PIPECLK => PIPETX5CHARISK[1]) = (0, 0);
    ( PIPECLK => PIPETX5COMPLIANCE) = (0, 0);
    ( PIPECLK => PIPETX5DATA[0]) = (0, 0);
    ( PIPECLK => PIPETX5DATA[10]) = (0, 0);
    ( PIPECLK => PIPETX5DATA[11]) = (0, 0);
    ( PIPECLK => PIPETX5DATA[12]) = (0, 0);
    ( PIPECLK => PIPETX5DATA[13]) = (0, 0);
    ( PIPECLK => PIPETX5DATA[14]) = (0, 0);
    ( PIPECLK => PIPETX5DATA[15]) = (0, 0);
    ( PIPECLK => PIPETX5DATA[1]) = (0, 0);
    ( PIPECLK => PIPETX5DATA[2]) = (0, 0);
    ( PIPECLK => PIPETX5DATA[3]) = (0, 0);
    ( PIPECLK => PIPETX5DATA[4]) = (0, 0);
    ( PIPECLK => PIPETX5DATA[5]) = (0, 0);
    ( PIPECLK => PIPETX5DATA[6]) = (0, 0);
    ( PIPECLK => PIPETX5DATA[7]) = (0, 0);
    ( PIPECLK => PIPETX5DATA[8]) = (0, 0);
    ( PIPECLK => PIPETX5DATA[9]) = (0, 0);
    ( PIPECLK => PIPETX5ELECIDLE) = (0, 0);
    ( PIPECLK => PIPETX5POWERDOWN[0]) = (0, 0);
    ( PIPECLK => PIPETX5POWERDOWN[1]) = (0, 0);
    ( PIPECLK => PIPETX6CHARISK[0]) = (0, 0);
    ( PIPECLK => PIPETX6CHARISK[1]) = (0, 0);
    ( PIPECLK => PIPETX6COMPLIANCE) = (0, 0);
    ( PIPECLK => PIPETX6DATA[0]) = (0, 0);
    ( PIPECLK => PIPETX6DATA[10]) = (0, 0);
    ( PIPECLK => PIPETX6DATA[11]) = (0, 0);
    ( PIPECLK => PIPETX6DATA[12]) = (0, 0);
    ( PIPECLK => PIPETX6DATA[13]) = (0, 0);
    ( PIPECLK => PIPETX6DATA[14]) = (0, 0);
    ( PIPECLK => PIPETX6DATA[15]) = (0, 0);
    ( PIPECLK => PIPETX6DATA[1]) = (0, 0);
    ( PIPECLK => PIPETX6DATA[2]) = (0, 0);
    ( PIPECLK => PIPETX6DATA[3]) = (0, 0);
    ( PIPECLK => PIPETX6DATA[4]) = (0, 0);
    ( PIPECLK => PIPETX6DATA[5]) = (0, 0);
    ( PIPECLK => PIPETX6DATA[6]) = (0, 0);
    ( PIPECLK => PIPETX6DATA[7]) = (0, 0);
    ( PIPECLK => PIPETX6DATA[8]) = (0, 0);
    ( PIPECLK => PIPETX6DATA[9]) = (0, 0);
    ( PIPECLK => PIPETX6ELECIDLE) = (0, 0);
    ( PIPECLK => PIPETX6POWERDOWN[0]) = (0, 0);
    ( PIPECLK => PIPETX6POWERDOWN[1]) = (0, 0);
    ( PIPECLK => PIPETX7CHARISK[0]) = (0, 0);
    ( PIPECLK => PIPETX7CHARISK[1]) = (0, 0);
    ( PIPECLK => PIPETX7COMPLIANCE) = (0, 0);
    ( PIPECLK => PIPETX7DATA[0]) = (0, 0);
    ( PIPECLK => PIPETX7DATA[10]) = (0, 0);
    ( PIPECLK => PIPETX7DATA[11]) = (0, 0);
    ( PIPECLK => PIPETX7DATA[12]) = (0, 0);
    ( PIPECLK => PIPETX7DATA[13]) = (0, 0);
    ( PIPECLK => PIPETX7DATA[14]) = (0, 0);
    ( PIPECLK => PIPETX7DATA[15]) = (0, 0);
    ( PIPECLK => PIPETX7DATA[1]) = (0, 0);
    ( PIPECLK => PIPETX7DATA[2]) = (0, 0);
    ( PIPECLK => PIPETX7DATA[3]) = (0, 0);
    ( PIPECLK => PIPETX7DATA[4]) = (0, 0);
    ( PIPECLK => PIPETX7DATA[5]) = (0, 0);
    ( PIPECLK => PIPETX7DATA[6]) = (0, 0);
    ( PIPECLK => PIPETX7DATA[7]) = (0, 0);
    ( PIPECLK => PIPETX7DATA[8]) = (0, 0);
    ( PIPECLK => PIPETX7DATA[9]) = (0, 0);
    ( PIPECLK => PIPETX7ELECIDLE) = (0, 0);
    ( PIPECLK => PIPETX7POWERDOWN[0]) = (0, 0);
    ( PIPECLK => PIPETX7POWERDOWN[1]) = (0, 0);
    ( PIPECLK => PIPETXDEEMPH) = (0, 0);
    ( PIPECLK => PIPETXMARGIN[0]) = (0, 0);
    ( PIPECLK => PIPETXMARGIN[1]) = (0, 0);
    ( PIPECLK => PIPETXMARGIN[2]) = (0, 0);
    ( PIPECLK => PIPETXRATE) = (0, 0);
    ( PIPECLK => PIPETXRCVRDET) = (0, 0);
    ( PIPECLK => PIPETXRESET) = (0, 0);
    ( PIPECLK => PLDBGVEC[0]) = (0, 0);
    ( PIPECLK => PLDBGVEC[10]) = (0, 0);
    ( PIPECLK => PLDBGVEC[11]) = (0, 0);
    ( PIPECLK => PLDBGVEC[1]) = (0, 0);
    ( PIPECLK => PLDBGVEC[2]) = (0, 0);
    ( PIPECLK => PLDBGVEC[3]) = (0, 0);
    ( PIPECLK => PLDBGVEC[4]) = (0, 0);
    ( PIPECLK => PLDBGVEC[5]) = (0, 0);
    ( PIPECLK => PLDBGVEC[6]) = (0, 0);
    ( PIPECLK => PLDBGVEC[7]) = (0, 0);
    ( PIPECLK => PLDBGVEC[8]) = (0, 0);
    ( PIPECLK => PLDBGVEC[9]) = (0, 0);
    ( PIPECLK => PLINITIALLINKWIDTH[0]) = (0, 0);
    ( PIPECLK => PLINITIALLINKWIDTH[1]) = (0, 0);
    ( PIPECLK => PLINITIALLINKWIDTH[2]) = (0, 0);
    ( PIPECLK => PLLANEREVERSALMODE[0]) = (0, 0);
    ( PIPECLK => PLLANEREVERSALMODE[1]) = (0, 0);
    ( PIPECLK => PLLINKGEN2CAP) = (0, 0);
    ( PIPECLK => PLLINKPARTNERGEN2SUPPORTED) = (0, 0);
    ( PIPECLK => PLLINKUPCFGCAP) = (0, 0);
    ( PIPECLK => PLLTSSMSTATE[0]) = (0, 0);
    ( PIPECLK => PLLTSSMSTATE[1]) = (0, 0);
    ( PIPECLK => PLLTSSMSTATE[2]) = (0, 0);
    ( PIPECLK => PLLTSSMSTATE[3]) = (0, 0);
    ( PIPECLK => PLLTSSMSTATE[4]) = (0, 0);
    ( PIPECLK => PLLTSSMSTATE[5]) = (0, 0);
    ( PIPECLK => PLPHYLNKUPN) = (0, 0);
    ( PIPECLK => PLRECEIVEDHOTRST) = (0, 0);
    ( PIPECLK => PLRXPMSTATE[0]) = (0, 0);
    ( PIPECLK => PLRXPMSTATE[1]) = (0, 0);
    ( PIPECLK => PLSELLNKRATE) = (0, 0);
    ( PIPECLK => PLSELLNKWIDTH[0]) = (0, 0);
    ( PIPECLK => PLSELLNKWIDTH[1]) = (0, 0);
    ( PIPECLK => PLTXPMSTATE[0]) = (0, 0);
    ( PIPECLK => PLTXPMSTATE[1]) = (0, 0);
    ( PIPECLK => PLTXPMSTATE[2]) = (0, 0);
    ( USERCLK => CFGAERECRCCHECKEN) = (0, 0);
    ( USERCLK => CFGAERECRCGENEN) = (0, 0);
    ( USERCLK => CFGCOMMANDBUSMASTERENABLE) = (0, 0);
    ( USERCLK => CFGCOMMANDINTERRUPTDISABLE) = (0, 0);
    ( USERCLK => CFGCOMMANDIOENABLE) = (0, 0);
    ( USERCLK => CFGCOMMANDMEMENABLE) = (0, 0);
    ( USERCLK => CFGCOMMANDSERREN) = (0, 0);
    ( USERCLK => CFGDEVCONTROL2CPLTIMEOUTDIS) = (0, 0);
    ( USERCLK => CFGDEVCONTROL2CPLTIMEOUTVAL[0]) = (0, 0);
    ( USERCLK => CFGDEVCONTROL2CPLTIMEOUTVAL[1]) = (0, 0);
    ( USERCLK => CFGDEVCONTROL2CPLTIMEOUTVAL[2]) = (0, 0);
    ( USERCLK => CFGDEVCONTROL2CPLTIMEOUTVAL[3]) = (0, 0);
    ( USERCLK => CFGDEVCONTROLAUXPOWEREN) = (0, 0);
    ( USERCLK => CFGDEVCONTROLCORRERRREPORTINGEN) = (0, 0);
    ( USERCLK => CFGDEVCONTROLENABLERO) = (0, 0);
    ( USERCLK => CFGDEVCONTROLEXTTAGEN) = (0, 0);
    ( USERCLK => CFGDEVCONTROLFATALERRREPORTINGEN) = (0, 0);
    ( USERCLK => CFGDEVCONTROLMAXPAYLOAD[0]) = (0, 0);
    ( USERCLK => CFGDEVCONTROLMAXPAYLOAD[1]) = (0, 0);
    ( USERCLK => CFGDEVCONTROLMAXPAYLOAD[2]) = (0, 0);
    ( USERCLK => CFGDEVCONTROLMAXREADREQ[0]) = (0, 0);
    ( USERCLK => CFGDEVCONTROLMAXREADREQ[1]) = (0, 0);
    ( USERCLK => CFGDEVCONTROLMAXREADREQ[2]) = (0, 0);
    ( USERCLK => CFGDEVCONTROLNONFATALREPORTINGEN) = (0, 0);
    ( USERCLK => CFGDEVCONTROLNOSNOOPEN) = (0, 0);
    ( USERCLK => CFGDEVCONTROLPHANTOMEN) = (0, 0);
    ( USERCLK => CFGDEVCONTROLURERRREPORTINGEN) = (0, 0);
    ( USERCLK => CFGDEVSTATUSCORRERRDETECTED) = (0, 0);
    ( USERCLK => CFGDEVSTATUSFATALERRDETECTED) = (0, 0);
    ( USERCLK => CFGDEVSTATUSNONFATALERRDETECTED) = (0, 0);
    ( USERCLK => CFGDEVSTATUSURDETECTED) = (0, 0);
    ( USERCLK => CFGDO[0]) = (0, 0);
    ( USERCLK => CFGDO[10]) = (0, 0);
    ( USERCLK => CFGDO[11]) = (0, 0);
    ( USERCLK => CFGDO[12]) = (0, 0);
    ( USERCLK => CFGDO[13]) = (0, 0);
    ( USERCLK => CFGDO[14]) = (0, 0);
    ( USERCLK => CFGDO[15]) = (0, 0);
    ( USERCLK => CFGDO[16]) = (0, 0);
    ( USERCLK => CFGDO[17]) = (0, 0);
    ( USERCLK => CFGDO[18]) = (0, 0);
    ( USERCLK => CFGDO[19]) = (0, 0);
    ( USERCLK => CFGDO[1]) = (0, 0);
    ( USERCLK => CFGDO[20]) = (0, 0);
    ( USERCLK => CFGDO[21]) = (0, 0);
    ( USERCLK => CFGDO[22]) = (0, 0);
    ( USERCLK => CFGDO[23]) = (0, 0);
    ( USERCLK => CFGDO[24]) = (0, 0);
    ( USERCLK => CFGDO[25]) = (0, 0);
    ( USERCLK => CFGDO[26]) = (0, 0);
    ( USERCLK => CFGDO[27]) = (0, 0);
    ( USERCLK => CFGDO[28]) = (0, 0);
    ( USERCLK => CFGDO[29]) = (0, 0);
    ( USERCLK => CFGDO[2]) = (0, 0);
    ( USERCLK => CFGDO[30]) = (0, 0);
    ( USERCLK => CFGDO[31]) = (0, 0);
    ( USERCLK => CFGDO[3]) = (0, 0);
    ( USERCLK => CFGDO[4]) = (0, 0);
    ( USERCLK => CFGDO[5]) = (0, 0);
    ( USERCLK => CFGDO[6]) = (0, 0);
    ( USERCLK => CFGDO[7]) = (0, 0);
    ( USERCLK => CFGDO[8]) = (0, 0);
    ( USERCLK => CFGDO[9]) = (0, 0);
    ( USERCLK => CFGERRAERHEADERLOGSETN) = (0, 0);
    ( USERCLK => CFGERRCPLRDYN) = (0, 0);
    ( USERCLK => CFGINTERRUPTDO[0]) = (0, 0);
    ( USERCLK => CFGINTERRUPTDO[1]) = (0, 0);
    ( USERCLK => CFGINTERRUPTDO[2]) = (0, 0);
    ( USERCLK => CFGINTERRUPTDO[3]) = (0, 0);
    ( USERCLK => CFGINTERRUPTDO[4]) = (0, 0);
    ( USERCLK => CFGINTERRUPTDO[5]) = (0, 0);
    ( USERCLK => CFGINTERRUPTDO[6]) = (0, 0);
    ( USERCLK => CFGINTERRUPTDO[7]) = (0, 0);
    ( USERCLK => CFGINTERRUPTMMENABLE[0]) = (0, 0);
    ( USERCLK => CFGINTERRUPTMMENABLE[1]) = (0, 0);
    ( USERCLK => CFGINTERRUPTMMENABLE[2]) = (0, 0);
    ( USERCLK => CFGINTERRUPTMSIENABLE) = (0, 0);
    ( USERCLK => CFGINTERRUPTMSIXENABLE) = (0, 0);
    ( USERCLK => CFGINTERRUPTMSIXFM) = (0, 0);
    ( USERCLK => CFGINTERRUPTRDYN) = (0, 0);
    ( USERCLK => CFGLINKCONTROLASPMCONTROL[0]) = (0, 0);
    ( USERCLK => CFGLINKCONTROLASPMCONTROL[1]) = (0, 0);
    ( USERCLK => CFGLINKCONTROLAUTOBANDWIDTHINTEN) = (0, 0);
    ( USERCLK => CFGLINKCONTROLBANDWIDTHINTEN) = (0, 0);
    ( USERCLK => CFGLINKCONTROLCLOCKPMEN) = (0, 0);
    ( USERCLK => CFGLINKCONTROLCOMMONCLOCK) = (0, 0);
    ( USERCLK => CFGLINKCONTROLEXTENDEDSYNC) = (0, 0);
    ( USERCLK => CFGLINKCONTROLHWAUTOWIDTHDIS) = (0, 0);
    ( USERCLK => CFGLINKCONTROLLINKDISABLE) = (0, 0);
    ( USERCLK => CFGLINKCONTROLRCB) = (0, 0);
    ( USERCLK => CFGLINKCONTROLRETRAINLINK) = (0, 0);
    ( USERCLK => CFGLINKSTATUSAUTOBANDWIDTHSTATUS) = (0, 0);
    ( USERCLK => CFGLINKSTATUSBANDWITHSTATUS) = (0, 0);
    ( USERCLK => CFGLINKSTATUSCURRENTSPEED[0]) = (0, 0);
    ( USERCLK => CFGLINKSTATUSCURRENTSPEED[1]) = (0, 0);
    ( USERCLK => CFGLINKSTATUSDLLACTIVE) = (0, 0);
    ( USERCLK => CFGLINKSTATUSLINKTRAINING) = (0, 0);
    ( USERCLK => CFGLINKSTATUSNEGOTIATEDWIDTH[0]) = (0, 0);
    ( USERCLK => CFGLINKSTATUSNEGOTIATEDWIDTH[1]) = (0, 0);
    ( USERCLK => CFGLINKSTATUSNEGOTIATEDWIDTH[2]) = (0, 0);
    ( USERCLK => CFGLINKSTATUSNEGOTIATEDWIDTH[3]) = (0, 0);
    ( USERCLK => CFGMSGDATA[0]) = (0, 0);
    ( USERCLK => CFGMSGDATA[10]) = (0, 0);
    ( USERCLK => CFGMSGDATA[11]) = (0, 0);
    ( USERCLK => CFGMSGDATA[12]) = (0, 0);
    ( USERCLK => CFGMSGDATA[13]) = (0, 0);
    ( USERCLK => CFGMSGDATA[14]) = (0, 0);
    ( USERCLK => CFGMSGDATA[15]) = (0, 0);
    ( USERCLK => CFGMSGDATA[1]) = (0, 0);
    ( USERCLK => CFGMSGDATA[2]) = (0, 0);
    ( USERCLK => CFGMSGDATA[3]) = (0, 0);
    ( USERCLK => CFGMSGDATA[4]) = (0, 0);
    ( USERCLK => CFGMSGDATA[5]) = (0, 0);
    ( USERCLK => CFGMSGDATA[6]) = (0, 0);
    ( USERCLK => CFGMSGDATA[7]) = (0, 0);
    ( USERCLK => CFGMSGDATA[8]) = (0, 0);
    ( USERCLK => CFGMSGDATA[9]) = (0, 0);
    ( USERCLK => CFGMSGRECEIVED) = (0, 0);
    ( USERCLK => CFGMSGRECEIVEDASSERTINTA) = (0, 0);
    ( USERCLK => CFGMSGRECEIVEDASSERTINTB) = (0, 0);
    ( USERCLK => CFGMSGRECEIVEDASSERTINTC) = (0, 0);
    ( USERCLK => CFGMSGRECEIVEDASSERTINTD) = (0, 0);
    ( USERCLK => CFGMSGRECEIVEDDEASSERTINTA) = (0, 0);
    ( USERCLK => CFGMSGRECEIVEDDEASSERTINTB) = (0, 0);
    ( USERCLK => CFGMSGRECEIVEDDEASSERTINTC) = (0, 0);
    ( USERCLK => CFGMSGRECEIVEDDEASSERTINTD) = (0, 0);
    ( USERCLK => CFGMSGRECEIVEDERRCOR) = (0, 0);
    ( USERCLK => CFGMSGRECEIVEDERRFATAL) = (0, 0);
    ( USERCLK => CFGMSGRECEIVEDERRNONFATAL) = (0, 0);
    ( USERCLK => CFGMSGRECEIVEDPMASNAK) = (0, 0);
    ( USERCLK => CFGMSGRECEIVEDPMETO) = (0, 0);
    ( USERCLK => CFGMSGRECEIVEDPMETOACK) = (0, 0);
    ( USERCLK => CFGMSGRECEIVEDPMPME) = (0, 0);
    ( USERCLK => CFGMSGRECEIVEDSETSLOTPOWERLIMIT) = (0, 0);
    ( USERCLK => CFGMSGRECEIVEDUNLOCK) = (0, 0);
    ( USERCLK => CFGPCIELINKSTATE[0]) = (0, 0);
    ( USERCLK => CFGPCIELINKSTATE[1]) = (0, 0);
    ( USERCLK => CFGPCIELINKSTATE[2]) = (0, 0);
    ( USERCLK => CFGPMCSRPMEEN) = (0, 0);
    ( USERCLK => CFGPMCSRPMESTATUS) = (0, 0);
    ( USERCLK => CFGPMCSRPOWERSTATE[0]) = (0, 0);
    ( USERCLK => CFGPMCSRPOWERSTATE[1]) = (0, 0);
    ( USERCLK => CFGPMRCVASREQL1N) = (0, 0);
    ( USERCLK => CFGPMRCVENTERL1N) = (0, 0);
    ( USERCLK => CFGPMRCVENTERL23N) = (0, 0);
    ( USERCLK => CFGPMRCVREQACKN) = (0, 0);
    ( USERCLK => CFGRDWRDONEN) = (0, 0);
    ( USERCLK => CFGSLOTCONTROLELECTROMECHILCTLPULSE) = (0, 0);
    ( USERCLK => CFGTRANSACTION) = (0, 0);
    ( USERCLK => CFGTRANSACTIONADDR[0]) = (0, 0);
    ( USERCLK => CFGTRANSACTIONADDR[1]) = (0, 0);
    ( USERCLK => CFGTRANSACTIONADDR[2]) = (0, 0);
    ( USERCLK => CFGTRANSACTIONADDR[3]) = (0, 0);
    ( USERCLK => CFGTRANSACTIONADDR[4]) = (0, 0);
    ( USERCLK => CFGTRANSACTIONADDR[5]) = (0, 0);
    ( USERCLK => CFGTRANSACTIONADDR[6]) = (0, 0);
    ( USERCLK => CFGTRANSACTIONTYPE) = (0, 0);
    ( USERCLK => CFGVCTCVCMAP[0]) = (0, 0);
    ( USERCLK => CFGVCTCVCMAP[1]) = (0, 0);
    ( USERCLK => CFGVCTCVCMAP[2]) = (0, 0);
    ( USERCLK => CFGVCTCVCMAP[3]) = (0, 0);
    ( USERCLK => CFGVCTCVCMAP[4]) = (0, 0);
    ( USERCLK => CFGVCTCVCMAP[5]) = (0, 0);
    ( USERCLK => CFGVCTCVCMAP[6]) = (0, 0);
    ( USERCLK => DBGSCLRA) = (0, 0);
    ( USERCLK => DBGSCLRB) = (0, 0);
    ( USERCLK => DBGSCLRC) = (0, 0);
    ( USERCLK => DBGSCLRD) = (0, 0);
    ( USERCLK => DBGSCLRE) = (0, 0);
    ( USERCLK => DBGSCLRF) = (0, 0);
    ( USERCLK => DBGSCLRG) = (0, 0);
    ( USERCLK => DBGSCLRH) = (0, 0);
    ( USERCLK => DBGSCLRI) = (0, 0);
    ( USERCLK => DBGSCLRJ) = (0, 0);
    ( USERCLK => DBGSCLRK) = (0, 0);
    ( USERCLK => DBGVECA[0]) = (0, 0);
    ( USERCLK => DBGVECA[10]) = (0, 0);
    ( USERCLK => DBGVECA[11]) = (0, 0);
    ( USERCLK => DBGVECA[12]) = (0, 0);
    ( USERCLK => DBGVECA[13]) = (0, 0);
    ( USERCLK => DBGVECA[14]) = (0, 0);
    ( USERCLK => DBGVECA[15]) = (0, 0);
    ( USERCLK => DBGVECA[16]) = (0, 0);
    ( USERCLK => DBGVECA[17]) = (0, 0);
    ( USERCLK => DBGVECA[18]) = (0, 0);
    ( USERCLK => DBGVECA[19]) = (0, 0);
    ( USERCLK => DBGVECA[1]) = (0, 0);
    ( USERCLK => DBGVECA[20]) = (0, 0);
    ( USERCLK => DBGVECA[21]) = (0, 0);
    ( USERCLK => DBGVECA[22]) = (0, 0);
    ( USERCLK => DBGVECA[23]) = (0, 0);
    ( USERCLK => DBGVECA[24]) = (0, 0);
    ( USERCLK => DBGVECA[25]) = (0, 0);
    ( USERCLK => DBGVECA[26]) = (0, 0);
    ( USERCLK => DBGVECA[27]) = (0, 0);
    ( USERCLK => DBGVECA[28]) = (0, 0);
    ( USERCLK => DBGVECA[29]) = (0, 0);
    ( USERCLK => DBGVECA[2]) = (0, 0);
    ( USERCLK => DBGVECA[30]) = (0, 0);
    ( USERCLK => DBGVECA[31]) = (0, 0);
    ( USERCLK => DBGVECA[32]) = (0, 0);
    ( USERCLK => DBGVECA[33]) = (0, 0);
    ( USERCLK => DBGVECA[34]) = (0, 0);
    ( USERCLK => DBGVECA[35]) = (0, 0);
    ( USERCLK => DBGVECA[36]) = (0, 0);
    ( USERCLK => DBGVECA[37]) = (0, 0);
    ( USERCLK => DBGVECA[38]) = (0, 0);
    ( USERCLK => DBGVECA[39]) = (0, 0);
    ( USERCLK => DBGVECA[3]) = (0, 0);
    ( USERCLK => DBGVECA[40]) = (0, 0);
    ( USERCLK => DBGVECA[41]) = (0, 0);
    ( USERCLK => DBGVECA[42]) = (0, 0);
    ( USERCLK => DBGVECA[43]) = (0, 0);
    ( USERCLK => DBGVECA[44]) = (0, 0);
    ( USERCLK => DBGVECA[45]) = (0, 0);
    ( USERCLK => DBGVECA[46]) = (0, 0);
    ( USERCLK => DBGVECA[47]) = (0, 0);
    ( USERCLK => DBGVECA[48]) = (0, 0);
    ( USERCLK => DBGVECA[49]) = (0, 0);
    ( USERCLK => DBGVECA[4]) = (0, 0);
    ( USERCLK => DBGVECA[50]) = (0, 0);
    ( USERCLK => DBGVECA[51]) = (0, 0);
    ( USERCLK => DBGVECA[52]) = (0, 0);
    ( USERCLK => DBGVECA[53]) = (0, 0);
    ( USERCLK => DBGVECA[54]) = (0, 0);
    ( USERCLK => DBGVECA[55]) = (0, 0);
    ( USERCLK => DBGVECA[56]) = (0, 0);
    ( USERCLK => DBGVECA[57]) = (0, 0);
    ( USERCLK => DBGVECA[58]) = (0, 0);
    ( USERCLK => DBGVECA[59]) = (0, 0);
    ( USERCLK => DBGVECA[5]) = (0, 0);
    ( USERCLK => DBGVECA[60]) = (0, 0);
    ( USERCLK => DBGVECA[61]) = (0, 0);
    ( USERCLK => DBGVECA[62]) = (0, 0);
    ( USERCLK => DBGVECA[63]) = (0, 0);
    ( USERCLK => DBGVECA[6]) = (0, 0);
    ( USERCLK => DBGVECA[7]) = (0, 0);
    ( USERCLK => DBGVECA[8]) = (0, 0);
    ( USERCLK => DBGVECA[9]) = (0, 0);
    ( USERCLK => DBGVECB[0]) = (0, 0);
    ( USERCLK => DBGVECB[10]) = (0, 0);
    ( USERCLK => DBGVECB[11]) = (0, 0);
    ( USERCLK => DBGVECB[12]) = (0, 0);
    ( USERCLK => DBGVECB[13]) = (0, 0);
    ( USERCLK => DBGVECB[14]) = (0, 0);
    ( USERCLK => DBGVECB[15]) = (0, 0);
    ( USERCLK => DBGVECB[16]) = (0, 0);
    ( USERCLK => DBGVECB[17]) = (0, 0);
    ( USERCLK => DBGVECB[18]) = (0, 0);
    ( USERCLK => DBGVECB[19]) = (0, 0);
    ( USERCLK => DBGVECB[1]) = (0, 0);
    ( USERCLK => DBGVECB[20]) = (0, 0);
    ( USERCLK => DBGVECB[21]) = (0, 0);
    ( USERCLK => DBGVECB[22]) = (0, 0);
    ( USERCLK => DBGVECB[23]) = (0, 0);
    ( USERCLK => DBGVECB[24]) = (0, 0);
    ( USERCLK => DBGVECB[25]) = (0, 0);
    ( USERCLK => DBGVECB[26]) = (0, 0);
    ( USERCLK => DBGVECB[27]) = (0, 0);
    ( USERCLK => DBGVECB[28]) = (0, 0);
    ( USERCLK => DBGVECB[29]) = (0, 0);
    ( USERCLK => DBGVECB[2]) = (0, 0);
    ( USERCLK => DBGVECB[30]) = (0, 0);
    ( USERCLK => DBGVECB[31]) = (0, 0);
    ( USERCLK => DBGVECB[32]) = (0, 0);
    ( USERCLK => DBGVECB[33]) = (0, 0);
    ( USERCLK => DBGVECB[34]) = (0, 0);
    ( USERCLK => DBGVECB[35]) = (0, 0);
    ( USERCLK => DBGVECB[36]) = (0, 0);
    ( USERCLK => DBGVECB[37]) = (0, 0);
    ( USERCLK => DBGVECB[38]) = (0, 0);
    ( USERCLK => DBGVECB[39]) = (0, 0);
    ( USERCLK => DBGVECB[3]) = (0, 0);
    ( USERCLK => DBGVECB[40]) = (0, 0);
    ( USERCLK => DBGVECB[41]) = (0, 0);
    ( USERCLK => DBGVECB[42]) = (0, 0);
    ( USERCLK => DBGVECB[43]) = (0, 0);
    ( USERCLK => DBGVECB[44]) = (0, 0);
    ( USERCLK => DBGVECB[45]) = (0, 0);
    ( USERCLK => DBGVECB[46]) = (0, 0);
    ( USERCLK => DBGVECB[47]) = (0, 0);
    ( USERCLK => DBGVECB[48]) = (0, 0);
    ( USERCLK => DBGVECB[49]) = (0, 0);
    ( USERCLK => DBGVECB[4]) = (0, 0);
    ( USERCLK => DBGVECB[50]) = (0, 0);
    ( USERCLK => DBGVECB[51]) = (0, 0);
    ( USERCLK => DBGVECB[52]) = (0, 0);
    ( USERCLK => DBGVECB[53]) = (0, 0);
    ( USERCLK => DBGVECB[54]) = (0, 0);
    ( USERCLK => DBGVECB[55]) = (0, 0);
    ( USERCLK => DBGVECB[56]) = (0, 0);
    ( USERCLK => DBGVECB[57]) = (0, 0);
    ( USERCLK => DBGVECB[58]) = (0, 0);
    ( USERCLK => DBGVECB[59]) = (0, 0);
    ( USERCLK => DBGVECB[5]) = (0, 0);
    ( USERCLK => DBGVECB[60]) = (0, 0);
    ( USERCLK => DBGVECB[61]) = (0, 0);
    ( USERCLK => DBGVECB[62]) = (0, 0);
    ( USERCLK => DBGVECB[63]) = (0, 0);
    ( USERCLK => DBGVECB[6]) = (0, 0);
    ( USERCLK => DBGVECB[7]) = (0, 0);
    ( USERCLK => DBGVECB[8]) = (0, 0);
    ( USERCLK => DBGVECB[9]) = (0, 0);
    ( USERCLK => DBGVECC[0]) = (0, 0);
    ( USERCLK => DBGVECC[10]) = (0, 0);
    ( USERCLK => DBGVECC[11]) = (0, 0);
    ( USERCLK => DBGVECC[1]) = (0, 0);
    ( USERCLK => DBGVECC[2]) = (0, 0);
    ( USERCLK => DBGVECC[3]) = (0, 0);
    ( USERCLK => DBGVECC[4]) = (0, 0);
    ( USERCLK => DBGVECC[5]) = (0, 0);
    ( USERCLK => DBGVECC[6]) = (0, 0);
    ( USERCLK => DBGVECC[7]) = (0, 0);
    ( USERCLK => DBGVECC[8]) = (0, 0);
    ( USERCLK => DBGVECC[9]) = (0, 0);
    ( USERCLK => LL2BADDLLPERRN) = (0, 0);
    ( USERCLK => LL2BADTLPERRN) = (0, 0);
    ( USERCLK => LL2PROTOCOLERRN) = (0, 0);
    ( USERCLK => LL2REPLAYROERRN) = (0, 0);
    ( USERCLK => LL2REPLAYTOERRN) = (0, 0);
    ( USERCLK => LL2SUSPENDOKN) = (0, 0);
    ( USERCLK => LL2TFCINIT1SEQN) = (0, 0);
    ( USERCLK => LL2TFCINIT2SEQN) = (0, 0);
    ( USERCLK => LNKCLKEN) = (0, 0);
    ( USERCLK => MIMRXRADDR[0]) = (0, 0);
    ( USERCLK => MIMRXRADDR[10]) = (0, 0);
    ( USERCLK => MIMRXRADDR[11]) = (0, 0);
    ( USERCLK => MIMRXRADDR[12]) = (0, 0);
    ( USERCLK => MIMRXRADDR[1]) = (0, 0);
    ( USERCLK => MIMRXRADDR[2]) = (0, 0);
    ( USERCLK => MIMRXRADDR[3]) = (0, 0);
    ( USERCLK => MIMRXRADDR[4]) = (0, 0);
    ( USERCLK => MIMRXRADDR[5]) = (0, 0);
    ( USERCLK => MIMRXRADDR[6]) = (0, 0);
    ( USERCLK => MIMRXRADDR[7]) = (0, 0);
    ( USERCLK => MIMRXRADDR[8]) = (0, 0);
    ( USERCLK => MIMRXRADDR[9]) = (0, 0);
    ( USERCLK => MIMRXRCE) = (0, 0);
    ( USERCLK => MIMRXREN) = (0, 0);
    ( USERCLK => MIMRXWADDR[0]) = (0, 0);
    ( USERCLK => MIMRXWADDR[10]) = (0, 0);
    ( USERCLK => MIMRXWADDR[11]) = (0, 0);
    ( USERCLK => MIMRXWADDR[12]) = (0, 0);
    ( USERCLK => MIMRXWADDR[1]) = (0, 0);
    ( USERCLK => MIMRXWADDR[2]) = (0, 0);
    ( USERCLK => MIMRXWADDR[3]) = (0, 0);
    ( USERCLK => MIMRXWADDR[4]) = (0, 0);
    ( USERCLK => MIMRXWADDR[5]) = (0, 0);
    ( USERCLK => MIMRXWADDR[6]) = (0, 0);
    ( USERCLK => MIMRXWADDR[7]) = (0, 0);
    ( USERCLK => MIMRXWADDR[8]) = (0, 0);
    ( USERCLK => MIMRXWADDR[9]) = (0, 0);
    ( USERCLK => MIMRXWDATA[0]) = (0, 0);
    ( USERCLK => MIMRXWDATA[10]) = (0, 0);
    ( USERCLK => MIMRXWDATA[11]) = (0, 0);
    ( USERCLK => MIMRXWDATA[12]) = (0, 0);
    ( USERCLK => MIMRXWDATA[13]) = (0, 0);
    ( USERCLK => MIMRXWDATA[14]) = (0, 0);
    ( USERCLK => MIMRXWDATA[15]) = (0, 0);
    ( USERCLK => MIMRXWDATA[16]) = (0, 0);
    ( USERCLK => MIMRXWDATA[17]) = (0, 0);
    ( USERCLK => MIMRXWDATA[18]) = (0, 0);
    ( USERCLK => MIMRXWDATA[19]) = (0, 0);
    ( USERCLK => MIMRXWDATA[1]) = (0, 0);
    ( USERCLK => MIMRXWDATA[20]) = (0, 0);
    ( USERCLK => MIMRXWDATA[21]) = (0, 0);
    ( USERCLK => MIMRXWDATA[22]) = (0, 0);
    ( USERCLK => MIMRXWDATA[23]) = (0, 0);
    ( USERCLK => MIMRXWDATA[24]) = (0, 0);
    ( USERCLK => MIMRXWDATA[25]) = (0, 0);
    ( USERCLK => MIMRXWDATA[26]) = (0, 0);
    ( USERCLK => MIMRXWDATA[27]) = (0, 0);
    ( USERCLK => MIMRXWDATA[28]) = (0, 0);
    ( USERCLK => MIMRXWDATA[29]) = (0, 0);
    ( USERCLK => MIMRXWDATA[2]) = (0, 0);
    ( USERCLK => MIMRXWDATA[30]) = (0, 0);
    ( USERCLK => MIMRXWDATA[31]) = (0, 0);
    ( USERCLK => MIMRXWDATA[32]) = (0, 0);
    ( USERCLK => MIMRXWDATA[33]) = (0, 0);
    ( USERCLK => MIMRXWDATA[34]) = (0, 0);
    ( USERCLK => MIMRXWDATA[35]) = (0, 0);
    ( USERCLK => MIMRXWDATA[36]) = (0, 0);
    ( USERCLK => MIMRXWDATA[37]) = (0, 0);
    ( USERCLK => MIMRXWDATA[38]) = (0, 0);
    ( USERCLK => MIMRXWDATA[39]) = (0, 0);
    ( USERCLK => MIMRXWDATA[3]) = (0, 0);
    ( USERCLK => MIMRXWDATA[40]) = (0, 0);
    ( USERCLK => MIMRXWDATA[41]) = (0, 0);
    ( USERCLK => MIMRXWDATA[42]) = (0, 0);
    ( USERCLK => MIMRXWDATA[43]) = (0, 0);
    ( USERCLK => MIMRXWDATA[44]) = (0, 0);
    ( USERCLK => MIMRXWDATA[45]) = (0, 0);
    ( USERCLK => MIMRXWDATA[46]) = (0, 0);
    ( USERCLK => MIMRXWDATA[47]) = (0, 0);
    ( USERCLK => MIMRXWDATA[48]) = (0, 0);
    ( USERCLK => MIMRXWDATA[49]) = (0, 0);
    ( USERCLK => MIMRXWDATA[4]) = (0, 0);
    ( USERCLK => MIMRXWDATA[50]) = (0, 0);
    ( USERCLK => MIMRXWDATA[51]) = (0, 0);
    ( USERCLK => MIMRXWDATA[52]) = (0, 0);
    ( USERCLK => MIMRXWDATA[53]) = (0, 0);
    ( USERCLK => MIMRXWDATA[54]) = (0, 0);
    ( USERCLK => MIMRXWDATA[55]) = (0, 0);
    ( USERCLK => MIMRXWDATA[56]) = (0, 0);
    ( USERCLK => MIMRXWDATA[57]) = (0, 0);
    ( USERCLK => MIMRXWDATA[58]) = (0, 0);
    ( USERCLK => MIMRXWDATA[59]) = (0, 0);
    ( USERCLK => MIMRXWDATA[5]) = (0, 0);
    ( USERCLK => MIMRXWDATA[60]) = (0, 0);
    ( USERCLK => MIMRXWDATA[61]) = (0, 0);
    ( USERCLK => MIMRXWDATA[62]) = (0, 0);
    ( USERCLK => MIMRXWDATA[63]) = (0, 0);
    ( USERCLK => MIMRXWDATA[64]) = (0, 0);
    ( USERCLK => MIMRXWDATA[65]) = (0, 0);
    ( USERCLK => MIMRXWDATA[66]) = (0, 0);
    ( USERCLK => MIMRXWDATA[67]) = (0, 0);
    ( USERCLK => MIMRXWDATA[6]) = (0, 0);
    ( USERCLK => MIMRXWDATA[7]) = (0, 0);
    ( USERCLK => MIMRXWDATA[8]) = (0, 0);
    ( USERCLK => MIMRXWDATA[9]) = (0, 0);
    ( USERCLK => MIMRXWEN) = (0, 0);
    ( USERCLK => MIMTXRADDR[0]) = (0, 0);
    ( USERCLK => MIMTXRADDR[10]) = (0, 0);
    ( USERCLK => MIMTXRADDR[11]) = (0, 0);
    ( USERCLK => MIMTXRADDR[12]) = (0, 0);
    ( USERCLK => MIMTXRADDR[1]) = (0, 0);
    ( USERCLK => MIMTXRADDR[2]) = (0, 0);
    ( USERCLK => MIMTXRADDR[3]) = (0, 0);
    ( USERCLK => MIMTXRADDR[4]) = (0, 0);
    ( USERCLK => MIMTXRADDR[5]) = (0, 0);
    ( USERCLK => MIMTXRADDR[6]) = (0, 0);
    ( USERCLK => MIMTXRADDR[7]) = (0, 0);
    ( USERCLK => MIMTXRADDR[8]) = (0, 0);
    ( USERCLK => MIMTXRADDR[9]) = (0, 0);
    ( USERCLK => MIMTXRCE) = (0, 0);
    ( USERCLK => MIMTXREN) = (0, 0);
    ( USERCLK => MIMTXWADDR[0]) = (0, 0);
    ( USERCLK => MIMTXWADDR[10]) = (0, 0);
    ( USERCLK => MIMTXWADDR[11]) = (0, 0);
    ( USERCLK => MIMTXWADDR[12]) = (0, 0);
    ( USERCLK => MIMTXWADDR[1]) = (0, 0);
    ( USERCLK => MIMTXWADDR[2]) = (0, 0);
    ( USERCLK => MIMTXWADDR[3]) = (0, 0);
    ( USERCLK => MIMTXWADDR[4]) = (0, 0);
    ( USERCLK => MIMTXWADDR[5]) = (0, 0);
    ( USERCLK => MIMTXWADDR[6]) = (0, 0);
    ( USERCLK => MIMTXWADDR[7]) = (0, 0);
    ( USERCLK => MIMTXWADDR[8]) = (0, 0);
    ( USERCLK => MIMTXWADDR[9]) = (0, 0);
    ( USERCLK => MIMTXWDATA[0]) = (0, 0);
    ( USERCLK => MIMTXWDATA[10]) = (0, 0);
    ( USERCLK => MIMTXWDATA[11]) = (0, 0);
    ( USERCLK => MIMTXWDATA[12]) = (0, 0);
    ( USERCLK => MIMTXWDATA[13]) = (0, 0);
    ( USERCLK => MIMTXWDATA[14]) = (0, 0);
    ( USERCLK => MIMTXWDATA[15]) = (0, 0);
    ( USERCLK => MIMTXWDATA[16]) = (0, 0);
    ( USERCLK => MIMTXWDATA[17]) = (0, 0);
    ( USERCLK => MIMTXWDATA[18]) = (0, 0);
    ( USERCLK => MIMTXWDATA[19]) = (0, 0);
    ( USERCLK => MIMTXWDATA[1]) = (0, 0);
    ( USERCLK => MIMTXWDATA[20]) = (0, 0);
    ( USERCLK => MIMTXWDATA[21]) = (0, 0);
    ( USERCLK => MIMTXWDATA[22]) = (0, 0);
    ( USERCLK => MIMTXWDATA[23]) = (0, 0);
    ( USERCLK => MIMTXWDATA[24]) = (0, 0);
    ( USERCLK => MIMTXWDATA[25]) = (0, 0);
    ( USERCLK => MIMTXWDATA[26]) = (0, 0);
    ( USERCLK => MIMTXWDATA[27]) = (0, 0);
    ( USERCLK => MIMTXWDATA[28]) = (0, 0);
    ( USERCLK => MIMTXWDATA[29]) = (0, 0);
    ( USERCLK => MIMTXWDATA[2]) = (0, 0);
    ( USERCLK => MIMTXWDATA[30]) = (0, 0);
    ( USERCLK => MIMTXWDATA[31]) = (0, 0);
    ( USERCLK => MIMTXWDATA[32]) = (0, 0);
    ( USERCLK => MIMTXWDATA[33]) = (0, 0);
    ( USERCLK => MIMTXWDATA[34]) = (0, 0);
    ( USERCLK => MIMTXWDATA[35]) = (0, 0);
    ( USERCLK => MIMTXWDATA[36]) = (0, 0);
    ( USERCLK => MIMTXWDATA[37]) = (0, 0);
    ( USERCLK => MIMTXWDATA[38]) = (0, 0);
    ( USERCLK => MIMTXWDATA[39]) = (0, 0);
    ( USERCLK => MIMTXWDATA[3]) = (0, 0);
    ( USERCLK => MIMTXWDATA[40]) = (0, 0);
    ( USERCLK => MIMTXWDATA[41]) = (0, 0);
    ( USERCLK => MIMTXWDATA[42]) = (0, 0);
    ( USERCLK => MIMTXWDATA[43]) = (0, 0);
    ( USERCLK => MIMTXWDATA[44]) = (0, 0);
    ( USERCLK => MIMTXWDATA[45]) = (0, 0);
    ( USERCLK => MIMTXWDATA[46]) = (0, 0);
    ( USERCLK => MIMTXWDATA[47]) = (0, 0);
    ( USERCLK => MIMTXWDATA[48]) = (0, 0);
    ( USERCLK => MIMTXWDATA[49]) = (0, 0);
    ( USERCLK => MIMTXWDATA[4]) = (0, 0);
    ( USERCLK => MIMTXWDATA[50]) = (0, 0);
    ( USERCLK => MIMTXWDATA[51]) = (0, 0);
    ( USERCLK => MIMTXWDATA[52]) = (0, 0);
    ( USERCLK => MIMTXWDATA[53]) = (0, 0);
    ( USERCLK => MIMTXWDATA[54]) = (0, 0);
    ( USERCLK => MIMTXWDATA[55]) = (0, 0);
    ( USERCLK => MIMTXWDATA[56]) = (0, 0);
    ( USERCLK => MIMTXWDATA[57]) = (0, 0);
    ( USERCLK => MIMTXWDATA[58]) = (0, 0);
    ( USERCLK => MIMTXWDATA[59]) = (0, 0);
    ( USERCLK => MIMTXWDATA[5]) = (0, 0);
    ( USERCLK => MIMTXWDATA[60]) = (0, 0);
    ( USERCLK => MIMTXWDATA[61]) = (0, 0);
    ( USERCLK => MIMTXWDATA[62]) = (0, 0);
    ( USERCLK => MIMTXWDATA[63]) = (0, 0);
    ( USERCLK => MIMTXWDATA[64]) = (0, 0);
    ( USERCLK => MIMTXWDATA[65]) = (0, 0);
    ( USERCLK => MIMTXWDATA[66]) = (0, 0);
    ( USERCLK => MIMTXWDATA[67]) = (0, 0);
    ( USERCLK => MIMTXWDATA[68]) = (0, 0);
    ( USERCLK => MIMTXWDATA[6]) = (0, 0);
    ( USERCLK => MIMTXWDATA[7]) = (0, 0);
    ( USERCLK => MIMTXWDATA[8]) = (0, 0);
    ( USERCLK => MIMTXWDATA[9]) = (0, 0);
    ( USERCLK => MIMTXWEN) = (0, 0);
    ( USERCLK => PL2LINKUPN) = (0, 0);
    ( USERCLK => PL2RECEIVERERRN) = (0, 0);
    ( USERCLK => PL2RECOVERYN) = (0, 0);
    ( USERCLK => PL2RXELECIDLE) = (0, 0);
    ( USERCLK => PL2SUSPENDOK) = (0, 0);
    ( USERCLK => RECEIVEDFUNCLVLRSTN) = (0, 0);
    ( USERCLK => TL2ASPMSUSPENDCREDITCHECKOKN) = (0, 0);
    ( USERCLK => TL2ASPMSUSPENDREQN) = (0, 0);
    ( USERCLK => TL2PPMSUSPENDOKN) = (0, 0);
    ( USERCLK => TRNFCCPLD[0]) = (0, 0);
    ( USERCLK => TRNFCCPLD[10]) = (0, 0);
    ( USERCLK => TRNFCCPLD[11]) = (0, 0);
    ( USERCLK => TRNFCCPLD[1]) = (0, 0);
    ( USERCLK => TRNFCCPLD[2]) = (0, 0);
    ( USERCLK => TRNFCCPLD[3]) = (0, 0);
    ( USERCLK => TRNFCCPLD[4]) = (0, 0);
    ( USERCLK => TRNFCCPLD[5]) = (0, 0);
    ( USERCLK => TRNFCCPLD[6]) = (0, 0);
    ( USERCLK => TRNFCCPLD[7]) = (0, 0);
    ( USERCLK => TRNFCCPLD[8]) = (0, 0);
    ( USERCLK => TRNFCCPLD[9]) = (0, 0);
    ( USERCLK => TRNFCCPLH[0]) = (0, 0);
    ( USERCLK => TRNFCCPLH[1]) = (0, 0);
    ( USERCLK => TRNFCCPLH[2]) = (0, 0);
    ( USERCLK => TRNFCCPLH[3]) = (0, 0);
    ( USERCLK => TRNFCCPLH[4]) = (0, 0);
    ( USERCLK => TRNFCCPLH[5]) = (0, 0);
    ( USERCLK => TRNFCCPLH[6]) = (0, 0);
    ( USERCLK => TRNFCCPLH[7]) = (0, 0);
    ( USERCLK => TRNFCNPD[0]) = (0, 0);
    ( USERCLK => TRNFCNPD[10]) = (0, 0);
    ( USERCLK => TRNFCNPD[11]) = (0, 0);
    ( USERCLK => TRNFCNPD[1]) = (0, 0);
    ( USERCLK => TRNFCNPD[2]) = (0, 0);
    ( USERCLK => TRNFCNPD[3]) = (0, 0);
    ( USERCLK => TRNFCNPD[4]) = (0, 0);
    ( USERCLK => TRNFCNPD[5]) = (0, 0);
    ( USERCLK => TRNFCNPD[6]) = (0, 0);
    ( USERCLK => TRNFCNPD[7]) = (0, 0);
    ( USERCLK => TRNFCNPD[8]) = (0, 0);
    ( USERCLK => TRNFCNPD[9]) = (0, 0);
    ( USERCLK => TRNFCNPH[0]) = (0, 0);
    ( USERCLK => TRNFCNPH[1]) = (0, 0);
    ( USERCLK => TRNFCNPH[2]) = (0, 0);
    ( USERCLK => TRNFCNPH[3]) = (0, 0);
    ( USERCLK => TRNFCNPH[4]) = (0, 0);
    ( USERCLK => TRNFCNPH[5]) = (0, 0);
    ( USERCLK => TRNFCNPH[6]) = (0, 0);
    ( USERCLK => TRNFCNPH[7]) = (0, 0);
    ( USERCLK => TRNFCPD[0]) = (0, 0);
    ( USERCLK => TRNFCPD[10]) = (0, 0);
    ( USERCLK => TRNFCPD[11]) = (0, 0);
    ( USERCLK => TRNFCPD[1]) = (0, 0);
    ( USERCLK => TRNFCPD[2]) = (0, 0);
    ( USERCLK => TRNFCPD[3]) = (0, 0);
    ( USERCLK => TRNFCPD[4]) = (0, 0);
    ( USERCLK => TRNFCPD[5]) = (0, 0);
    ( USERCLK => TRNFCPD[6]) = (0, 0);
    ( USERCLK => TRNFCPD[7]) = (0, 0);
    ( USERCLK => TRNFCPD[8]) = (0, 0);
    ( USERCLK => TRNFCPD[9]) = (0, 0);
    ( USERCLK => TRNFCPH[0]) = (0, 0);
    ( USERCLK => TRNFCPH[1]) = (0, 0);
    ( USERCLK => TRNFCPH[2]) = (0, 0);
    ( USERCLK => TRNFCPH[3]) = (0, 0);
    ( USERCLK => TRNFCPH[4]) = (0, 0);
    ( USERCLK => TRNFCPH[5]) = (0, 0);
    ( USERCLK => TRNFCPH[6]) = (0, 0);
    ( USERCLK => TRNFCPH[7]) = (0, 0);
    ( USERCLK => TRNLNKUPN) = (0, 0);
    ( USERCLK => TRNRBARHITN[0]) = (0, 0);
    ( USERCLK => TRNRBARHITN[1]) = (0, 0);
    ( USERCLK => TRNRBARHITN[2]) = (0, 0);
    ( USERCLK => TRNRBARHITN[3]) = (0, 0);
    ( USERCLK => TRNRBARHITN[4]) = (0, 0);
    ( USERCLK => TRNRBARHITN[5]) = (0, 0);
    ( USERCLK => TRNRBARHITN[6]) = (0, 0);
    ( USERCLK => TRNRDLLPDATA[0]) = (0, 0);
    ( USERCLK => TRNRDLLPDATA[10]) = (0, 0);
    ( USERCLK => TRNRDLLPDATA[11]) = (0, 0);
    ( USERCLK => TRNRDLLPDATA[12]) = (0, 0);
    ( USERCLK => TRNRDLLPDATA[13]) = (0, 0);
    ( USERCLK => TRNRDLLPDATA[14]) = (0, 0);
    ( USERCLK => TRNRDLLPDATA[15]) = (0, 0);
    ( USERCLK => TRNRDLLPDATA[16]) = (0, 0);
    ( USERCLK => TRNRDLLPDATA[17]) = (0, 0);
    ( USERCLK => TRNRDLLPDATA[18]) = (0, 0);
    ( USERCLK => TRNRDLLPDATA[19]) = (0, 0);
    ( USERCLK => TRNRDLLPDATA[1]) = (0, 0);
    ( USERCLK => TRNRDLLPDATA[20]) = (0, 0);
    ( USERCLK => TRNRDLLPDATA[21]) = (0, 0);
    ( USERCLK => TRNRDLLPDATA[22]) = (0, 0);
    ( USERCLK => TRNRDLLPDATA[23]) = (0, 0);
    ( USERCLK => TRNRDLLPDATA[24]) = (0, 0);
    ( USERCLK => TRNRDLLPDATA[25]) = (0, 0);
    ( USERCLK => TRNRDLLPDATA[26]) = (0, 0);
    ( USERCLK => TRNRDLLPDATA[27]) = (0, 0);
    ( USERCLK => TRNRDLLPDATA[28]) = (0, 0);
    ( USERCLK => TRNRDLLPDATA[29]) = (0, 0);
    ( USERCLK => TRNRDLLPDATA[2]) = (0, 0);
    ( USERCLK => TRNRDLLPDATA[30]) = (0, 0);
    ( USERCLK => TRNRDLLPDATA[31]) = (0, 0);
    ( USERCLK => TRNRDLLPDATA[3]) = (0, 0);
    ( USERCLK => TRNRDLLPDATA[4]) = (0, 0);
    ( USERCLK => TRNRDLLPDATA[5]) = (0, 0);
    ( USERCLK => TRNRDLLPDATA[6]) = (0, 0);
    ( USERCLK => TRNRDLLPDATA[7]) = (0, 0);
    ( USERCLK => TRNRDLLPDATA[8]) = (0, 0);
    ( USERCLK => TRNRDLLPDATA[9]) = (0, 0);
    ( USERCLK => TRNRDLLPSRCRDYN) = (0, 0);
    ( USERCLK => TRNRD[0]) = (0, 0);
    ( USERCLK => TRNRD[10]) = (0, 0);
    ( USERCLK => TRNRD[11]) = (0, 0);
    ( USERCLK => TRNRD[12]) = (0, 0);
    ( USERCLK => TRNRD[13]) = (0, 0);
    ( USERCLK => TRNRD[14]) = (0, 0);
    ( USERCLK => TRNRD[15]) = (0, 0);
    ( USERCLK => TRNRD[16]) = (0, 0);
    ( USERCLK => TRNRD[17]) = (0, 0);
    ( USERCLK => TRNRD[18]) = (0, 0);
    ( USERCLK => TRNRD[19]) = (0, 0);
    ( USERCLK => TRNRD[1]) = (0, 0);
    ( USERCLK => TRNRD[20]) = (0, 0);
    ( USERCLK => TRNRD[21]) = (0, 0);
    ( USERCLK => TRNRD[22]) = (0, 0);
    ( USERCLK => TRNRD[23]) = (0, 0);
    ( USERCLK => TRNRD[24]) = (0, 0);
    ( USERCLK => TRNRD[25]) = (0, 0);
    ( USERCLK => TRNRD[26]) = (0, 0);
    ( USERCLK => TRNRD[27]) = (0, 0);
    ( USERCLK => TRNRD[28]) = (0, 0);
    ( USERCLK => TRNRD[29]) = (0, 0);
    ( USERCLK => TRNRD[2]) = (0, 0);
    ( USERCLK => TRNRD[30]) = (0, 0);
    ( USERCLK => TRNRD[31]) = (0, 0);
    ( USERCLK => TRNRD[32]) = (0, 0);
    ( USERCLK => TRNRD[33]) = (0, 0);
    ( USERCLK => TRNRD[34]) = (0, 0);
    ( USERCLK => TRNRD[35]) = (0, 0);
    ( USERCLK => TRNRD[36]) = (0, 0);
    ( USERCLK => TRNRD[37]) = (0, 0);
    ( USERCLK => TRNRD[38]) = (0, 0);
    ( USERCLK => TRNRD[39]) = (0, 0);
    ( USERCLK => TRNRD[3]) = (0, 0);
    ( USERCLK => TRNRD[40]) = (0, 0);
    ( USERCLK => TRNRD[41]) = (0, 0);
    ( USERCLK => TRNRD[42]) = (0, 0);
    ( USERCLK => TRNRD[43]) = (0, 0);
    ( USERCLK => TRNRD[44]) = (0, 0);
    ( USERCLK => TRNRD[45]) = (0, 0);
    ( USERCLK => TRNRD[46]) = (0, 0);
    ( USERCLK => TRNRD[47]) = (0, 0);
    ( USERCLK => TRNRD[48]) = (0, 0);
    ( USERCLK => TRNRD[49]) = (0, 0);
    ( USERCLK => TRNRD[4]) = (0, 0);
    ( USERCLK => TRNRD[50]) = (0, 0);
    ( USERCLK => TRNRD[51]) = (0, 0);
    ( USERCLK => TRNRD[52]) = (0, 0);
    ( USERCLK => TRNRD[53]) = (0, 0);
    ( USERCLK => TRNRD[54]) = (0, 0);
    ( USERCLK => TRNRD[55]) = (0, 0);
    ( USERCLK => TRNRD[56]) = (0, 0);
    ( USERCLK => TRNRD[57]) = (0, 0);
    ( USERCLK => TRNRD[58]) = (0, 0);
    ( USERCLK => TRNRD[59]) = (0, 0);
    ( USERCLK => TRNRD[5]) = (0, 0);
    ( USERCLK => TRNRD[60]) = (0, 0);
    ( USERCLK => TRNRD[61]) = (0, 0);
    ( USERCLK => TRNRD[62]) = (0, 0);
    ( USERCLK => TRNRD[63]) = (0, 0);
    ( USERCLK => TRNRD[6]) = (0, 0);
    ( USERCLK => TRNRD[7]) = (0, 0);
    ( USERCLK => TRNRD[8]) = (0, 0);
    ( USERCLK => TRNRD[9]) = (0, 0);
    ( USERCLK => TRNRECRCERRN) = (0, 0);
    ( USERCLK => TRNREOFN) = (0, 0);
    ( USERCLK => TRNRERRFWDN) = (0, 0);
    ( USERCLK => TRNRREMN) = (0, 0);
    ( USERCLK => TRNRSOFN) = (0, 0);
    ( USERCLK => TRNRSRCDSCN) = (0, 0);
    ( USERCLK => TRNRSRCRDYN) = (0, 0);
    ( USERCLK => TRNTBUFAV[0]) = (0, 0);
    ( USERCLK => TRNTBUFAV[1]) = (0, 0);
    ( USERCLK => TRNTBUFAV[2]) = (0, 0);
    ( USERCLK => TRNTBUFAV[3]) = (0, 0);
    ( USERCLK => TRNTBUFAV[4]) = (0, 0);
    ( USERCLK => TRNTBUFAV[5]) = (0, 0);
    ( USERCLK => TRNTCFGREQN) = (0, 0);
    ( USERCLK => TRNTDLLPDSTRDYN) = (0, 0);
    ( USERCLK => TRNTDSTRDYN) = (0, 0);
    ( USERCLK => TRNTERRDROPN) = (0, 0);
    ( USERCLK => USERRSTN) = (0, 0);

    specparam PATHPULSE$ = 0;
  endspecify
endmodule
